/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.bouncycastle.pqc.jcajce.provider.xmss;

import de.businesslogics.bouncycastle.asn1.ASN1ObjectIdentifier;
import de.businesslogics.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import de.businesslogics.bouncycastle.pqc.crypto.util.PublicKeyFactory;
import de.businesslogics.bouncycastle.pqc.crypto.util.SubjectPublicKeyInfoFactory;
import de.businesslogics.bouncycastle.pqc.crypto.xmss.XMSSPublicKeyParameters;
import de.businesslogics.bouncycastle.pqc.jcajce.provider.xmss.DigestUtil;
import de.businesslogics.bouncycastle.util.Arrays;
import java.io.IOException;
import java.security.PublicKey;

public class BCXMSSPublicKey
implements PublicKey {
    private transient XMSSPublicKeyParameters keyParams;
    private transient ASN1ObjectIdentifier treeDigest;

    public BCXMSSPublicKey(SubjectPublicKeyInfo subjectPublicKeyInfo) throws IOException {
        this.init(subjectPublicKeyInfo);
    }

    private void init(SubjectPublicKeyInfo subjectPublicKeyInfo) throws IOException {
        this.keyParams = (XMSSPublicKeyParameters)PublicKeyFactory.createKey(subjectPublicKeyInfo);
        this.treeDigest = DigestUtil.getDigestOID(this.keyParams.getTreeDigest());
    }

    public final String getAlgorithm() {
        return "XMSS";
    }

    public byte[] getEncoded() {
        try {
            SubjectPublicKeyInfo subjectPublicKeyInfo = SubjectPublicKeyInfoFactory.createSubjectPublicKeyInfo(this.keyParams);
            return subjectPublicKeyInfo.getEncoded();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public String getFormat() {
        return "X.509";
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof BCXMSSPublicKey) {
            BCXMSSPublicKey bCXMSSPublicKey = (BCXMSSPublicKey)object;
            try {
                return this.treeDigest.equals(bCXMSSPublicKey.treeDigest) && Arrays.areEqual(this.keyParams.getEncoded(), bCXMSSPublicKey.keyParams.getEncoded());
            }
            catch (IOException iOException) {
                return false;
            }
        }
        return false;
    }

    public int hashCode() {
        try {
            return this.treeDigest.hashCode() + 37 * Arrays.hashCode(this.keyParams.getEncoded());
        }
        catch (IOException iOException) {
            return this.treeDigest.hashCode();
        }
    }
}

