/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.bouncycastle.pqc.jcajce.provider.picnic;

import de.businesslogics.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import de.businesslogics.bouncycastle.pqc.crypto.picnic.PicnicPublicKeyParameters;
import de.businesslogics.bouncycastle.pqc.crypto.util.PublicKeyFactory;
import de.businesslogics.bouncycastle.pqc.crypto.util.SubjectPublicKeyInfoFactory;
import de.businesslogics.bouncycastle.pqc.jcajce.interfaces.PicnicKey;
import de.businesslogics.bouncycastle.util.Arrays;
import java.io.IOException;
import java.security.PublicKey;

public class BCPicnicPublicKey
implements PicnicKey,
PublicKey {
    private transient PicnicPublicKeyParameters params;

    public BCPicnicPublicKey(SubjectPublicKeyInfo subjectPublicKeyInfo) throws IOException {
        this.init(subjectPublicKeyInfo);
    }

    private void init(SubjectPublicKeyInfo subjectPublicKeyInfo) throws IOException {
        this.params = (PicnicPublicKeyParameters)PublicKeyFactory.createKey(subjectPublicKeyInfo);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof BCPicnicPublicKey) {
            BCPicnicPublicKey bCPicnicPublicKey = (BCPicnicPublicKey)object;
            return Arrays.areEqual(this.params.getEncoded(), bCPicnicPublicKey.params.getEncoded());
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(this.params.getEncoded());
    }

    public final String getAlgorithm() {
        return "Picnic";
    }

    public byte[] getEncoded() {
        try {
            SubjectPublicKeyInfo subjectPublicKeyInfo = SubjectPublicKeyInfoFactory.createSubjectPublicKeyInfo(this.params);
            return subjectPublicKeyInfo.getEncoded();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public String getFormat() {
        return "X.509";
    }
}

