/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.bouncycastle.pqc.jcajce.provider.newhope;

import de.businesslogics.bouncycastle.asn1.ASN1Set;
import de.businesslogics.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import de.businesslogics.bouncycastle.pqc.crypto.newhope.NHPrivateKeyParameters;
import de.businesslogics.bouncycastle.pqc.crypto.util.PrivateKeyFactory;
import de.businesslogics.bouncycastle.pqc.crypto.util.PrivateKeyInfoFactory;
import de.businesslogics.bouncycastle.pqc.jcajce.interfaces.NHPrivateKey;
import de.businesslogics.bouncycastle.util.Arrays;
import java.io.IOException;

public class BCNHPrivateKey
implements NHPrivateKey {
    private transient NHPrivateKeyParameters params;
    private transient ASN1Set attributes;

    public BCNHPrivateKey(PrivateKeyInfo privateKeyInfo) throws IOException {
        this.init(privateKeyInfo);
    }

    private void init(PrivateKeyInfo privateKeyInfo) throws IOException {
        this.attributes = privateKeyInfo.getAttributes();
        this.params = (NHPrivateKeyParameters)PrivateKeyFactory.createKey(privateKeyInfo);
    }

    public boolean equals(Object object) {
        if (!(object instanceof BCNHPrivateKey)) {
            return false;
        }
        BCNHPrivateKey bCNHPrivateKey = (BCNHPrivateKey)object;
        return Arrays.areEqual(this.params.getSecData(), bCNHPrivateKey.params.getSecData());
    }

    public int hashCode() {
        return Arrays.hashCode(this.params.getSecData());
    }

    public final String getAlgorithm() {
        return "NH";
    }

    public byte[] getEncoded() {
        try {
            PrivateKeyInfo privateKeyInfo = PrivateKeyInfoFactory.createPrivateKeyInfo(this.params, this.attributes);
            return privateKeyInfo.getEncoded();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public String getFormat() {
        return "PKCS#8";
    }
}

