/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.bouncycastle.pqc.jcajce.provider.kyber;

import de.businesslogics.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import de.businesslogics.bouncycastle.pqc.crypto.crystals.kyber.KyberPublicKeyParameters;
import de.businesslogics.bouncycastle.pqc.crypto.util.PublicKeyFactory;
import de.businesslogics.bouncycastle.pqc.jcajce.interfaces.KyberPublicKey;
import de.businesslogics.bouncycastle.pqc.jcajce.provider.util.KeyUtil;
import de.businesslogics.bouncycastle.util.Arrays;
import de.businesslogics.bouncycastle.util.Strings;
import java.io.IOException;

public class BCKyberPublicKey
implements KyberPublicKey {
    private transient KyberPublicKeyParameters params;
    private transient String algorithm;
    private transient byte[] encoding;

    public BCKyberPublicKey(SubjectPublicKeyInfo subjectPublicKeyInfo) throws IOException {
        this.init(subjectPublicKeyInfo);
    }

    private void init(SubjectPublicKeyInfo subjectPublicKeyInfo) throws IOException {
        this.init((KyberPublicKeyParameters)PublicKeyFactory.createKey(subjectPublicKeyInfo));
    }

    private void init(KyberPublicKeyParameters kyberPublicKeyParameters) {
        this.params = kyberPublicKeyParameters;
        this.algorithm = Strings.toUpperCase(kyberPublicKeyParameters.getParameters().getName());
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof BCKyberPublicKey) {
            BCKyberPublicKey bCKyberPublicKey = (BCKyberPublicKey)object;
            return Arrays.areEqual(this.getEncoded(), bCKyberPublicKey.getEncoded());
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(this.getEncoded());
    }

    public final String getAlgorithm() {
        return this.algorithm;
    }

    public byte[] getEncoded() {
        if (this.encoding == null) {
            this.encoding = KeyUtil.getEncodedSubjectPublicKeyInfo(this.params);
        }
        return Arrays.clone(this.encoding);
    }

    public String getFormat() {
        return "X.509";
    }
}

