/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.bouncycastle.pqc.jcajce.provider.dilithium;

import de.businesslogics.bouncycastle.asn1.ASN1Set;
import de.businesslogics.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import de.businesslogics.bouncycastle.pqc.crypto.crystals.dilithium.DilithiumPrivateKeyParameters;
import de.businesslogics.bouncycastle.pqc.crypto.util.PrivateKeyFactory;
import de.businesslogics.bouncycastle.pqc.jcajce.interfaces.DilithiumPrivateKey;
import de.businesslogics.bouncycastle.pqc.jcajce.provider.util.KeyUtil;
import de.businesslogics.bouncycastle.util.Arrays;
import de.businesslogics.bouncycastle.util.Strings;
import java.io.IOException;

public class BCDilithiumPrivateKey
implements DilithiumPrivateKey {
    private transient DilithiumPrivateKeyParameters params;
    private transient String algorithm;
    private transient byte[] encoding;
    private transient ASN1Set attributes;

    public BCDilithiumPrivateKey(PrivateKeyInfo privateKeyInfo) throws IOException {
        this.init(privateKeyInfo);
    }

    private void init(PrivateKeyInfo privateKeyInfo) throws IOException {
        this.init((DilithiumPrivateKeyParameters)PrivateKeyFactory.createKey(privateKeyInfo), privateKeyInfo.getAttributes());
    }

    private void init(DilithiumPrivateKeyParameters dilithiumPrivateKeyParameters, ASN1Set aSN1Set) {
        this.attributes = aSN1Set;
        this.params = dilithiumPrivateKeyParameters;
        this.algorithm = Strings.toUpperCase(dilithiumPrivateKeyParameters.getParameters().getName());
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof BCDilithiumPrivateKey) {
            BCDilithiumPrivateKey bCDilithiumPrivateKey = (BCDilithiumPrivateKey)object;
            return Arrays.areEqual(this.getEncoded(), bCDilithiumPrivateKey.getEncoded());
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(this.getEncoded());
    }

    public final String getAlgorithm() {
        return this.algorithm;
    }

    public byte[] getEncoded() {
        if (this.encoding == null) {
            this.encoding = KeyUtil.getEncodedPrivateKeyInfo(this.params, this.attributes);
        }
        return Arrays.clone(this.encoding);
    }

    public String getFormat() {
        return "PKCS#8";
    }
}

