/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.bouncycastle.pqc.jcajce.provider.bike;

import de.businesslogics.bouncycastle.asn1.ASN1Set;
import de.businesslogics.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import de.businesslogics.bouncycastle.pqc.crypto.bike.BIKEPrivateKeyParameters;
import de.businesslogics.bouncycastle.pqc.crypto.util.PrivateKeyFactory;
import de.businesslogics.bouncycastle.pqc.crypto.util.PrivateKeyInfoFactory;
import de.businesslogics.bouncycastle.pqc.jcajce.interfaces.BIKEKey;
import de.businesslogics.bouncycastle.util.Arrays;
import de.businesslogics.bouncycastle.util.Strings;
import java.io.IOException;
import java.security.PrivateKey;

public class BCBIKEPrivateKey
implements BIKEKey,
PrivateKey {
    private transient BIKEPrivateKeyParameters params;
    private transient ASN1Set attributes;

    public BCBIKEPrivateKey(PrivateKeyInfo privateKeyInfo) throws IOException {
        this.init(privateKeyInfo);
    }

    private void init(PrivateKeyInfo privateKeyInfo) throws IOException {
        this.attributes = privateKeyInfo.getAttributes();
        this.params = (BIKEPrivateKeyParameters)PrivateKeyFactory.createKey(privateKeyInfo);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof BCBIKEPrivateKey) {
            BCBIKEPrivateKey bCBIKEPrivateKey = (BCBIKEPrivateKey)object;
            return Arrays.areEqual(this.params.getEncoded(), bCBIKEPrivateKey.params.getEncoded());
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(this.params.getEncoded());
    }

    public final String getAlgorithm() {
        return Strings.toUpperCase(this.params.getParameters().getName());
    }

    public byte[] getEncoded() {
        try {
            PrivateKeyInfo privateKeyInfo = PrivateKeyInfoFactory.createPrivateKeyInfo(this.params, this.attributes);
            return privateKeyInfo.getEncoded();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public String getFormat() {
        return "PKCS#8";
    }
}

