/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.bouncycastle.pqc.crypto.crystals.kyber;

import de.businesslogics.bouncycastle.pqc.crypto.crystals.kyber.KyberEngine;
import de.businesslogics.bouncycastle.pqc.crypto.crystals.kyber.KyberKeyParameters;
import de.businesslogics.bouncycastle.pqc.crypto.crystals.kyber.KyberParameters;
import de.businesslogics.bouncycastle.util.Arrays;

public class KyberPrivateKeyParameters
extends KyberKeyParameters {
    final byte[] s;
    final byte[] hpk;
    final byte[] nonce;
    final byte[] t;
    final byte[] rho;

    public KyberPrivateKeyParameters(KyberParameters kyberParameters, byte[] byArray) {
        super(true, kyberParameters);
        KyberEngine kyberEngine = kyberParameters.getEngine();
        int n = 0;
        this.s = Arrays.copyOfRange(byArray, 0, kyberEngine.getKyberIndCpaSecretKeyBytes());
        this.t = Arrays.copyOfRange(byArray, n += kyberEngine.getKyberIndCpaSecretKeyBytes(), n + kyberEngine.getKyberIndCpaPublicKeyBytes() - 32);
        this.rho = Arrays.copyOfRange(byArray, n += kyberEngine.getKyberIndCpaPublicKeyBytes() - 32, n + 32);
        this.hpk = Arrays.copyOfRange(byArray, n += 32, n + 32);
        this.nonce = Arrays.copyOfRange(byArray, n += 32, n + 32);
    }

    public byte[] getEncoded() {
        return Arrays.concatenate(new byte[][]{this.s, this.t, this.rho, this.hpk, this.nonce});
    }
}

