/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.bouncycastle.math.ec.rfc8032;

import de.businesslogics.bouncycastle.crypto.Xof;
import de.businesslogics.bouncycastle.crypto.digests.SHAKEDigest;
import de.businesslogics.bouncycastle.math.ec.rfc7748.X448;
import de.businesslogics.bouncycastle.math.ec.rfc7748.X448Field;
import de.businesslogics.bouncycastle.math.ec.rfc8032.Scalar448;

public abstract class Ed448 {
    private static final byte[] DOM4_PREFIX = new byte[]{83, 105, 103, 69, 100, 52, 52, 56};
    private static final int[] P = new int[]{-1, -1, -1, -1, -1, -1, -1, -2, -1, -1, -1, -1, -1, -1};
    private static final int[] B_x = new int[]{118276190, 40534716, 9670182, 135141552, 85017403, 259173222, 68333082, 171784774, 174973732, 15824510, 73756743, 57518561, 94773951, 248652241, 107736333, 82941708};
    private static final int[] B_y = new int[]{36764180, 8885695, 130592152, 20104429, 163904957, 30304195, 121295871, 5901357, 125344798, 171541512, 175338348, 209069246, 3626697, 38307682, 24032956, 110359655};
    private static final int[] B225_x = new int[]{110141154, 30892124, 160820362, 264558960, 217232225, 47722141, 19029845, 8326902, 183409749, 170134547, 90340180, 222600478, 61097333, 7431335, 198491505, 102372861};
    private static final int[] B225_y = new int[]{221945828, 50763449, 132637478, 109250759, 216053960, 61612587, 50649998, 138339097, 98949899, 248139835, 186410297, 126520782, 47339196, 78164062, 198835543, 169622712};
    private static final Object PRECOMP_LOCK = new Object();
    private static PointAffine[] PRECOMP_BASE_WNAF = null;
    private static PointAffine[] PRECOMP_BASE225_WNAF = null;
    private static int[] PRECOMP_BASE_COMB = null;

    private static int checkPoint(PointAffine pointAffine) {
        int[] nArray = F.create();
        int[] nArray2 = F.create();
        int[] nArray3 = F.create();
        F.sqr(pointAffine.x, nArray2);
        F.sqr(pointAffine.y, nArray3);
        F.mul(nArray2, nArray3, nArray);
        F.add(nArray2, nArray3, nArray2);
        F.mul(nArray, 39081, nArray);
        F.subOne(nArray);
        F.add(nArray, nArray2, nArray);
        F.normalize(nArray);
        F.normalize(nArray3);
        return F.isZero(nArray) & ~F.isZero(nArray3);
    }

    private static int checkPoint(PointProjective pointProjective) {
        int[] nArray = F.create();
        int[] nArray2 = F.create();
        int[] nArray3 = F.create();
        int[] nArray4 = F.create();
        F.sqr(pointProjective.x, nArray2);
        F.sqr(pointProjective.y, nArray3);
        F.sqr(pointProjective.z, nArray4);
        F.mul(nArray2, nArray3, nArray);
        F.add(nArray2, nArray3, nArray2);
        F.mul(nArray2, nArray4, nArray2);
        F.sqr(nArray4, nArray4);
        F.mul(nArray, 39081, nArray);
        F.sub(nArray, nArray4, nArray);
        F.add(nArray, nArray2, nArray);
        F.normalize(nArray);
        F.normalize(nArray3);
        F.normalize(nArray4);
        return F.isZero(nArray) & ~F.isZero(nArray3) & ~F.isZero(nArray4);
    }

    private static Xof createXof() {
        return new SHAKEDigest(256);
    }

    public static void encodePublicPoint(PublicPoint publicPoint, byte[] byArray, int n) {
        F.encode(publicPoint.data, 16, byArray, n);
        byArray[n + 57 - 1] = (byte)((publicPoint.data[0] & 1) << 7);
    }

    private static PublicPoint exportPoint(PointAffine pointAffine) {
        int[] nArray = new int[32];
        F.copy(pointAffine.x, 0, nArray, 0);
        F.copy(pointAffine.y, 0, nArray, 16);
        return new PublicPoint(nArray);
    }

    public static PublicPoint generatePublicKey(byte[] byArray, int n) {
        Xof xof = Ed448.createXof();
        byte[] byArray2 = new byte[114];
        xof.update(byArray, n, 57);
        xof.doFinal(byArray2, 0, byArray2.length);
        byte[] byArray3 = new byte[57];
        Ed448.pruneScalar(byArray2, 0, byArray3);
        PointProjective pointProjective = new PointProjective();
        Ed448.scalarMultBase(byArray3, pointProjective);
        PointAffine pointAffine = new PointAffine();
        Ed448.normalizeToAffine(pointProjective, pointAffine);
        if (0 == Ed448.checkPoint(pointAffine)) {
            throw new IllegalStateException();
        }
        return Ed448.exportPoint(pointAffine);
    }

    private static void invertZs(PointProjective[] pointProjectiveArray) {
        int n = pointProjectiveArray.length;
        int[] nArray = F.createTable(n);
        int[] nArray2 = F.create();
        F.copy(pointProjectiveArray[0].z, 0, nArray2, 0);
        F.copy(nArray2, 0, nArray, 0);
        int n2 = 0;
        while (++n2 < n) {
            F.mul(nArray2, pointProjectiveArray[n2].z, nArray2);
            F.copy(nArray2, 0, nArray, n2 * 16);
        }
        F.invVar(nArray2, nArray2);
        --n2;
        int[] nArray3 = F.create();
        while (n2 > 0) {
            int n3 = n2--;
            F.copy(nArray, n2 * 16, nArray3, 0);
            F.mul(nArray3, nArray2, nArray3);
            F.mul(nArray2, pointProjectiveArray[n3].z, nArray2);
            F.copy(nArray3, 0, pointProjectiveArray[n3].z, 0);
        }
        F.copy(nArray2, 0, pointProjectiveArray[0].z, 0);
    }

    private static void normalizeToAffine(PointProjective pointProjective, PointAffine pointAffine) {
        F.inv(pointProjective.z, pointAffine.y);
        F.mul(pointAffine.y, pointProjective.x, pointAffine.x);
        F.mul(pointAffine.y, pointProjective.y, pointAffine.y);
        F.normalize(pointAffine.x);
        F.normalize(pointAffine.y);
    }

    private static void pointAdd(PointAffine pointAffine, PointProjective pointProjective, PointTemp pointTemp) {
        int[] nArray = pointTemp.r1;
        int[] nArray2 = pointTemp.r2;
        int[] nArray3 = pointTemp.r3;
        int[] nArray4 = pointTemp.r4;
        int[] nArray5 = pointTemp.r5;
        int[] nArray6 = pointTemp.r6;
        int[] nArray7 = pointTemp.r7;
        F.sqr(pointProjective.z, nArray);
        F.mul(pointAffine.x, pointProjective.x, nArray2);
        F.mul(pointAffine.y, pointProjective.y, nArray3);
        F.mul(nArray2, nArray3, nArray4);
        F.mul(nArray4, 39081, nArray4);
        F.add(nArray, nArray4, nArray5);
        F.sub(nArray, nArray4, nArray6);
        F.add(pointAffine.y, pointAffine.x, nArray7);
        F.add(pointProjective.y, pointProjective.x, nArray4);
        F.mul(nArray7, nArray4, nArray7);
        F.add(nArray3, nArray2, nArray);
        F.sub(nArray3, nArray2, nArray4);
        F.carry(nArray);
        F.sub(nArray7, nArray, nArray7);
        F.mul(nArray7, pointProjective.z, nArray7);
        F.mul(nArray4, pointProjective.z, nArray4);
        F.mul(nArray5, nArray7, pointProjective.x);
        F.mul(nArray4, nArray6, pointProjective.y);
        F.mul(nArray5, nArray6, pointProjective.z);
    }

    private static void pointAdd(PointProjective pointProjective, PointProjective pointProjective2, PointTemp pointTemp) {
        int[] nArray = pointTemp.r0;
        int[] nArray2 = pointTemp.r1;
        int[] nArray3 = pointTemp.r2;
        int[] nArray4 = pointTemp.r3;
        int[] nArray5 = pointTemp.r4;
        int[] nArray6 = pointTemp.r5;
        int[] nArray7 = pointTemp.r6;
        int[] nArray8 = pointTemp.r7;
        F.mul(pointProjective.z, pointProjective2.z, nArray);
        F.sqr(nArray, nArray2);
        F.mul(pointProjective.x, pointProjective2.x, nArray3);
        F.mul(pointProjective.y, pointProjective2.y, nArray4);
        F.mul(nArray3, nArray4, nArray5);
        F.mul(nArray5, 39081, nArray5);
        F.add(nArray2, nArray5, nArray6);
        F.sub(nArray2, nArray5, nArray7);
        F.add(pointProjective.y, pointProjective.x, nArray8);
        F.add(pointProjective2.y, pointProjective2.x, nArray5);
        F.mul(nArray8, nArray5, nArray8);
        F.add(nArray4, nArray3, nArray2);
        F.sub(nArray4, nArray3, nArray5);
        F.carry(nArray2);
        F.sub(nArray8, nArray2, nArray8);
        F.mul(nArray8, nArray, nArray8);
        F.mul(nArray5, nArray, nArray5);
        F.mul(nArray6, nArray8, pointProjective2.x);
        F.mul(nArray5, nArray7, pointProjective2.y);
        F.mul(nArray6, nArray7, pointProjective2.z);
    }

    private static void pointCopy(PointAffine pointAffine, PointProjective pointProjective) {
        F.copy(pointAffine.x, 0, pointProjective.x, 0);
        F.copy(pointAffine.y, 0, pointProjective.y, 0);
        F.one(pointProjective.z);
    }

    private static void pointCopy(PointProjective pointProjective, PointProjective pointProjective2) {
        F.copy(pointProjective.x, 0, pointProjective2.x, 0);
        F.copy(pointProjective.y, 0, pointProjective2.y, 0);
        F.copy(pointProjective.z, 0, pointProjective2.z, 0);
    }

    private static void pointDouble(PointProjective pointProjective, PointTemp pointTemp) {
        int[] nArray = pointTemp.r1;
        int[] nArray2 = pointTemp.r2;
        int[] nArray3 = pointTemp.r3;
        int[] nArray4 = pointTemp.r4;
        int[] nArray5 = pointTemp.r7;
        int[] nArray6 = pointTemp.r0;
        F.add(pointProjective.x, pointProjective.y, nArray);
        F.sqr(nArray, nArray);
        F.sqr(pointProjective.x, nArray2);
        F.sqr(pointProjective.y, nArray3);
        F.add(nArray2, nArray3, nArray4);
        F.carry(nArray4);
        F.sqr(pointProjective.z, nArray5);
        F.add(nArray5, nArray5, nArray5);
        F.carry(nArray5);
        F.sub(nArray4, nArray5, nArray6);
        F.sub(nArray, nArray4, nArray);
        F.sub(nArray2, nArray3, nArray2);
        F.mul(nArray, nArray6, pointProjective.x);
        F.mul(nArray4, nArray2, pointProjective.y);
        F.mul(nArray4, nArray6, pointProjective.z);
    }

    private static void pointLookup(int n, int n2, PointAffine pointAffine) {
        int n3 = n * 16 * 2 * 16;
        for (int i = 0; i < 16; ++i) {
            int n4 = (i ^ n2) - 1 >> 31;
            F.cmov(n4, PRECOMP_BASE_COMB, n3, pointAffine.x, 0);
            F.cmov(n4, PRECOMP_BASE_COMB, n3 += 16, pointAffine.y, 0);
            n3 += 16;
        }
    }

    private static void pointPrecompute(PointAffine pointAffine, PointProjective[] pointProjectiveArray, int n, int n2, PointTemp pointTemp) {
        PointProjective pointProjective = new PointProjective();
        Ed448.pointCopy(pointAffine, pointProjective);
        Ed448.pointDouble(pointProjective, pointTemp);
        pointProjectiveArray[n] = new PointProjective();
        Ed448.pointCopy(pointAffine, pointProjectiveArray[n]);
        for (int i = 1; i < n2; ++i) {
            pointProjectiveArray[n + i] = new PointProjective();
            Ed448.pointCopy(pointProjectiveArray[n + i - 1], pointProjectiveArray[n + i]);
            Ed448.pointAdd(pointProjective, pointProjectiveArray[n + i], pointTemp);
        }
    }

    private static void pointSetNeutral(PointProjective pointProjective) {
        F.zero(pointProjective.x);
        F.one(pointProjective.y);
        F.one(pointProjective.z);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void precompute() {
        Object object = PRECOMP_LOCK;
        synchronized (object) {
            PointProjective pointProjective;
            int n;
            if (PRECOMP_BASE_COMB != null) {
                return;
            }
            int n2 = 32;
            int n3 = 80;
            int n4 = n2 * 2 + n3;
            PointProjective[] pointProjectiveArray = new PointProjective[n4];
            PointTemp pointTemp = new PointTemp();
            PointAffine pointAffine = new PointAffine();
            F.copy(B_x, 0, pointAffine.x, 0);
            F.copy(B_y, 0, pointAffine.y, 0);
            Ed448.pointPrecompute(pointAffine, pointProjectiveArray, 0, n2, pointTemp);
            PointAffine pointAffine2 = new PointAffine();
            F.copy(B225_x, 0, pointAffine2.x, 0);
            F.copy(B225_y, 0, pointAffine2.y, 0);
            Ed448.pointPrecompute(pointAffine2, pointProjectiveArray, n2, n2, pointTemp);
            PointProjective pointProjective2 = new PointProjective();
            Ed448.pointCopy(pointAffine, pointProjective2);
            int n5 = n2 * 2;
            PointProjective[] pointProjectiveArray2 = new PointProjective[5];
            for (n = 0; n < 5; ++n) {
                pointProjectiveArray2[n] = new PointProjective();
            }
            for (n = 0; n < 5; ++n) {
                int n6;
                int n7;
                int n8 = n5++;
                PointProjective pointProjective3 = new PointProjective();
                pointProjectiveArray[n8] = pointProjective3;
                pointProjective = pointProjective3;
                for (n7 = 0; n7 < 5; ++n7) {
                    if (n7 == 0) {
                        Ed448.pointCopy(pointProjective2, pointProjective);
                    } else {
                        Ed448.pointAdd(pointProjective2, pointProjective, pointTemp);
                    }
                    Ed448.pointDouble(pointProjective2, pointTemp);
                    Ed448.pointCopy(pointProjective2, pointProjectiveArray2[n7]);
                    if (n + n7 == 8) continue;
                    for (n6 = 1; n6 < 18; ++n6) {
                        Ed448.pointDouble(pointProjective2, pointTemp);
                    }
                }
                F.negate(pointProjective.x, pointProjective.x);
                for (n7 = 0; n7 < 4; ++n7) {
                    n6 = 1 << n7;
                    int n9 = 0;
                    while (n9 < n6) {
                        pointProjectiveArray[n5] = new PointProjective();
                        Ed448.pointCopy(pointProjectiveArray[n5 - n6], pointProjectiveArray[n5]);
                        Ed448.pointAdd(pointProjectiveArray2[n7], pointProjectiveArray[n5], pointTemp);
                        ++n9;
                        ++n5;
                    }
                }
            }
            Ed448.invertZs(pointProjectiveArray);
            PRECOMP_BASE_WNAF = new PointAffine[n2];
            for (n = 0; n < n2; ++n) {
                pointProjective = pointProjectiveArray[n];
                PointAffine pointAffine3 = Ed448.PRECOMP_BASE_WNAF[n] = new PointAffine();
                F.mul(pointProjective.x, pointProjective.z, pointAffine3.x);
                F.normalize(pointAffine3.x);
                F.mul(pointProjective.y, pointProjective.z, pointAffine3.y);
                F.normalize(pointAffine3.y);
            }
            PRECOMP_BASE225_WNAF = new PointAffine[n2];
            for (n = 0; n < n2; ++n) {
                pointProjective = pointProjectiveArray[n2 + n];
                PointAffine pointAffine4 = Ed448.PRECOMP_BASE225_WNAF[n] = new PointAffine();
                F.mul(pointProjective.x, pointProjective.z, pointAffine4.x);
                F.normalize(pointAffine4.x);
                F.mul(pointProjective.y, pointProjective.z, pointAffine4.y);
                F.normalize(pointAffine4.y);
            }
            PRECOMP_BASE_COMB = F.createTable(n3 * 2);
            n = 0;
            for (int i = n2 * 2; i < n4; ++i) {
                PointProjective pointProjective4 = pointProjectiveArray[i];
                F.mul(pointProjective4.x, pointProjective4.z, pointProjective4.x);
                F.normalize(pointProjective4.x);
                F.mul(pointProjective4.y, pointProjective4.z, pointProjective4.y);
                F.normalize(pointProjective4.y);
                F.copy(pointProjective4.x, 0, PRECOMP_BASE_COMB, n);
                F.copy(pointProjective4.y, 0, PRECOMP_BASE_COMB, n += 16);
                n += 16;
            }
        }
    }

    private static void pruneScalar(byte[] byArray, int n, byte[] byArray2) {
        System.arraycopy(byArray, n, byArray2, 0, 56);
        byArray2[0] = (byte)(byArray2[0] & 0xFC);
        byArray2[55] = (byte)(byArray2[55] | 0x80);
        byArray2[56] = 0;
    }

    private static void scalarMultBase(byte[] byArray, PointProjective pointProjective) {
        Ed448.precompute();
        int[] nArray = new int[15];
        Scalar448.decode(byArray, nArray);
        Scalar448.toSignedDigits(450, nArray, nArray);
        PointAffine pointAffine = new PointAffine();
        PointTemp pointTemp = new PointTemp();
        Ed448.pointSetNeutral(pointProjective);
        int n = 17;
        while (true) {
            int n2 = n;
            for (int i = 0; i < 5; ++i) {
                int n3;
                int n4;
                int n5 = 0;
                for (n4 = 0; n4 < 5; ++n4) {
                    n3 = nArray[n2 >>> 5] >>> (n2 & 0x1F);
                    n5 &= ~(1 << n4);
                    n5 ^= n3 << n4;
                    n2 += 18;
                }
                n4 = n5 >>> 4 & 1;
                n3 = (n5 ^ -n4) & 0xF;
                Ed448.pointLookup(i, n3, pointAffine);
                F.cnegate(n4, pointAffine.x);
                Ed448.pointAdd(pointAffine, pointProjective, pointTemp);
            }
            if (--n < 0) break;
            Ed448.pointDouble(pointProjective, pointTemp);
        }
    }

    public static void scalarMultBaseXY(X448.Friend friend, byte[] byArray, int n, int[] nArray, int[] nArray2) {
        if (null == friend) {
            throw new NullPointerException("This method is only for use by X448");
        }
        byte[] byArray2 = new byte[57];
        Ed448.pruneScalar(byArray, n, byArray2);
        PointProjective pointProjective = new PointProjective();
        Ed448.scalarMultBase(byArray2, pointProjective);
        if (0 == Ed448.checkPoint(pointProjective)) {
            throw new IllegalStateException();
        }
        F.copy(pointProjective.x, 0, nArray, 0);
        F.copy(pointProjective.y, 0, nArray2, 0);
    }

    private static class F
    extends X448Field {
    }

    private static class PointAffine {
        int[] x = F.create();
        int[] y = F.create();

        private PointAffine() {
        }
    }

    private static class PointProjective {
        int[] x = F.create();
        int[] y = F.create();
        int[] z = F.create();

        private PointProjective() {
        }
    }

    private static class PointTemp {
        int[] r0 = F.create();
        int[] r1 = F.create();
        int[] r2 = F.create();
        int[] r3 = F.create();
        int[] r4 = F.create();
        int[] r5 = F.create();
        int[] r6 = F.create();
        int[] r7 = F.create();

        private PointTemp() {
        }
    }

    public static final class PublicPoint {
        final int[] data;

        PublicPoint(int[] nArray) {
            this.data = nArray;
        }
    }
}

