/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.bouncycastle.math.ec;

import de.businesslogics.bouncycastle.math.ec.ECCurve;
import de.businesslogics.bouncycastle.math.ec.ECPoint;
import de.businesslogics.bouncycastle.math.ec.PreCompCallback;
import de.businesslogics.bouncycastle.math.ec.PreCompInfo;
import de.businesslogics.bouncycastle.math.ec.WNafPreCompInfo;
import java.math.BigInteger;

public abstract class WNafUtil {
    private static final int[] DEFAULT_WINDOW_SIZE_CUTOFFS = new int[]{13, 41, 121, 337, 897, 2305};
    private static final byte[] EMPTY_BYTES = new byte[0];
    private static final int[] EMPTY_INTS = new int[0];
    private static final ECPoint[] EMPTY_POINTS = new ECPoint[0];

    public static void configureBasepoint(ECPoint eCPoint) {
        ECCurve eCCurve = eCPoint.getCurve();
        if (null == eCCurve) {
            return;
        }
        BigInteger bigInteger = eCCurve.getOrder();
        int n = null == bigInteger ? eCCurve.getFieldSize() + 1 : bigInteger.bitLength();
        final int n2 = Math.min(16, WNafUtil.getWindowSize(n) + 3);
        eCCurve.precompute(eCPoint, "bc_wnaf", new PreCompCallback(){

            public PreCompInfo precompute(PreCompInfo preCompInfo) {
                WNafPreCompInfo wNafPreCompInfo;
                WNafPreCompInfo wNafPreCompInfo2 = wNafPreCompInfo = preCompInfo instanceof WNafPreCompInfo ? (WNafPreCompInfo)preCompInfo : null;
                if (null != wNafPreCompInfo && wNafPreCompInfo.getConfWidth() == n2) {
                    wNafPreCompInfo.setPromotionCountdown(0);
                    return wNafPreCompInfo;
                }
                WNafPreCompInfo wNafPreCompInfo3 = new WNafPreCompInfo();
                wNafPreCompInfo3.setPromotionCountdown(0);
                wNafPreCompInfo3.setConfWidth(n2);
                if (null != wNafPreCompInfo) {
                    wNafPreCompInfo3.setPreComp(wNafPreCompInfo.getPreComp());
                    wNafPreCompInfo3.setPreCompNeg(wNafPreCompInfo.getPreCompNeg());
                    wNafPreCompInfo3.setTwice(wNafPreCompInfo.getTwice());
                    wNafPreCompInfo3.setWidth(wNafPreCompInfo.getWidth());
                }
                return wNafPreCompInfo3;
            }
        });
    }

    public static int getNafWeight(BigInteger bigInteger) {
        if (bigInteger.signum() == 0) {
            return 0;
        }
        BigInteger bigInteger2 = bigInteger.shiftLeft(1).add(bigInteger);
        BigInteger bigInteger3 = bigInteger2.xor(bigInteger);
        return bigInteger3.bitCount();
    }

    public static int getWindowSize(int n) {
        return WNafUtil.getWindowSize(n, DEFAULT_WINDOW_SIZE_CUTOFFS, 16);
    }

    public static int getWindowSize(int n, int[] nArray, int n2) {
        int n3;
        for (n3 = 0; n3 < nArray.length && n >= nArray[n3]; ++n3) {
        }
        return Math.max(2, Math.min(n2, n3 + 2));
    }
}

