/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.bouncycastle.math;

import de.businesslogics.bouncycastle.util.BigIntegers;
import java.math.BigInteger;
import java.security.SecureRandom;

public abstract class Primes {
    private static final BigInteger ONE = BigInteger.valueOf(1L);
    private static final BigInteger TWO = BigInteger.valueOf(2L);
    private static final BigInteger THREE = BigInteger.valueOf(3L);

    public static MROutput enhancedMRProbablePrimeTest(BigInteger bigInteger, SecureRandom secureRandom, int n) {
        Primes.checkCandidate(bigInteger, "candidate");
        if (secureRandom == null) {
            throw new IllegalArgumentException("'random' cannot be null");
        }
        if (n < 1) {
            throw new IllegalArgumentException("'iterations' must be > 0");
        }
        if (bigInteger.bitLength() == 2) {
            return MROutput.probablyPrime();
        }
        if (!bigInteger.testBit(0)) {
            return MROutput.provablyCompositeWithFactor(Primes.TWO);
        }
        BigInteger bigInteger2 = bigInteger;
        BigInteger bigInteger3 = bigInteger.subtract(ONE);
        BigInteger bigInteger4 = bigInteger.subtract(TWO);
        int n2 = bigInteger3.getLowestSetBit();
        BigInteger bigInteger5 = bigInteger3.shiftRight(n2);
        for (int i = 0; i < n; ++i) {
            BigInteger bigInteger6 = BigIntegers.createRandomInRange(TWO, bigInteger4, secureRandom);
            BigInteger bigInteger7 = bigInteger6.gcd(bigInteger2);
            if (bigInteger7.compareTo(ONE) > 0) {
                return MROutput.provablyCompositeWithFactor(bigInteger7);
            }
            BigInteger bigInteger8 = bigInteger6.modPow(bigInteger5, bigInteger2);
            if (bigInteger8.equals(ONE) || bigInteger8.equals(bigInteger3)) continue;
            boolean bl = false;
            BigInteger bigInteger9 = bigInteger8;
            for (int j = 1; j < n2; ++j) {
                if ((bigInteger8 = bigInteger8.modPow(TWO, bigInteger2)).equals(bigInteger3)) {
                    bl = true;
                    break;
                }
                if (bigInteger8.equals(ONE)) break;
                bigInteger9 = bigInteger8;
            }
            if (bl) continue;
            if (!bigInteger8.equals(ONE)) {
                bigInteger9 = bigInteger8;
                if (!(bigInteger8 = bigInteger8.modPow(TWO, bigInteger2)).equals(ONE)) {
                    bigInteger9 = bigInteger8;
                }
            }
            if ((bigInteger7 = bigInteger9.subtract(ONE).gcd(bigInteger2)).compareTo(ONE) > 0) {
                return MROutput.provablyCompositeWithFactor(bigInteger7);
            }
            return MROutput.provablyCompositeNotPrimePower();
        }
        return MROutput.probablyPrime();
    }

    public static boolean hasAnySmallFactors(BigInteger bigInteger) {
        Primes.checkCandidate(bigInteger, "candidate");
        return Primes.implHasAnySmallFactors(bigInteger);
    }

    public static boolean isMRProbablePrime(BigInteger bigInteger, SecureRandom secureRandom, int n) {
        Primes.checkCandidate(bigInteger, "candidate");
        if (secureRandom == null) {
            throw new IllegalArgumentException("'random' cannot be null");
        }
        if (n < 1) {
            throw new IllegalArgumentException("'iterations' must be > 0");
        }
        if (bigInteger.bitLength() == 2) {
            return true;
        }
        if (!bigInteger.testBit(0)) {
            return false;
        }
        BigInteger bigInteger2 = bigInteger;
        BigInteger bigInteger3 = bigInteger.subtract(ONE);
        BigInteger bigInteger4 = bigInteger.subtract(TWO);
        int n2 = bigInteger3.getLowestSetBit();
        BigInteger bigInteger5 = bigInteger3.shiftRight(n2);
        for (int i = 0; i < n; ++i) {
            BigInteger bigInteger6 = BigIntegers.createRandomInRange(TWO, bigInteger4, secureRandom);
            if (Primes.implMRProbablePrimeToBase(bigInteger2, bigInteger3, bigInteger5, n2, bigInteger6)) continue;
            return false;
        }
        return true;
    }

    private static void checkCandidate(BigInteger bigInteger, String string) {
        if (bigInteger == null || bigInteger.signum() < 1 || bigInteger.bitLength() < 2) {
            throw new IllegalArgumentException("'" + string + "' must be non-null and >= 2");
        }
    }

    private static boolean implHasAnySmallFactors(BigInteger bigInteger) {
        int n = 223092870;
        int n2 = bigInteger.mod(BigInteger.valueOf(n)).intValue();
        if (n2 % 2 == 0 || n2 % 3 == 0 || n2 % 5 == 0 || n2 % 7 == 0 || n2 % 11 == 0 || n2 % 13 == 0 || n2 % 17 == 0 || n2 % 19 == 0 || n2 % 23 == 0) {
            return true;
        }
        n = 58642669;
        n2 = bigInteger.mod(BigInteger.valueOf(n)).intValue();
        if (n2 % 29 == 0 || n2 % 31 == 0 || n2 % 37 == 0 || n2 % 41 == 0 || n2 % 43 == 0) {
            return true;
        }
        n = 600662303;
        n2 = bigInteger.mod(BigInteger.valueOf(n)).intValue();
        if (n2 % 47 == 0 || n2 % 53 == 0 || n2 % 59 == 0 || n2 % 61 == 0 || n2 % 67 == 0) {
            return true;
        }
        n = 33984931;
        n2 = bigInteger.mod(BigInteger.valueOf(n)).intValue();
        if (n2 % 71 == 0 || n2 % 73 == 0 || n2 % 79 == 0 || n2 % 83 == 0) {
            return true;
        }
        n = 89809099;
        n2 = bigInteger.mod(BigInteger.valueOf(n)).intValue();
        if (n2 % 89 == 0 || n2 % 97 == 0 || n2 % 101 == 0 || n2 % 103 == 0) {
            return true;
        }
        n = 167375713;
        n2 = bigInteger.mod(BigInteger.valueOf(n)).intValue();
        if (n2 % 107 == 0 || n2 % 109 == 0 || n2 % 113 == 0 || n2 % 127 == 0) {
            return true;
        }
        n = 371700317;
        n2 = bigInteger.mod(BigInteger.valueOf(n)).intValue();
        if (n2 % 131 == 0 || n2 % 137 == 0 || n2 % 139 == 0 || n2 % 149 == 0) {
            return true;
        }
        n = 645328247;
        n2 = bigInteger.mod(BigInteger.valueOf(n)).intValue();
        if (n2 % 151 == 0 || n2 % 157 == 0 || n2 % 163 == 0 || n2 % 167 == 0) {
            return true;
        }
        n = 1070560157;
        n2 = bigInteger.mod(BigInteger.valueOf(n)).intValue();
        if (n2 % 173 == 0 || n2 % 179 == 0 || n2 % 181 == 0 || n2 % 191 == 0) {
            return true;
        }
        n = 1596463769;
        n2 = bigInteger.mod(BigInteger.valueOf(n)).intValue();
        return n2 % 193 == 0 || n2 % 197 == 0 || n2 % 199 == 0 || n2 % 211 == 0;
    }

    private static boolean implMRProbablePrimeToBase(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, int n, BigInteger bigInteger4) {
        BigInteger bigInteger5 = bigInteger4.modPow(bigInteger3, bigInteger);
        if (bigInteger5.equals(ONE) || bigInteger5.equals(bigInteger2)) {
            return true;
        }
        boolean bl = false;
        for (int i = 1; i < n; ++i) {
            if ((bigInteger5 = bigInteger5.modPow(TWO, bigInteger)).equals(bigInteger2)) {
                bl = true;
                break;
            }
            if (!bigInteger5.equals(ONE)) continue;
            return false;
        }
        return bl;
    }

    public static class MROutput {
        private boolean provablyComposite;
        private BigInteger factor;

        private static MROutput probablyPrime() {
            return new MROutput(false, null);
        }

        private static MROutput provablyCompositeWithFactor(BigInteger bigInteger) {
            return new MROutput(true, bigInteger);
        }

        private static MROutput provablyCompositeNotPrimePower() {
            return new MROutput(true, null);
        }

        private MROutput(boolean bl, BigInteger bigInteger) {
            this.provablyComposite = bl;
            this.factor = bigInteger;
        }

        public boolean isProvablyComposite() {
            return this.provablyComposite;
        }
    }
}

