/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.bouncycastle.jcajce.provider.symmetric.util;

import de.businesslogics.bouncycastle.crypto.params.AEADParameters;
import de.businesslogics.bouncycastle.crypto.params.KeyParameter;
import de.businesslogics.bouncycastle.jcajce.provider.symmetric.util.ClassUtil;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.InvalidAlgorithmParameterException;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.spec.AlgorithmParameterSpec;

public class GcmSpecUtil {
    static final Class gcmSpecClass = ClassUtil.loadClass(GcmSpecUtil.class, "javax.crypto.spec.GCMParameterSpec");
    private static final Constructor constructor;
    private static final Method tLen;
    private static final Method iv;

    private static Constructor extractConstructor() {
        try {
            return (Constructor)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return gcmSpecClass.getConstructor(Integer.TYPE, byte[].class);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            return null;
        }
    }

    private static Method extractMethod(final String string) {
        try {
            return (Method)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return gcmSpecClass.getDeclaredMethod(string, new Class[0]);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            return null;
        }
    }

    public static boolean isGcmSpec(AlgorithmParameterSpec algorithmParameterSpec) {
        return gcmSpecClass != null && gcmSpecClass.isInstance(algorithmParameterSpec);
    }

    static AEADParameters extractAeadParameters(final KeyParameter keyParameter, final AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException {
        try {
            return (AEADParameters)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return new AEADParameters(keyParameter, (Integer)tLen.invoke((Object)algorithmParameterSpec, new Object[0]), (byte[])iv.invoke((Object)algorithmParameterSpec, new Object[0]));
                }
            });
        }
        catch (Exception exception) {
            throw new InvalidAlgorithmParameterException("Cannot process GCMParameterSpec.");
        }
    }

    static {
        if (gcmSpecClass != null) {
            constructor = GcmSpecUtil.extractConstructor();
            tLen = GcmSpecUtil.extractMethod("getTLen");
            iv = GcmSpecUtil.extractMethod("getIV");
        } else {
            constructor = null;
            tLen = null;
            iv = null;
        }
    }
}

