/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.bouncycastle.jcajce.provider.symmetric.util;

import de.businesslogics.bouncycastle.asn1.ASN1ObjectIdentifier;
import de.businesslogics.bouncycastle.crypto.CipherParameters;
import de.businesslogics.bouncycastle.crypto.PBEParametersGenerator;
import de.businesslogics.bouncycastle.crypto.params.KeyParameter;
import de.businesslogics.bouncycastle.crypto.params.ParametersWithIV;
import de.businesslogics.bouncycastle.util.Arrays;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.crypto.interfaces.PBEKey;
import javax.security.auth.Destroyable;

public class BCPBEKey
implements PBEKey,
Destroyable {
    private final AtomicBoolean hasBeenDestroyed;
    String algorithm;
    ASN1ObjectIdentifier oid;
    int type;
    int digest;
    int keySize;
    int ivSize;
    private final char[] password;
    private final byte[] salt;
    private final int iterationCount;
    private final CipherParameters param;
    boolean tryWrong;

    public String getAlgorithm() {
        String string = this.algorithm;
        BCPBEKey.checkDestroyed(this);
        return string;
    }

    public String getFormat() {
        BCPBEKey.checkDestroyed(this);
        return "RAW";
    }

    public byte[] getEncoded() {
        byte[] byArray;
        if (this.param != null) {
            KeyParameter keyParameter = this.param instanceof ParametersWithIV ? (KeyParameter)((ParametersWithIV)this.param).getParameters() : (KeyParameter)this.param;
            byArray = keyParameter.getKey();
        } else {
            byArray = this.type == 2 ? PBEParametersGenerator.PKCS12PasswordToBytes(this.password) : (this.type == 5 ? PBEParametersGenerator.PKCS5PasswordToUTF8Bytes(this.password) : PBEParametersGenerator.PKCS5PasswordToBytes(this.password));
        }
        BCPBEKey.checkDestroyed(this);
        return byArray;
    }

    int getType() {
        int n = this.type;
        BCPBEKey.checkDestroyed(this);
        return n;
    }

    int getDigest() {
        int n = this.digest;
        BCPBEKey.checkDestroyed(this);
        return n;
    }

    int getKeySize() {
        int n = this.keySize;
        BCPBEKey.checkDestroyed(this);
        return n;
    }

    public int getIvSize() {
        int n = this.ivSize;
        BCPBEKey.checkDestroyed(this);
        return n;
    }

    public CipherParameters getParam() {
        CipherParameters cipherParameters = this.param;
        BCPBEKey.checkDestroyed(this);
        return cipherParameters;
    }

    public char[] getPassword() {
        char[] cArray = Arrays.clone(this.password);
        BCPBEKey.checkDestroyed(this);
        if (cArray == null) {
            throw new IllegalStateException("no password available");
        }
        return cArray;
    }

    public byte[] getSalt() {
        byte[] byArray = Arrays.clone(this.salt);
        BCPBEKey.checkDestroyed(this);
        return byArray;
    }

    public int getIterationCount() {
        int n = this.iterationCount;
        BCPBEKey.checkDestroyed(this);
        return n;
    }

    public ASN1ObjectIdentifier getOID() {
        ASN1ObjectIdentifier aSN1ObjectIdentifier = this.oid;
        BCPBEKey.checkDestroyed(this);
        return aSN1ObjectIdentifier;
    }

    boolean shouldTryWrongPKCS12() {
        return this.tryWrong;
    }

    public void destroy() {
        if (!this.hasBeenDestroyed.getAndSet(true)) {
            if (this.password != null) {
                Arrays.fill(this.password, '\u0000');
            }
            if (this.salt != null) {
                Arrays.fill(this.salt, (byte)0);
            }
        }
    }

    public boolean isDestroyed() {
        return this.hasBeenDestroyed.get();
    }

    static void checkDestroyed(Destroyable destroyable) {
        if (destroyable.isDestroyed()) {
            throw new IllegalStateException("key has been destroyed");
        }
    }
}

