/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.bouncycastle.jcajce.provider.asymmetric.ec;

import de.businesslogics.bouncycastle.asn1.ASN1BitString;
import de.businesslogics.bouncycastle.asn1.ASN1Encodable;
import de.businesslogics.bouncycastle.asn1.ASN1Integer;
import de.businesslogics.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import de.businesslogics.bouncycastle.asn1.x509.AlgorithmIdentifier;
import de.businesslogics.bouncycastle.asn1.x9.ECNamedCurveTable;
import de.businesslogics.bouncycastle.asn1.x9.X962Parameters;
import de.businesslogics.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import de.businesslogics.bouncycastle.crypto.params.ECDomainParameters;
import de.businesslogics.bouncycastle.crypto.params.ECNamedDomainParameters;
import de.businesslogics.bouncycastle.crypto.params.ECPrivateKeyParameters;
import de.businesslogics.bouncycastle.jcajce.provider.asymmetric.ec.ECUtils;
import de.businesslogics.bouncycastle.jcajce.provider.asymmetric.util.EC5Util;
import de.businesslogics.bouncycastle.jcajce.provider.asymmetric.util.ECUtil;
import de.businesslogics.bouncycastle.jcajce.provider.asymmetric.util.PKCS12BagAttributeCarrierImpl;
import de.businesslogics.bouncycastle.jcajce.provider.config.ProviderConfiguration;
import de.businesslogics.bouncycastle.jce.interfaces.ECPrivateKey;
import de.businesslogics.bouncycastle.jce.provider.BouncyCastleProvider;
import de.businesslogics.bouncycastle.jce.spec.ECNamedCurveParameterSpec;
import de.businesslogics.bouncycastle.jce.spec.ECPrivateKeySpec;
import de.businesslogics.bouncycastle.math.ec.ECCurve;
import de.businesslogics.bouncycastle.util.Arrays;
import java.io.IOException;
import java.math.BigInteger;
import java.security.spec.ECParameterSpec;
import java.security.spec.EllipticCurve;

public class BCECPrivateKey
implements ECPrivateKey,
java.security.interfaces.ECPrivateKey {
    private String algorithm = "EC";
    private boolean withCompression;
    private transient BigInteger d;
    private transient ECParameterSpec ecSpec;
    private transient ProviderConfiguration configuration;
    private transient ASN1BitString publicKey;
    private transient PrivateKeyInfo privateKeyInfo;
    private transient byte[] encoding;
    private transient ECPrivateKeyParameters baseKey;
    private transient PKCS12BagAttributeCarrierImpl attrCarrier = new PKCS12BagAttributeCarrierImpl();

    protected BCECPrivateKey() {
    }

    public BCECPrivateKey(java.security.interfaces.ECPrivateKey eCPrivateKey, ProviderConfiguration providerConfiguration) {
        this.d = eCPrivateKey.getS();
        this.algorithm = eCPrivateKey.getAlgorithm();
        this.ecSpec = eCPrivateKey.getParams();
        this.configuration = providerConfiguration;
        this.baseKey = BCECPrivateKey.convertToBaseKey(this);
    }

    public BCECPrivateKey(String string, ECPrivateKeySpec eCPrivateKeySpec, ProviderConfiguration providerConfiguration) {
        this.algorithm = string;
        this.d = eCPrivateKeySpec.getD();
        if (eCPrivateKeySpec.getParams() != null) {
            ECCurve eCCurve = eCPrivateKeySpec.getParams().getCurve();
            EllipticCurve ellipticCurve = EC5Util.convertCurve(eCCurve, eCPrivateKeySpec.getParams().getSeed());
            this.ecSpec = EC5Util.convertSpec(ellipticCurve, eCPrivateKeySpec.getParams());
        } else {
            this.ecSpec = null;
        }
        this.configuration = providerConfiguration;
        this.baseKey = BCECPrivateKey.convertToBaseKey(this);
    }

    public BCECPrivateKey(String string, java.security.spec.ECPrivateKeySpec eCPrivateKeySpec, ProviderConfiguration providerConfiguration) {
        this.algorithm = string;
        this.d = eCPrivateKeySpec.getS();
        this.ecSpec = eCPrivateKeySpec.getParams();
        this.configuration = providerConfiguration;
        this.baseKey = BCECPrivateKey.convertToBaseKey(this);
    }

    BCECPrivateKey(String string, PrivateKeyInfo privateKeyInfo, ProviderConfiguration providerConfiguration) throws IOException {
        this.algorithm = string;
        this.configuration = providerConfiguration;
        this.populateFromPrivKeyInfo(privateKeyInfo);
    }

    private void populateFromPrivKeyInfo(PrivateKeyInfo privateKeyInfo) throws IOException {
        X962Parameters x962Parameters = X962Parameters.getInstance(privateKeyInfo.getPrivateKeyAlgorithm().getParameters());
        ECCurve eCCurve = EC5Util.getCurve(this.configuration, x962Parameters);
        this.ecSpec = EC5Util.convertToSpec(x962Parameters, eCCurve);
        ASN1Encodable aSN1Encodable = privateKeyInfo.parsePrivateKey();
        if (aSN1Encodable instanceof ASN1Integer) {
            ASN1Integer aSN1Integer = ASN1Integer.getInstance(aSN1Encodable);
            this.d = aSN1Integer.getValue();
        } else {
            de.businesslogics.bouncycastle.asn1.sec.ECPrivateKey eCPrivateKey = de.businesslogics.bouncycastle.asn1.sec.ECPrivateKey.getInstance(aSN1Encodable);
            this.d = eCPrivateKey.getKey();
            this.publicKey = eCPrivateKey.getPublicKey();
        }
        this.baseKey = BCECPrivateKey.convertToBaseKey(this);
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public String getFormat() {
        return "PKCS#8";
    }

    public byte[] getEncoded() {
        if (this.encoding == null) {
            PrivateKeyInfo privateKeyInfo = this.getPrivateKeyInfo();
            if (privateKeyInfo == null) {
                return null;
            }
            try {
                this.encoding = privateKeyInfo.getEncoded("DER");
            }
            catch (IOException iOException) {
                return null;
            }
        }
        return Arrays.clone(this.encoding);
    }

    private PrivateKeyInfo getPrivateKeyInfo() {
        if (this.privateKeyInfo == null) {
            X962Parameters x962Parameters = ECUtils.getDomainParametersFromName(this.ecSpec, this.withCompression);
            int n = this.ecSpec == null ? ECUtil.getOrderBitLength(this.configuration, null, this.getS()) : ECUtil.getOrderBitLength(this.configuration, this.ecSpec.getOrder(), this.getS());
            de.businesslogics.bouncycastle.asn1.sec.ECPrivateKey eCPrivateKey = this.publicKey != null ? new de.businesslogics.bouncycastle.asn1.sec.ECPrivateKey(n, this.getS(), this.publicKey, x962Parameters) : new de.businesslogics.bouncycastle.asn1.sec.ECPrivateKey(n, this.getS(), x962Parameters);
            try {
                this.privateKeyInfo = new PrivateKeyInfo(new AlgorithmIdentifier(X9ObjectIdentifiers.id_ecPublicKey, x962Parameters), eCPrivateKey);
            }
            catch (IOException iOException) {
                return null;
            }
        }
        return this.privateKeyInfo;
    }

    public ECParameterSpec getParams() {
        return this.ecSpec;
    }

    public de.businesslogics.bouncycastle.jce.spec.ECParameterSpec getParameters() {
        if (this.ecSpec == null) {
            return null;
        }
        return EC5Util.convertSpec(this.ecSpec);
    }

    de.businesslogics.bouncycastle.jce.spec.ECParameterSpec engineGetSpec() {
        if (this.ecSpec != null) {
            return EC5Util.convertSpec(this.ecSpec);
        }
        return this.configuration.getEcImplicitlyCa();
    }

    public BigInteger getS() {
        return this.d;
    }

    public BigInteger getD() {
        return this.d;
    }

    public boolean equals(Object object) {
        if (object instanceof java.security.interfaces.ECPrivateKey) {
            PrivateKeyInfo privateKeyInfo;
            java.security.interfaces.ECPrivateKey eCPrivateKey = (java.security.interfaces.ECPrivateKey)object;
            PrivateKeyInfo privateKeyInfo2 = this.getPrivateKeyInfo();
            PrivateKeyInfo privateKeyInfo3 = privateKeyInfo = eCPrivateKey instanceof BCECPrivateKey ? ((BCECPrivateKey)eCPrivateKey).getPrivateKeyInfo() : PrivateKeyInfo.getInstance(eCPrivateKey.getEncoded());
            if (privateKeyInfo2 == null || privateKeyInfo == null) {
                return false;
            }
            try {
                boolean bl = Arrays.constantTimeAreEqual(privateKeyInfo2.getPrivateKeyAlgorithm().getEncoded(), privateKeyInfo.getPrivateKeyAlgorithm().getEncoded());
                boolean bl2 = Arrays.constantTimeAreEqual(this.getS().toByteArray(), eCPrivateKey.getS().toByteArray());
                return bl & bl2;
            }
            catch (IOException iOException) {
                return false;
            }
        }
        return false;
    }

    public int hashCode() {
        return this.getD().hashCode() ^ this.engineGetSpec().hashCode();
    }

    public String toString() {
        return ECUtil.privateKeyToString("EC", this.d, this.engineGetSpec());
    }

    private static ECPrivateKeyParameters convertToBaseKey(BCECPrivateKey bCECPrivateKey) {
        String string;
        BCECPrivateKey bCECPrivateKey2 = bCECPrivateKey;
        de.businesslogics.bouncycastle.jce.spec.ECParameterSpec eCParameterSpec = bCECPrivateKey2.getParameters();
        if (eCParameterSpec == null) {
            eCParameterSpec = BouncyCastleProvider.CONFIGURATION.getEcImplicitlyCa();
        }
        if (bCECPrivateKey2.getParameters() instanceof ECNamedCurveParameterSpec && (string = ((ECNamedCurveParameterSpec)bCECPrivateKey2.getParameters()).getName()) != null) {
            return new ECPrivateKeyParameters(bCECPrivateKey2.getD(), (ECDomainParameters)new ECNamedDomainParameters(ECNamedCurveTable.getOID(string), eCParameterSpec.getCurve(), eCParameterSpec.getG(), eCParameterSpec.getN(), eCParameterSpec.getH(), eCParameterSpec.getSeed()));
        }
        return new ECPrivateKeyParameters(bCECPrivateKey2.getD(), new ECDomainParameters(eCParameterSpec.getCurve(), eCParameterSpec.getG(), eCParameterSpec.getN(), eCParameterSpec.getH(), eCParameterSpec.getSeed()));
    }
}

