/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.bouncycastle.jcajce;

import de.businesslogics.bouncycastle.asn1.ASN1EncodableVector;
import de.businesslogics.bouncycastle.asn1.ASN1ObjectIdentifier;
import de.businesslogics.bouncycastle.asn1.DERSequence;
import de.businesslogics.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import de.businesslogics.bouncycastle.asn1.x509.AlgorithmIdentifier;
import de.businesslogics.bouncycastle.jcajce.provider.asymmetric.compositesignatures.CompositeSignaturesConstants;
import java.io.IOException;
import java.security.PrivateKey;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositePrivateKey
implements PrivateKey {
    private final List<PrivateKey> keys;
    private ASN1ObjectIdentifier algorithmIdentifier;

    public List<PrivateKey> getPrivateKeys() {
        return this.keys;
    }

    @Override
    public String getAlgorithm() {
        return CompositeSignaturesConstants.ASN1IdentifierAlgorithmNameMap.get(this.algorithmIdentifier).getId();
    }

    public ASN1ObjectIdentifier getAlgorithmIdentifier() {
        return this.algorithmIdentifier;
    }

    @Override
    public String getFormat() {
        return "PKCS#8";
    }

    @Override
    public byte[] getEncoded() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        for (int i = 0; i < this.keys.size(); ++i) {
            aSN1EncodableVector.add(PrivateKeyInfo.getInstance(this.keys.get(i).getEncoded()));
        }
        try {
            return new PrivateKeyInfo(new AlgorithmIdentifier(this.algorithmIdentifier), new DERSequence(aSN1EncodableVector)).getEncoded("DER");
        }
        catch (IOException iOException) {
            throw new IllegalStateException("unable to encode composite private key: " + iOException.getMessage());
        }
    }

    public int hashCode() {
        return this.keys.hashCode();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof CompositePrivateKey) {
            boolean bl = true;
            CompositePrivateKey compositePrivateKey = (CompositePrivateKey)object;
            if (!compositePrivateKey.getAlgorithmIdentifier().equals(this.algorithmIdentifier) || !this.keys.equals(compositePrivateKey.keys)) {
                bl = false;
            }
            return bl;
        }
        return false;
    }
}

