/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.bouncycastle.crypto.generators;

import de.businesslogics.bouncycastle.crypto.CipherParameters;
import de.businesslogics.bouncycastle.crypto.Digest;
import de.businesslogics.bouncycastle.crypto.PBEParametersGenerator;
import de.businesslogics.bouncycastle.crypto.params.KeyParameter;
import de.businesslogics.bouncycastle.crypto.params.ParametersWithIV;
import de.businesslogics.bouncycastle.crypto.util.DigestFactory;

public class OpenSSLPBEParametersGenerator
extends PBEParametersGenerator {
    private final Digest digest;

    public OpenSSLPBEParametersGenerator() {
        this(DigestFactory.createMD5());
    }

    public OpenSSLPBEParametersGenerator(Digest digest) {
        this.digest = digest;
    }

    private byte[] generateDerivedKey(int n) {
        byte[] byArray = new byte[this.digest.getDigestSize()];
        byte[] byArray2 = new byte[n];
        int n2 = 0;
        while (true) {
            this.digest.update(this.password, 0, this.password.length);
            this.digest.update(this.salt, 0, this.salt.length);
            this.digest.doFinal(byArray, 0);
            int n3 = n > byArray.length ? byArray.length : n;
            System.arraycopy(byArray, 0, byArray2, n2, n3);
            n2 += n3;
            if ((n -= n3) == 0) break;
            this.digest.reset();
            this.digest.update(byArray, 0, byArray.length);
        }
        return byArray2;
    }

    public CipherParameters generateDerivedParameters(int n) {
        byte[] byArray = this.generateDerivedKey(n /= 8);
        return new KeyParameter(byArray, 0, n);
    }

    public CipherParameters generateDerivedParameters(int n, int n2) {
        byte[] byArray = this.generateDerivedKey((n /= 8) + (n2 /= 8));
        return new ParametersWithIV(new KeyParameter(byArray, 0, n), byArray, n, n2);
    }

    public CipherParameters generateDerivedMacParameters(int n) {
        return this.generateDerivedParameters(n);
    }
}

