/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.bouncycastle.crypto.digests;

import de.businesslogics.bouncycastle.crypto.CryptoServiceProperties;
import de.businesslogics.bouncycastle.crypto.CryptoServicePurpose;
import de.businesslogics.bouncycastle.crypto.Xof;
import de.businesslogics.bouncycastle.crypto.digests.KeccakDigest;
import de.businesslogics.bouncycastle.crypto.digests.Utils;

public class SHAKEDigest
extends KeccakDigest
implements Xof {
    private static int checkBitLength(int n) {
        switch (n) {
            case 128: 
            case 256: {
                return n;
            }
        }
        throw new IllegalArgumentException("'bitStrength' " + n + " not supported for SHAKE");
    }

    public SHAKEDigest() {
        this(128);
    }

    public SHAKEDigest(int n) {
        super(SHAKEDigest.checkBitLength(n), CryptoServicePurpose.ANY);
    }

    public String getAlgorithmName() {
        return "SHAKE" + this.fixedOutputLength;
    }

    public int getDigestSize() {
        return this.fixedOutputLength / 4;
    }

    public int doFinal(byte[] byArray, int n) {
        return this.doFinal(byArray, n, this.getDigestSize());
    }

    public int doFinal(byte[] byArray, int n, int n2) {
        int n3 = this.doOutput(byArray, n, n2);
        this.reset();
        return n3;
    }

    public int doOutput(byte[] byArray, int n, int n2) {
        if (!this.squeezing) {
            this.absorbBits(15, 4);
        }
        this.squeeze(byArray, n, (long)n2 * 8L);
        return n2;
    }

    protected CryptoServiceProperties cryptoServiceProperties() {
        return Utils.getDefaultProperties(this, this.purpose);
    }
}

