/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.bouncycastle.crypto;

import de.businesslogics.bouncycastle.crypto.BlockCipher;
import de.businesslogics.bouncycastle.crypto.DataLengthException;
import de.businesslogics.bouncycastle.crypto.DefaultMultiBlockCipher;
import de.businesslogics.bouncycastle.crypto.OutputLengthException;
import de.businesslogics.bouncycastle.crypto.StreamCipher;

public abstract class StreamBlockCipher
extends DefaultMultiBlockCipher
implements StreamCipher {
    private final BlockCipher cipher;

    protected StreamBlockCipher(BlockCipher blockCipher) {
        this.cipher = blockCipher;
    }

    public BlockCipher getUnderlyingCipher() {
        return this.cipher;
    }

    public int processBytes(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws DataLengthException {
        if (n + n2 > byArray.length) {
            throw new DataLengthException("input buffer too small");
        }
        if (n3 + n2 > byArray2.length) {
            throw new OutputLengthException("output buffer too short");
        }
        int n4 = n;
        int n5 = n + n2;
        int n6 = n3;
        while (n4 < n5) {
            byArray2[n6++] = this.calculateByte(byArray[n4++]);
        }
        return n2;
    }

    protected abstract byte calculateByte(byte var1);
}

