/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.bouncycastle.asn1.x509;

import de.businesslogics.bouncycastle.asn1.ASN1BitString;
import de.businesslogics.bouncycastle.asn1.ASN1Object;
import de.businesslogics.bouncycastle.asn1.ASN1Primitive;
import de.businesslogics.bouncycastle.asn1.DERBitString;

public class KeyUsage
extends ASN1Object {
    public static final int digitalSignature = 128;
    public static final int nonRepudiation = 64;
    public static final int keyEncipherment = 32;
    public static final int keyAgreement = 8;
    private ASN1BitString bitString;

    public KeyUsage(int n) {
        this.bitString = new DERBitString(n);
    }

    public String toString() {
        byte[] byArray = this.bitString.getBytes();
        if (byArray.length == 1) {
            return "KeyUsage: 0x" + Integer.toHexString(byArray[0] & 0xFF);
        }
        return "KeyUsage: 0x" + Integer.toHexString((byArray[1] & 0xFF) << 8 | byArray[0] & 0xFF);
    }

    public ASN1Primitive toASN1Primitive() {
        return this.bitString;
    }
}

