/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.bouncycastle.asn1.x509;

import de.businesslogics.bouncycastle.asn1.ASN1EncodableVector;
import de.businesslogics.bouncycastle.asn1.ASN1Object;
import de.businesslogics.bouncycastle.asn1.ASN1ObjectIdentifier;
import de.businesslogics.bouncycastle.asn1.ASN1Primitive;
import de.businesslogics.bouncycastle.asn1.ASN1Sequence;
import de.businesslogics.bouncycastle.asn1.ASN1TaggedObject;
import de.businesslogics.bouncycastle.asn1.DERSequence;
import de.businesslogics.bouncycastle.asn1.x509.Extension;
import de.businesslogics.bouncycastle.util.Properties;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class Extensions
extends ASN1Object {
    private Hashtable extensions = new Hashtable();
    private Vector ordering = new Vector();

    public static Extensions getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        return Extensions.getInstance(ASN1Sequence.getInstance(aSN1TaggedObject, bl));
    }

    public static Extensions getInstance(Object object) {
        if (object instanceof Extensions) {
            return (Extensions)object;
        }
        if (object != null) {
            return new Extensions(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    private Extensions(ASN1Sequence aSN1Sequence) {
        Enumeration enumeration = aSN1Sequence.getObjects();
        while (enumeration.hasMoreElements()) {
            Extension extension = Extension.getInstance(enumeration.nextElement());
            if (this.extensions.containsKey(extension.getExtnId()) && !Properties.isOverrideSet("de.businesslogics.bouncycastle.x509.ignore_repeated_extensions")) {
                throw new IllegalArgumentException("repeated extension found: " + extension.getExtnId());
            }
            this.extensions.put(extension.getExtnId(), extension);
            this.ordering.addElement(extension.getExtnId());
        }
    }

    public Extensions(Extension[] extensionArray) {
        if (extensionArray == null || extensionArray.length == 0) {
            throw new IllegalArgumentException("extension array cannot be null or empty");
        }
        for (int i = 0; i != extensionArray.length; ++i) {
            Extension extension = extensionArray[i];
            this.ordering.addElement(extension.getExtnId());
            this.extensions.put(extension.getExtnId(), extension);
        }
    }

    public Enumeration oids() {
        return this.ordering.elements();
    }

    public Extension getExtension(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        return (Extension)this.extensions.get(aSN1ObjectIdentifier);
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector(this.ordering.size());
        Enumeration enumeration = this.ordering.elements();
        while (enumeration.hasMoreElements()) {
            ASN1ObjectIdentifier aSN1ObjectIdentifier = (ASN1ObjectIdentifier)enumeration.nextElement();
            Extension extension = (Extension)this.extensions.get(aSN1ObjectIdentifier);
            aSN1EncodableVector.add(extension);
        }
        return new DERSequence(aSN1EncodableVector);
    }
}

