/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.bouncycastle.asn1.x509;

import de.businesslogics.bouncycastle.asn1.ASN1Choice;
import de.businesslogics.bouncycastle.asn1.ASN1Encodable;
import de.businesslogics.bouncycastle.asn1.ASN1Object;
import de.businesslogics.bouncycastle.asn1.ASN1Primitive;
import de.businesslogics.bouncycastle.asn1.ASN1Sequence;
import de.businesslogics.bouncycastle.asn1.ASN1TaggedObject;
import de.businesslogics.bouncycastle.asn1.DERTaggedObject;
import de.businesslogics.bouncycastle.asn1.x509.GeneralNames;
import de.businesslogics.bouncycastle.asn1.x509.V2Form;

public class AttCertIssuer
extends ASN1Object
implements ASN1Choice {
    ASN1Encodable obj;
    ASN1Primitive choiceObj;

    public static AttCertIssuer getInstance(Object object) {
        if (object == null || object instanceof AttCertIssuer) {
            return (AttCertIssuer)object;
        }
        if (object instanceof V2Form) {
            return new AttCertIssuer(V2Form.getInstance(object));
        }
        if (object instanceof GeneralNames) {
            return new AttCertIssuer((GeneralNames)object);
        }
        if (object instanceof ASN1TaggedObject) {
            return new AttCertIssuer(V2Form.getInstance((ASN1TaggedObject)object, false));
        }
        if (object instanceof ASN1Sequence) {
            return new AttCertIssuer(GeneralNames.getInstance(object));
        }
        throw new IllegalArgumentException("unknown object in factory: " + object.getClass().getName());
    }

    public AttCertIssuer(GeneralNames generalNames) {
        this.obj = generalNames;
        this.choiceObj = this.obj.toASN1Primitive();
    }

    public AttCertIssuer(V2Form v2Form) {
        this.obj = v2Form;
        this.choiceObj = new DERTaggedObject(false, 0, this.obj);
    }

    public ASN1Primitive toASN1Primitive() {
        return this.choiceObj;
    }
}

