/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.bouncycastle.asn1.x500.style;

import de.businesslogics.bouncycastle.asn1.ASN1Encodable;
import de.businesslogics.bouncycastle.asn1.x500.AttributeTypeAndValue;
import de.businesslogics.bouncycastle.asn1.x500.RDN;
import de.businesslogics.bouncycastle.asn1.x500.X500Name;
import de.businesslogics.bouncycastle.asn1.x500.X500NameStyle;
import de.businesslogics.bouncycastle.asn1.x500.style.IETFUtils;
import java.util.Enumeration;
import java.util.Hashtable;

public abstract class AbstractX500NameStyle
implements X500NameStyle {
    public static Hashtable copyHashTable(Hashtable hashtable) {
        Hashtable hashtable2 = new Hashtable();
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            hashtable2.put(k, hashtable.get(k));
        }
        return hashtable2;
    }

    private int calcHashCode(ASN1Encodable aSN1Encodable) {
        String string = IETFUtils.canonicalString(aSN1Encodable);
        return string.hashCode();
    }

    public int calculateHashCode(X500Name x500Name) {
        int n = 0;
        RDN[] rDNArray = x500Name.getRDNs();
        for (int i = 0; i != rDNArray.length; ++i) {
            if (rDNArray[i].isMultiValued()) {
                AttributeTypeAndValue[] attributeTypeAndValueArray = rDNArray[i].getTypesAndValues();
                for (int j = 0; j != attributeTypeAndValueArray.length; ++j) {
                    n ^= attributeTypeAndValueArray[j].getType().hashCode();
                    n ^= this.calcHashCode(attributeTypeAndValueArray[j].getValue());
                }
                continue;
            }
            n ^= rDNArray[i].getFirst().getType().hashCode();
            n ^= this.calcHashCode(rDNArray[i].getFirst().getValue());
        }
        return n;
    }

    public boolean areEqual(X500Name x500Name, X500Name x500Name2) {
        if (x500Name.size() != x500Name2.size()) {
            return false;
        }
        RDN[] rDNArray = x500Name.getRDNs();
        RDN[] rDNArray2 = x500Name2.getRDNs();
        boolean bl = false;
        AttributeTypeAndValue attributeTypeAndValue = rDNArray[0].getFirst();
        AttributeTypeAndValue attributeTypeAndValue2 = rDNArray2[0].getFirst();
        if (attributeTypeAndValue != null && attributeTypeAndValue2 != null) {
            bl = !attributeTypeAndValue.getType().equals(attributeTypeAndValue2.getType());
        }
        for (int i = 0; i != rDNArray.length; ++i) {
            if (this.foundMatch(bl, rDNArray[i], rDNArray2)) continue;
            return false;
        }
        return true;
    }

    private boolean foundMatch(boolean bl, RDN rDN, RDN[] rDNArray) {
        if (bl) {
            for (int i = rDNArray.length - 1; i >= 0; --i) {
                if (rDNArray[i] == null || !this.rdnAreEqual(rDN, rDNArray[i])) continue;
                rDNArray[i] = null;
                return true;
            }
        } else {
            for (int i = 0; i != rDNArray.length; ++i) {
                if (rDNArray[i] == null || !this.rdnAreEqual(rDN, rDNArray[i])) continue;
                rDNArray[i] = null;
                return true;
            }
        }
        return false;
    }

    protected boolean rdnAreEqual(RDN rDN, RDN rDN2) {
        return IETFUtils.rDNAreEqual(rDN, rDN2);
    }
}

