/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.bouncycastle.asn1;

import de.businesslogics.bouncycastle.asn1.ASN1BitString;
import de.businesslogics.bouncycastle.asn1.ASN1Encodable;
import de.businesslogics.bouncycastle.asn1.ASN1EncodableVector;
import de.businesslogics.bouncycastle.asn1.ASN1External;
import de.businesslogics.bouncycastle.asn1.ASN1OctetString;
import de.businesslogics.bouncycastle.asn1.ASN1OutputStream;
import de.businesslogics.bouncycastle.asn1.ASN1Primitive;
import de.businesslogics.bouncycastle.asn1.ASN1Sequence;
import de.businesslogics.bouncycastle.asn1.ASN1Set;
import de.businesslogics.bouncycastle.asn1.BERBitString;
import de.businesslogics.bouncycastle.asn1.BEROctetString;
import de.businesslogics.bouncycastle.asn1.BERSet;
import java.io.IOException;

public class BERSequence
extends ASN1Sequence {
    public BERSequence() {
    }

    public BERSequence(ASN1Encodable aSN1Encodable) {
        super(aSN1Encodable);
    }

    public BERSequence(ASN1EncodableVector aSN1EncodableVector) {
        super(aSN1EncodableVector);
    }

    int encodedLength(boolean bl) throws IOException {
        int n = bl ? 4 : 3;
        int n2 = this.elements.length;
        for (int i = 0; i < n2; ++i) {
            ASN1Primitive aSN1Primitive = this.elements[i].toASN1Primitive();
            n += aSN1Primitive.encodedLength(true);
        }
        return n;
    }

    void encode(ASN1OutputStream aSN1OutputStream, boolean bl) throws IOException {
        aSN1OutputStream.writeEncodingIL(bl, 48, this.elements);
    }

    ASN1BitString toASN1BitString() {
        return new BERBitString(this.getConstructedBitStrings());
    }

    ASN1External toASN1External() {
        return ((ASN1Sequence)this.toDLObject()).toASN1External();
    }

    ASN1OctetString toASN1OctetString() {
        return new BEROctetString(this.getConstructedOctetStrings());
    }

    ASN1Set toASN1Set() {
        return new BERSet(false, this.toArrayInternal());
    }
}

