/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.bouncycastle.asn1;

import de.businesslogics.bouncycastle.asn1.ASN1TaggedObject;

public abstract class ASN1Util {
    static ASN1TaggedObject checkContextTagClass(ASN1TaggedObject aSN1TaggedObject) {
        return ASN1Util.checkTagClass(aSN1TaggedObject, 128);
    }

    static ASN1TaggedObject checkTagClass(ASN1TaggedObject aSN1TaggedObject, int n) {
        if (!aSN1TaggedObject.hasTagClass(n)) {
            String string = ASN1Util.getTagClassText(n);
            String string2 = ASN1Util.getTagClassText(aSN1TaggedObject);
            throw new IllegalStateException("Expected " + string + " tag but found " + string2);
        }
        return aSN1TaggedObject;
    }

    public static String getTagClassText(ASN1TaggedObject aSN1TaggedObject) {
        return ASN1Util.getTagClassText(aSN1TaggedObject.getTagClass());
    }

    public static String getTagClassText(int n) {
        switch (n) {
            case 64: {
                return "APPLICATION";
            }
            case 128: {
                return "CONTEXT";
            }
            case 192: {
                return "PRIVATE";
            }
        }
        return "UNIVERSAL";
    }

    public static String getTagText(ASN1TaggedObject aSN1TaggedObject) {
        return ASN1Util.getTagText(aSN1TaggedObject.getTagClass(), aSN1TaggedObject.getTagNo());
    }

    public static String getTagText(int n, int n2) {
        switch (n) {
            case 64: {
                return "[APPLICATION " + n2 + "]";
            }
            case 128: {
                return "[CONTEXT " + n2 + "]";
            }
            case 192: {
                return "[PRIVATE " + n2 + "]";
            }
        }
        return "[UNIVERSAL " + n2 + "]";
    }

    public static ASN1TaggedObject getExplicitBaseTagged(ASN1TaggedObject aSN1TaggedObject, int n) {
        return ASN1Util.checkTagClass(aSN1TaggedObject, n).getExplicitBaseTagged();
    }

    public static ASN1TaggedObject getExplicitContextBaseTagged(ASN1TaggedObject aSN1TaggedObject) {
        return ASN1Util.getExplicitBaseTagged(aSN1TaggedObject, 128);
    }
}

