/*
 * Decompiled with CFR 0.152.
 */
package org.jdbcdslog;

import java.io.PrintWriter;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.DataSource;
import javax.sql.PooledConnection;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import org.jdbcdslog.ConnectionLogger;
import org.jdbcdslog.ConnectionLoggingProxy;
import org.jdbcdslog.JDBCDSLogException;
import org.jdbcdslog.PooledConnectionLoggingProxy;
import org.jdbcdslog.XAConnectionLoggingProxy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataSourceProxyBase
implements Serializable {
    private static final long serialVersionUID = -1209576641924549514L;
    static Logger logger = LoggerFactory.getLogger(DataSourceProxyBase.class);
    static final String targetDSParameter = "targetDS";
    Object targetDS = null;
    Map props = new HashMap();
    Map propClasses = new HashMap();

    public Connection getConnection() throws SQLException {
        if (this.targetDS == null) {
            throw new SQLException("targetDS parameter has not been passed to Database or URL property.");
        }
        if (this.targetDS instanceof DataSource) {
            Connection con = ((DataSource)this.targetDS).getConnection();
            if (ConnectionLogger.isInfoEnabled()) {
                ConnectionLogger.info("connect to URL " + con.getMetaData().getURL() + " for user " + con.getMetaData().getUserName());
            }
            return ConnectionLoggingProxy.wrap(con);
        }
        throw new SQLException("targetDS doesn't implement DataSource interface.");
    }

    public Connection getConnection(String username, String password) throws SQLException {
        if (this.targetDS == null) {
            throw new SQLException("targetDS parameter has not been passed to Database or URL property.");
        }
        if (this.targetDS instanceof DataSource) {
            Connection con = ((DataSource)this.targetDS).getConnection(username, password);
            if (ConnectionLogger.isInfoEnabled()) {
                ConnectionLogger.info("connect to URL " + con.getMetaData().getURL() + " for user " + con.getMetaData().getUserName());
            }
            return ConnectionLoggingProxy.wrap(con);
        }
        throw new SQLException("targetDS doesn't implement DataSource interface.");
    }

    public PrintWriter getLogWriter() throws SQLException {
        if (this.targetDS instanceof DataSource) {
            return ((DataSource)this.targetDS).getLogWriter();
        }
        if (this.targetDS instanceof XADataSource) {
            return ((XADataSource)this.targetDS).getLogWriter();
        }
        if (this.targetDS instanceof ConnectionPoolDataSource) {
            return ((ConnectionPoolDataSource)this.targetDS).getLogWriter();
        }
        throw new SQLException("targetDS doesn't have getLogWriter() method");
    }

    public int getLoginTimeout() throws SQLException {
        if (this.targetDS instanceof DataSource) {
            return ((DataSource)this.targetDS).getLoginTimeout();
        }
        if (this.targetDS instanceof XADataSource) {
            return ((XADataSource)this.targetDS).getLoginTimeout();
        }
        if (this.targetDS instanceof ConnectionPoolDataSource) {
            return ((ConnectionPoolDataSource)this.targetDS).getLoginTimeout();
        }
        throw new SQLException("targetDS doesn't have getLogTimeout() method");
    }

    public void setLogWriter(PrintWriter out) throws SQLException {
        if (this.targetDS instanceof DataSource) {
            ((DataSource)this.targetDS).setLogWriter(out);
        }
        if (this.targetDS instanceof XADataSource) {
            ((XADataSource)this.targetDS).setLogWriter(out);
        }
        if (this.targetDS instanceof ConnectionPoolDataSource) {
            ((ConnectionPoolDataSource)this.targetDS).setLogWriter(out);
        }
        throw new SQLException("targetDS doesn't have setLogWriter() method");
    }

    public void setLoginTimeout(int seconds) throws SQLException {
        if (this.targetDS instanceof DataSource) {
            ((DataSource)this.targetDS).setLoginTimeout(seconds);
        }
        if (this.targetDS instanceof XADataSource) {
            ((XADataSource)this.targetDS).setLoginTimeout(seconds);
        }
        if (this.targetDS instanceof ConnectionPoolDataSource) {
            ((ConnectionPoolDataSource)this.targetDS).setLoginTimeout(seconds);
        }
        throw new SQLException("targetDS doesn't have setLogWriter() method");
    }

    public XAConnection getXAConnection() throws SQLException {
        if (this.targetDS == null) {
            throw new SQLException("targetDS parameter has not been passed to Database or URL property.");
        }
        if (this.targetDS instanceof XADataSource) {
            XAConnection con = ((XADataSource)this.targetDS).getXAConnection();
            return XAConnectionLoggingProxy.wrap(con);
        }
        throw new SQLException("targetDS doesn't implement XADataSource interface.");
    }

    public XAConnection getXAConnection(String user, String password) throws SQLException {
        if (this.targetDS == null) {
            throw new SQLException("targetDS parameter has not been passed to Database or URL property.");
        }
        if (this.targetDS instanceof XADataSource) {
            return XAConnectionLoggingProxy.wrap(((XADataSource)this.targetDS).getXAConnection(user, password));
        }
        throw new SQLException("targetDS doesn't implement XADataSource interface.");
    }

    public PooledConnection getPooledConnection() throws SQLException {
        if (this.targetDS == null) {
            throw new SQLException("targetDS parameter has not been passed to Database or URL property.");
        }
        if (this.targetDS instanceof ConnectionPoolDataSource) {
            return PooledConnectionLoggingProxy.wrap(((ConnectionPoolDataSource)this.targetDS).getPooledConnection());
        }
        throw new SQLException("targetDS doesn't implement ConnectionPoolDataSource interface.");
    }

    public PooledConnection getPooledConnection(String user, String password) throws SQLException {
        if (this.targetDS == null) {
            throw new SQLException("targetDS parameter has not been passed to Database or URL property.");
        }
        if (this.targetDS instanceof ConnectionPoolDataSource) {
            return PooledConnectionLoggingProxy.wrap(((ConnectionPoolDataSource)this.targetDS).getPooledConnection(user, password));
        }
        throw new SQLException("targetDS doesn't implement ConnectionPoolDataSource interface.");
    }

    void invokeTargetSetMethod(String m, Object p, Class c) {
        if (this.targetDS == null) {
            this.props.put(m, p);
            this.propClasses.put(m, c);
            return;
        }
        logger.debug(m + "(" + p.toString() + ")");
        try {
            Method me = this.targetDS.getClass().getMethod(m, c);
            if (me != null) {
                me.invoke(this.targetDS, p);
            }
        }
        catch (Exception e) {
            ConnectionLogger.error(e.getMessage(), e);
        }
    }

    public void setURL(String url) throws JDBCDSLogException {
        url = this.initTargetDS(url);
        this.invokeTargetSetMethod("setURL", url, String.class);
    }

    private String initTargetDS(String url) throws JDBCDSLogException {
        String methodName = "initTargedDS() ";
        logger.debug(methodName + "url = " + url + " targedDS = " + this.targetDS);
        try {
            if (url == null || this.targetDS != null) {
                return url;
            }
            logger.debug("Parse url.");
            StringTokenizer ts = new StringTokenizer(url, ":/;=&?", false);
            String targetDSName = null;
            while (ts.hasMoreTokens()) {
                String s = ts.nextToken();
                logger.debug("s = " + s);
                if (!targetDSParameter.equals(s) || !ts.hasMoreTokens()) continue;
                targetDSName = ts.nextToken();
                break;
            }
            if (targetDSName == null) {
                return url;
            }
            url = url.substring(0, url.length() - targetDSName.length() - targetDSParameter.length() - 2);
            this.setTargetDS(targetDSName);
            return url;
        }
        catch (Throwable t) {
            ConnectionLogger.error(t.getMessage(), t);
            throw new JDBCDSLogException(t);
        }
    }

    public void setTargetDSDirect(Object dataSource) {
        String methodName = "setTargetDSDirect() ";
        this.targetDS = dataSource;
        logger.debug(methodName + "targetDS initialized.");
    }

    public void setTargetDS(String targetDSName) throws JDBCDSLogException, InstantiationException, IllegalAccessException {
        String methodName = "setTargetDS() ";
        try {
            Class<?> cl = Class.forName(targetDSName);
            if (cl == null) {
                throw new JDBCDSLogException("Can't load class of targetDS.");
            }
            Object targetObj = cl.newInstance();
            this.targetDS = targetObj;
            logger.debug(methodName + "targetDS initialized.");
            this.setPropertiesForTargetDS();
        }
        catch (Throwable t) {
            ConnectionLogger.error(t.getMessage(), t);
            throw new JDBCDSLogException(t);
        }
    }

    private void setPropertiesForTargetDS() {
        for (String m : this.props.keySet()) {
            this.invokeTargetSetMethod(m, this.props.get(m), (Class)this.propClasses.get(m));
        }
    }

    public void setDatabaseName(String p) {
        this.invokeTargetSetMethod("setDatabaseName", p, String.class);
    }

    public void setDescription(String p) {
        this.invokeTargetSetMethod("setDescription", p, String.class);
    }

    public void setDataSourceName(String p) {
        this.invokeTargetSetMethod("setDataSourceName", p, String.class);
    }

    public void setDriverType(String p) {
        this.invokeTargetSetMethod("setDriverType", p, String.class);
    }

    public void setNetworkProtocol(String p) {
        this.invokeTargetSetMethod("setNetworkProtocol", p, String.class);
    }

    public void setPassword(String p) {
        this.invokeTargetSetMethod("setPassword", p, String.class);
    }

    public void setPortNumber(int p) {
        this.invokeTargetSetMethod("setPortNumber", new Integer(p), Integer.TYPE);
    }

    public void setServerName(String p) {
        this.invokeTargetSetMethod("setServerName", p, String.class);
    }

    public void setServiceName(String p) {
        this.invokeTargetSetMethod("setServiceName", p, String.class);
    }

    public void setTNSEntryName(String p) {
        this.invokeTargetSetMethod("setTNSEntryName", p, String.class);
    }

    public void setUser(String p) {
        this.invokeTargetSetMethod("setUser", p, String.class);
    }

    public void setDatabase(String p) throws JDBCDSLogException {
        p = this.initTargetDS(p);
        this.invokeTargetSetMethod("setDatabase", p, String.class);
    }

    public boolean isWrapperFor(Class iface) throws SQLException {
        return false;
    }

    public Object unwrap(Class iface) throws SQLException {
        return null;
    }
}

