/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.io;

import java.nio.ByteBuffer;
import org.apache.pekko.io.BufferPool;
import org.apache.pekko.io.DirectByteBufferPool$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u00014QAE\n\u0001+mA\u0001B\n\u0001\u0003\u0002\u0003\u0006I\u0001\u000b\u0005\tW\u0001\u0011\t\u0011)A\u0005Q!)A\u0006\u0001C\u0001[!1\u0011\u0007\u0001Q\u0001\nIBa!\u0010\u0001!B\u0013A\u0003\"\u0002 \u0001\t\u0003y\u0004\"\u0002!\u0001\t\u0003\t\u0005\"B$\u0001\t\u0013A\u0005\"B&\u0001\t\u001by\u0004\"\u0002'\u0001\t\u001bi\u0005\"B(\u0001\t\u001b\u0001vAB*\u0014\u0011\u0003)BK\u0002\u0004\u0013'!\u0005Q#\u0016\u0005\u0006Y5!\tA\u0016\u0005\b/6\u0011\r\u0011\"\u0003Y\u0011\u0019aV\u0002)A\u00053\")q*\u0004C\u0001;\n!B)\u001b:fGR\u0014\u0015\u0010^3Ck\u001a4WM\u001d)p_2T!\u0001F\u000b\u0002\u0005%|'B\u0001\f\u0018\u0003\u0015\u0001Xm[6p\u0015\tA\u0012$\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u00025\u0005\u0019qN]4\u0014\u0007\u0001a\"\u0005\u0005\u0002\u001eA5\taDC\u0001 \u0003\u0015\u00198-\u00197b\u0013\t\tcD\u0001\u0004B]f\u0014VM\u001a\t\u0003G\u0011j\u0011aE\u0005\u0003KM\u0011!BQ;gM\u0016\u0014\bk\\8m\u0003E!WMZ1vYR\u0014UO\u001a4feNK'0Z\u0002\u0001!\ti\u0012&\u0003\u0002+=\t\u0019\u0011J\u001c;\u0002\u001d5\f\u0007\u0010U8pY\u0016sGO]5fg\u00061A(\u001b8jiz\"2AL\u00181!\t\u0019\u0003\u0001C\u0003'\u0007\u0001\u0007\u0001\u0006C\u0003,\u0007\u0001\u0007\u0001&\u0001\u0003q_>d\u0007cA\u000f4k%\u0011AG\b\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0003mmj\u0011a\u000e\u0006\u0003qe\n1A\\5p\u0015\u0005Q\u0014\u0001\u00026bm\u0006L!\u0001P\u001c\u0003\u0015\tKH/\u001a\"vM\u001a,'/A\u0007ck\u001a4WM]:J]B{w\u000e\\\u0001\bC\u000e\fX/\u001b:f)\u0005)\u0014a\u0002:fY\u0016\f7/\u001a\u000b\u0003\u0005\u0016\u0003\"!H\"\n\u0005\u0011s\"\u0001B+oSRDQAR\u0004A\u0002U\n1AY;g\u0003!\tG\u000e\\8dCR,GCA\u001bJ\u0011\u0015Q\u0005\u00021\u0001)\u0003\u0011\u0019\u0018N_3\u0002%Q\f7.\u001a\"vM\u001a,'O\u0012:p[B{w\u000e\\\u0001\u0012_\u001a4WM\u001d\"vM\u001a,'\u000fV8Q_>dGC\u0001\"O\u0011\u00151%\u00021\u00016\u0003a!(/_\"mK\u0006tG)\u001b:fGR\u0014\u0015\u0010^3Ck\u001a4WM\u001d\u000b\u0003\u0005FCQAU\u0006A\u0002U\nQ\u0002^8CK\u0012+7\u000f\u001e:ps\u0016$\u0017\u0001\u0006#je\u0016\u001cGOQ=uK\n+hMZ3s!>|G\u000e\u0005\u0002$\u001bM\u0011Q\u0002\b\u000b\u0002)\u0006\t2\t\\3b]\u0012K'/Z2u\u0005V4g-\u001a:\u0016\u0003e\u0003B!\b.6\u0005&\u00111L\b\u0002\n\rVt7\r^5p]F\n!c\u00117fC:$\u0015N]3di\n+hMZ3sAQ\u0011!I\u0018\u0005\u0006?F\u0001\r!N\u0001\u000bEf$XMQ;gM\u0016\u0014\b")
public class DirectByteBufferPool
implements BufferPool {
    private final int defaultBufferSize;
    private final int maxPoolEntries;
    private final ByteBuffer[] pool;
    private int buffersInPool;

    @Override
    public ByteBuffer acquire() {
        return this.takeBufferFromPool();
    }

    @Override
    public void release(ByteBuffer buf) {
        this.offerBufferToPool(buf);
    }

    private ByteBuffer allocate(int size) {
        return ByteBuffer.allocateDirect(size);
    }

    private final ByteBuffer takeBufferFromPool() {
        ByteBuffer[] byteBufferArray = this.pool;
        synchronized (this.pool) {
            ByteBuffer byteBuffer;
            if (this.buffersInPool > 0) {
                --this.buffersInPool;
                byteBuffer = this.pool[this.buffersInPool];
            } else {
                byteBuffer = null;
            }
            ByteBuffer byteBuffer2 = byteBuffer;
            // ** MonitorExit[var2_1] (shouldn't be in output)
            ByteBuffer buffer = byteBuffer2;
            if (buffer == null) {
                return this.allocate(this.defaultBufferSize);
            }
            buffer.clear();
            return buffer;
        }
    }

    private final void offerBufferToPool(ByteBuffer buf) {
        ByteBuffer[] byteBufferArray = this.pool;
        synchronized (this.pool) {
            boolean bl;
            if (this.buffersInPool < this.maxPoolEntries) {
                this.pool[this.buffersInPool] = buf;
                ++this.buffersInPool;
                bl = false;
            } else {
                bl = true;
            }
            boolean bl2 = bl;
            // ** MonitorExit[var3_2] (shouldn't be in output)
            boolean clean = bl2;
            if (clean) {
                this.tryCleanDirectByteBuffer(buf);
                return;
            }
            return;
        }
    }

    private final void tryCleanDirectByteBuffer(ByteBuffer toBeDestroyed) {
        DirectByteBufferPool$.MODULE$.tryCleanDirectByteBuffer(toBeDestroyed);
    }

    public DirectByteBufferPool(int defaultBufferSize, int maxPoolEntries) {
        this.defaultBufferSize = defaultBufferSize;
        this.maxPoolEntries = maxPoolEntries;
        this.pool = new ByteBuffer[maxPoolEntries];
        this.buffersInPool = 0;
    }
}

