/*
 * Decompiled with CFR 0.152.
 */
package play.data.validation;

import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import javax.validation.ConstraintValidatorFactory;
import javax.validation.MessageInterpolator;
import javax.validation.Validation;
import javax.validation.ValidatorFactory;
import org.hibernate.validator.messageinterpolation.ParameterMessageInterpolator;
import org.hibernate.validator.spi.messageinterpolation.LocaleResolver;
import org.hibernate.validator.spi.messageinterpolation.LocaleResolverContext;
import org.springframework.context.i18n.LocaleContextHolder;
import play.i18n.Lang;
import play.i18n.Langs;
import play.inject.ApplicationLifecycle;

@Singleton
public class ValidatorFactoryProvider
implements Provider<ValidatorFactory> {
    private ValidatorFactory validatorFactory;

    @Inject
    public ValidatorFactoryProvider(ConstraintValidatorFactory constraintValidatorFactory, Langs langs, ApplicationLifecycle applicationLifecycle) {
        Set set = langs.availables().stream().map(lang -> lang.locale()).collect(Collectors.toSet());
        Locale locale = langs.preferred((Collection)langs.availables()).toLocale();
        ParameterMessageInterpolator parameterMessageInterpolator = new ParameterMessageInterpolator(set, locale, (LocaleResolver)new RequestAwareLocaleResolver(langs), false);
        this.validatorFactory = Validation.byDefaultProvider().configure().constraintValidatorFactory(constraintValidatorFactory).messageInterpolator((MessageInterpolator)parameterMessageInterpolator).buildValidatorFactory();
        applicationLifecycle.addStopHook(() -> {
            this.validatorFactory.close();
            return CompletableFuture.completedFuture(null);
        });
    }

    public ValidatorFactory get() {
        return this.validatorFactory;
    }

    static class RequestAwareLocaleResolver
    implements LocaleResolver {
        private Langs langs;

        public RequestAwareLocaleResolver(Langs langs) {
            this.langs = langs;
        }

        public Locale resolve(LocaleResolverContext localeResolverContext) {
            Locale locale = localeResolverContext.getDefaultLocale();
            Locale locale2 = LocaleContextHolder.getLocale();
            if (locale2 == null) {
                return locale;
            }
            return this.langs.preferred(Collections.singleton(new Lang(locale2))).toLocale();
        }
    }
}

