/*
 * Decompiled with CFR 0.152.
 */
package play.data;

import com.typesafe.config.Config;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.validation.ValidatorFactory;
import play.data.DynamicForm;
import play.data.Form;
import play.data.format.Formatters;
import play.i18n.MessagesApi;

@Singleton
public class FormFactory {
    private final MessagesApi messagesApi;
    private final Formatters formatters;
    private final ValidatorFactory validatorFactory;
    private final Config config;

    @Inject
    public FormFactory(MessagesApi messagesApi, Formatters formatters, ValidatorFactory validatorFactory, Config config) {
        this.messagesApi = messagesApi;
        this.formatters = formatters;
        this.validatorFactory = validatorFactory;
        this.config = config;
    }

    public DynamicForm form() {
        return new DynamicForm(this.messagesApi, this.formatters, this.validatorFactory, this.config);
    }

    public <T> Form<T> form(Class<T> clazz) {
        return new Form<T>(clazz, this.messagesApi, this.formatters, this.validatorFactory, this.config);
    }

    public <T> Form<T> form(String string, Class<T> clazz) {
        return new Form<T>(string, clazz, this.messagesApi, this.formatters, this.validatorFactory, this.config);
    }

    public <T> Form<T> form(String string, Class<T> clazz, Class<?> ... classArray) {
        return new Form<T>(string, clazz, classArray, this.messagesApi, this.formatters, this.validatorFactory, this.config);
    }

    public <T> Form<T> form(Class<T> clazz, Class<?> ... classArray) {
        return new Form<T>(null, clazz, classArray, this.messagesApi, this.formatters, this.validatorFactory, this.config);
    }
}

