/*
 * Decompiled with CFR 0.152.
 */
package play.data;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.collect.ImmutableList;
import com.typesafe.config.Config;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.validation.ConstraintViolation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.groups.Default;
import javax.validation.metadata.BeanDescriptor;
import javax.validation.metadata.ElementDescriptor;
import org.hibernate.validator.HibernateValidatorFactory;
import org.hibernate.validator.engine.HibernateConstraintViolation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.beans.ConfigurablePropertyAccessor;
import org.springframework.beans.DirectFieldAccessor;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.NotReadablePropertyException;
import org.springframework.beans.PropertyValues;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.context.support.DefaultMessageSourceResolvable;
import org.springframework.core.convert.ConversionService;
import org.springframework.validation.BindingResult;
import org.springframework.validation.DataBinder;
import org.springframework.validation.FieldError;
import org.springframework.validation.beanvalidation.SpringValidatorAdapter;
import play.api.data.Form$;
import play.api.data.FormUtils;
import play.api.i18n.MessagesProvider;
import play.api.libs.json.JsValue;
import play.api.templates.PlayMagic;
import play.data.DynamicForm;
import play.data.format.Formatters;
import play.data.validation.Constraints;
import play.data.validation.ValidationError;
import play.i18n.Lang;
import play.i18n.Messages;
import play.i18n.MessagesApi;
import play.i18n.MessagesImpl;
import play.libs.AnnotationUtils;
import play.libs.F;
import play.libs.Json;
import play.libs.Scala;
import play.libs.typedmap.TypedMap;
import play.mvc.Http;
import scala.collection.Map;

public class Form<T> {
    private static final Pattern REPLACE_COLLECTION_ELEMENT = Pattern.compile("\\.?<[^<]*>");
    private static final Pattern REPLACE_TYPEMISMATCH = Pattern.compile("typeMismatch", 16);
    private static final String INVALID_MSG_KEY = "error.invalid";
    private final String rootName;
    private final Class<T> backedType;
    private final java.util.Map<String, String> rawData;
    private final java.util.Map<String, Http.MultipartFormData.FilePart<?>> files;
    private final List<ValidationError> errors;
    private final Optional<T> value;
    private final Class<?>[] groups;
    private final Lang lang;
    private final boolean directFieldAccess;
    final MessagesApi messagesApi;
    final Formatters formatters;
    final ValidatorFactory validatorFactory;
    final Config config;
    protected final Logger logger;
    private static final Set<String> internalAnnotationAttributes = new HashSet<String>(3);

    public Class<T> getBackedType() {
        return this.backedType;
    }

    protected T blankInstance() {
        try {
            return this.backedType.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception exception) {
            throw new RuntimeException("Cannot instantiate " + String.valueOf(this.backedType) + ". It must have a default constructor", exception);
        }
    }

    public Form(Class<T> clazz, MessagesApi messagesApi, Formatters formatters, ValidatorFactory validatorFactory, Config config) {
        this(null, clazz, messagesApi, formatters, validatorFactory, config);
    }

    public Form(String string, Class<T> clazz, MessagesApi messagesApi, Formatters formatters, ValidatorFactory validatorFactory, Config config) {
        this(string, clazz, (Class)null, messagesApi, formatters, validatorFactory, config);
    }

    public Form(String string, Class<T> clazz, Class<?> clazz2, MessagesApi messagesApi, Formatters formatters, ValidatorFactory validatorFactory, Config config) {
        Class[] classArray;
        if (clazz2 != null) {
            Class[] classArray2 = new Class[1];
            classArray = classArray2;
            classArray2[0] = clazz2;
        } else {
            classArray = null;
        }
        this(string, clazz, classArray, messagesApi, formatters, validatorFactory, config);
    }

    public Form(String string, Class<T> clazz, Class<?>[] classArray, MessagesApi messagesApi, Formatters formatters, ValidatorFactory validatorFactory, Config config) {
        this(string, clazz, new HashMap<String, String>(), new ArrayList<ValidationError>(), Optional.empty(), classArray, messagesApi, formatters, validatorFactory, config);
    }

    public Form(String string, Class<T> clazz, java.util.Map<String, String> map, List<ValidationError> list, Optional<T> optional, MessagesApi messagesApi, Formatters formatters, ValidatorFactory validatorFactory, Config config) {
        this(string, clazz, map, Collections.emptyMap(), list, optional, messagesApi, formatters, validatorFactory, config);
    }

    public Form(String string, Class<T> clazz, java.util.Map<String, String> map, java.util.Map<String, Http.MultipartFormData.FilePart<?>> map2, List<ValidationError> list, Optional<T> optional, MessagesApi messagesApi, Formatters formatters, ValidatorFactory validatorFactory, Config config) {
        this(string, clazz, map, map2, list, optional, (Class)null, messagesApi, formatters, validatorFactory, config);
    }

    public Form(String string, Class<T> clazz, java.util.Map<String, String> map, List<ValidationError> list, Optional<T> optional, Class<?> clazz2, MessagesApi messagesApi, Formatters formatters, ValidatorFactory validatorFactory, Config config) {
        this(string, clazz, map, Collections.emptyMap(), list, optional, clazz2, messagesApi, formatters, validatorFactory, config);
    }

    public Form(String string, Class<T> clazz, java.util.Map<String, String> map, java.util.Map<String, Http.MultipartFormData.FilePart<?>> map2, List<ValidationError> list, Optional<T> optional, Class<?> clazz2, MessagesApi messagesApi, Formatters formatters, ValidatorFactory validatorFactory, Config config) {
        Class[] classArray;
        if (clazz2 != null) {
            Class[] classArray2 = new Class[1];
            classArray = classArray2;
            classArray2[0] = clazz2;
        } else {
            classArray = null;
        }
        this(string, clazz, map, map2, list, optional, classArray, messagesApi, formatters, validatorFactory, config);
    }

    public Form(String string, Class<T> clazz, java.util.Map<String, String> map, List<ValidationError> list, Optional<T> optional, Class<?>[] classArray, MessagesApi messagesApi, Formatters formatters, ValidatorFactory validatorFactory, Config config) {
        this(string, clazz, map, Collections.emptyMap(), list, optional, classArray, messagesApi, formatters, validatorFactory, config);
    }

    public Form(String string, Class<T> clazz, java.util.Map<String, String> map, java.util.Map<String, Http.MultipartFormData.FilePart<?>> map2, List<ValidationError> list, Optional<T> optional, Class<?>[] classArray, MessagesApi messagesApi, Formatters formatters, ValidatorFactory validatorFactory, Config config) {
        this(string, clazz, map, map2, list, optional, classArray, messagesApi, formatters, validatorFactory, config, null);
    }

    public Form(String string, Class<T> clazz, java.util.Map<String, String> map, List<ValidationError> list, Optional<T> optional, Class<?>[] classArray, MessagesApi messagesApi, Formatters formatters, ValidatorFactory validatorFactory, Config config, Lang lang) {
        this(string, clazz, map, Collections.emptyMap(), list, optional, classArray, messagesApi, formatters, validatorFactory, config, lang);
    }

    public Form(String string, Class<T> clazz, java.util.Map<String, String> map, java.util.Map<String, Http.MultipartFormData.FilePart<?>> map2, List<ValidationError> list, Optional<T> optional, Class<?>[] classArray, MessagesApi messagesApi, Formatters formatters, ValidatorFactory validatorFactory, Config config, Lang lang) {
        this(string, clazz, map, map2, list, optional, classArray, messagesApi, formatters, validatorFactory, config, lang, config != null && config.getBoolean("play.forms.binding.directFieldAccess"));
    }

    public Form(String string, Class<T> clazz, java.util.Map<String, String> map, List<ValidationError> list, Optional<T> optional, Class<?>[] classArray, MessagesApi messagesApi, Formatters formatters, ValidatorFactory validatorFactory, Config config, Lang lang, boolean bl) {
        this(string, clazz, map, Collections.emptyMap(), list, optional, classArray, messagesApi, formatters, validatorFactory, config, lang, bl);
    }

    public Form(String string, Class<T> clazz, java.util.Map<String, String> map, java.util.Map<String, Http.MultipartFormData.FilePart<?>> map2, List<ValidationError> list, Optional<T> optional, Class<?>[] classArray, MessagesApi messagesApi, Formatters formatters, ValidatorFactory validatorFactory, Config config, Lang lang, boolean bl) {
        this.logger = LoggerFactory.getLogger(this.getClass());
        this.rootName = string;
        this.backedType = clazz;
        this.rawData = map != null ? new HashMap<String, String>(map) : new HashMap();
        this.files = map2 != null ? new HashMap(map2) : new HashMap();
        this.errors = list != null ? new ArrayList<ValidationError>(list) : new ArrayList();
        this.value = optional;
        this.groups = classArray;
        this.messagesApi = messagesApi;
        this.formatters = formatters;
        this.validatorFactory = validatorFactory;
        this.config = config;
        this.lang = lang;
        this.directFieldAccess = bl;
    }

    protected long maxJsonChars() {
        return this.config.getMemorySize("play.http.parser.maxMemoryBuffer").toBytes();
    }

    protected int maxJsonDepth() {
        return Form$.MODULE$.FromJsonMaxDepth();
    }

    protected java.util.Map<String, String> requestData(Http.Request request) {
        HashMap<String, String[]> hashMap = new HashMap();
        if (request.body().asFormUrlEncoded() != null) {
            hashMap = request.body().asFormUrlEncoded();
        }
        HashMap<String, String[]> hashMap2 = new HashMap();
        if (request.body().asMultipartFormData() != null) {
            hashMap2 = request.body().asMultipartFormData().asFormUrlEncoded();
        }
        java.util.Map<String, String> map = new HashMap();
        if (request.body().asJson() != null) {
            map = Scala.asJava((Map)FormUtils.fromJson((JsValue)play.api.libs.json.Json.parse((String)Json.stringify((JsonNode)request.body().asJson())), (long)this.maxJsonChars(), (int)this.maxJsonDepth()));
        }
        HashMap<String, String> hashMap3 = new HashMap<String, String>();
        this.fillDataWith(hashMap3, hashMap);
        this.fillDataWith(hashMap3, hashMap2);
        map.forEach(hashMap3::put);
        if (!(request.method().equalsIgnoreCase("POST") || request.method().equalsIgnoreCase("PUT") || request.method().equalsIgnoreCase("PATCH"))) {
            this.fillDataWith(hashMap3, request.queryString());
        }
        return hashMap3;
    }

    protected void fillDataWith(java.util.Map<String, String> map, java.util.Map<String, String[]> map2) {
        map2.forEach((string, stringArray) -> this.fillDataWith((String)string, (java.util.Map<String, T>)map, ((String[])stringArray).length, n -> stringArray[n]));
    }

    protected java.util.Map<String, Http.MultipartFormData.FilePart<?>> requestFileData(Http.Request request) {
        Http.MultipartFormData multipartFormData = request.body().asMultipartFormData();
        if (multipartFormData != null) {
            return this.resolveDuplicateFilePartKeys(multipartFormData.getFiles());
        }
        return new HashMap();
    }

    protected <A> java.util.Map<String, Http.MultipartFormData.FilePart<?>> resolveDuplicateFilePartKeys(List<Http.MultipartFormData.FilePart<A>> list3) {
        java.util.Map<String, List> map = list3.stream().collect(Collectors.toMap(Http.MultipartFormData.FilePart::getKey, filePart -> new ArrayList<Http.MultipartFormData.FilePart>(Collections.singletonList(filePart)), (list, list2) -> {
            list.addAll(list2);
            return list;
        }));
        HashMap hashMap = new HashMap();
        map.forEach((string, list) -> this.fillDataWith((String)string, hashMap, list.size(), list::get));
        return hashMap;
    }

    protected <T> void fillDataWith(String string, java.util.Map<String, T> map, int n, Function<Integer, T> function) {
        if (string.endsWith("[]") || string.contains("[].")) {
            int n2;
            Object object = string;
            String string2 = "";
            if (string.endsWith("[]")) {
                object = string.substring(0, string.length() - 2);
            }
            while ((n2 = ((String)object).lastIndexOf("[].")) != -1) {
                if (string.endsWith("[]") || !string2.isEmpty()) {
                    object = ((String)object).substring(0, n2) + "[0]" + ((String)object).substring(n2 + 2);
                    continue;
                }
                string2 = ((String)object).substring(n2 + 2);
                object = ((String)object).substring(0, n2);
            }
            for (n2 = 0; n2 < n; ++n2) {
                map.put((String)object + "[" + n2 + "]" + string2, function.apply(n2));
            }
        } else if (n > 0) {
            map.put(string, function.apply(0));
        }
    }

    public Form<T> bindFromRequest(Http.Request request, String ... stringArray) {
        return this.bind(this.messagesApi.preferred((Http.RequestHeader)request).lang(), request.attrs(), this.requestData(request), this.requestFileData(request), stringArray);
    }

    public Form<T> bindFromRequestData(Lang lang, TypedMap typedMap, java.util.Map<String, String[]> map, String ... stringArray) {
        return this.bindFromRequestData(lang, typedMap, map, Collections.emptyMap(), stringArray);
    }

    public Form<T> bindFromRequestData(Lang lang, TypedMap typedMap, java.util.Map<String, String[]> map, java.util.Map<String, Http.MultipartFormData.FilePart<?>> map2, String ... stringArray) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        this.fillDataWith(hashMap, map);
        return this.bind(lang, typedMap, hashMap, map2, stringArray);
    }

    @Deprecated
    public Form<T> bind(Lang lang, TypedMap typedMap, JsonNode jsonNode, String ... stringArray) {
        this.logger.warn("Binding json field from form with a hardcoded max size of {} bytes. This is deprecated. Use bind(Lang, TypedMap, JsonNode, Int, String...) instead.", (Object)this.maxJsonChars());
        return this.bind(lang, typedMap, jsonNode, this.maxJsonChars(), stringArray);
    }

    public Form<T> bind(Lang lang, TypedMap typedMap, JsonNode jsonNode, long l, String ... stringArray) {
        return this.bind(lang, typedMap, (java.util.Map<String, String>)Scala.asJava((Map)FormUtils.fromJson((JsValue)play.api.libs.json.Json.parse((String)Json.stringify((JsonNode)jsonNode)), (long)l, (int)this.maxJsonDepth())), stringArray);
    }

    public Form<T> bind(Lang lang, TypedMap typedMap, JsonNode jsonNode, long l, int n, String ... stringArray) {
        return this.bind(lang, typedMap, (java.util.Map<String, String>)Scala.asJava((Map)FormUtils.fromJson((JsValue)play.api.libs.json.Json.parse((String)Json.stringify((JsonNode)jsonNode)), (long)l, (int)n)), stringArray);
    }

    protected Object[] getArgumentsForConstraint(String string2, String string3, ConstraintViolation<Object> constraintViolation) {
        Annotation annotation = constraintViolation.getConstraintDescriptor().getAnnotation();
        if (annotation instanceof Constraints.ValidateWith) {
            Constraints.ValidateWith validateWith = (Constraints.ValidateWith)annotation;
            if (constraintViolation.getMessage().equals(INVALID_MSG_KEY)) {
                Constraints.ValidateWithValidator validateWithValidator = new Constraints.ValidateWithValidator();
                validateWithValidator.initialize(validateWith);
                F.Tuple<String, Object[]> tuple = validateWithValidator.getErrorMessageKey();
                if (tuple != null && tuple._2 != null) {
                    return (Object[])tuple._2;
                }
                return new Object[0];
            }
            return new Object[0];
        }
        LinkedList<Object> linkedList = new LinkedList<Object>();
        String[] stringArray = new String[]{string2 + "." + string3, string3};
        linkedList.add(new DefaultMessageSourceResolvable(stringArray, string3));
        TreeMap treeMap = new TreeMap();
        constraintViolation.getConstraintDescriptor().getAttributes().forEach((string, object) -> {
            if (!internalAnnotationAttributes.contains(string)) {
                treeMap.put(string, object);
            }
        });
        linkedList.addAll(treeMap.values());
        return linkedList.toArray(new Object[linkedList.size()]);
    }

    protected String getMessageForConstraintViolation(ConstraintViolation<Object> constraintViolation) {
        F.Tuple<String, Object[]> tuple;
        Object object;
        Annotation annotation;
        String string = constraintViolation.getMessage();
        Annotation annotation2 = constraintViolation.getConstraintDescriptor().getAnnotation();
        if (annotation2 instanceof Constraints.ValidateWith) {
            annotation = (Constraints.ValidateWith)annotation2;
            if (constraintViolation.getMessage().equals(INVALID_MSG_KEY)) {
                object = new Constraints.ValidateWithValidator();
                ((Constraints.ValidateWithValidator)object).initialize((Constraints.ValidateWith)annotation);
                tuple = ((Constraints.ValidateWithValidator)object).getErrorMessageKey();
                if (tuple != null && tuple._1 != null) {
                    string = (String)tuple._1;
                }
            }
        }
        if (annotation2 instanceof Constraints.ValidatePayloadWith) {
            annotation = (Constraints.ValidatePayloadWith)annotation2;
            if (constraintViolation.getMessage().equals(INVALID_MSG_KEY)) {
                object = new Constraints.ValidatePayloadWithValidator();
                ((Constraints.ValidatePayloadWithValidator)object).initialize((Constraints.ValidatePayloadWith)annotation);
                tuple = ((Constraints.ValidatePayloadWithValidator)object).getErrorMessageKey();
                if (tuple != null && tuple._1 != null) {
                    string = (String)tuple._1;
                }
            }
        }
        return string;
    }

    private DataBinder dataBinder(String ... stringArray) {
        DataBinder dataBinder = this.rootName == null ? new DataBinder(this.blankInstance()) : new DataBinder(this.blankInstance(), this.rootName);
        if (stringArray.length > 0) {
            dataBinder.setAllowedFields(stringArray);
        }
        SpringValidatorAdapter springValidatorAdapter = new SpringValidatorAdapter(this.validatorFactory.getValidator());
        dataBinder.setValidator((org.springframework.validation.Validator)springValidatorAdapter);
        dataBinder.setConversionService((ConversionService)this.formatters.conversion);
        dataBinder.setAutoGrowNestedPaths(true);
        if (this.directFieldAccess) {
            dataBinder.initDirectFieldAccess();
        }
        return dataBinder;
    }

    private java.util.Map<String, Object> getObjectData(java.util.Map<String, String> map, java.util.Map<String, Http.MultipartFormData.FilePart<?>> map2) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>(map);
        hashMap.putAll(map2);
        if (this.rootName != null) {
            HashMap<String, Object> hashMap2 = new HashMap<String, Object>();
            hashMap.forEach((string, object) -> {
                if (string.startsWith(this.rootName + ".")) {
                    hashMap2.put(string.substring(this.rootName.length() + 1), object);
                }
            });
            return hashMap2;
        }
        return hashMap;
    }

    private Set<ConstraintViolation<Object>> runValidation(Lang lang, TypedMap typedMap, DataBinder dataBinder, java.util.Map<String, Object> map) {
        return Form.withRequestLocale(lang, () -> {
            dataBinder.bind((PropertyValues)new MutablePropertyValues(map));
            MessagesImpl messagesImpl = lang == null ? null : new MessagesImpl(lang, this.messagesApi);
            Constraints.ValidationPayload validationPayload = new Constraints.ValidationPayload(lang, (Messages)messagesImpl, typedMap, this.config);
            Validator validator = ((HibernateValidatorFactory)this.validatorFactory.unwrap(HibernateValidatorFactory.class)).usingContext().constraintValidatorPayload((Object)validationPayload).getValidator();
            if (this.groups != null) {
                return validator.validate(dataBinder.getTarget(), (Class[])this.groups);
            }
            return validator.validate(dataBinder.getTarget(), new Class[0]);
        });
    }

    private void addConstraintViolationToBindingResult(ConstraintViolation<Object> constraintViolation, BindingResult bindingResult) {
        String string = REPLACE_COLLECTION_ELEMENT.matcher(constraintViolation.getPropertyPath().toString()).replaceAll("");
        FieldError fieldError = bindingResult.getFieldError(string);
        if (fieldError == null || !fieldError.isBindingFailure()) {
            try {
                Object object = ((HibernateConstraintViolation)constraintViolation.unwrap(HibernateConstraintViolation.class)).getDynamicPayload(Object.class);
                if (object instanceof String) {
                    bindingResult.rejectValue("", constraintViolation.getConstraintDescriptor().getAnnotation().annotationType().getSimpleName(), new Object[0], (String)object);
                } else if (object instanceof ValidationError) {
                    Form.rejectValidationError(constraintViolation, bindingResult, (ValidationError)object, string);
                } else if (object instanceof List) {
                    ((List)object).forEach(validationError -> Form.rejectValidationError(constraintViolation, bindingResult, validationError, string));
                } else {
                    bindingResult.rejectValue(string, constraintViolation.getConstraintDescriptor().getAnnotation().annotationType().getSimpleName(), this.getArgumentsForConstraint(bindingResult.getObjectName(), string, constraintViolation), this.getMessageForConstraintViolation(constraintViolation));
                }
            }
            catch (NotReadablePropertyException notReadablePropertyException) {
                throw new IllegalStateException("JSR-303 validated property '" + string + "' does not have a corresponding accessor for data binding - check your DataBinder's configuration (bean property versus direct field access)", notReadablePropertyException);
            }
        }
    }

    private static void rejectValidationError(ConstraintViolation<Object> constraintViolation, BindingResult bindingResult, ValidationError validationError, String string) {
        String string2 = string == null || string.isEmpty() ? "" : string + ".";
        bindingResult.rejectValue((String)(validationError.key() != null && !validationError.key().isEmpty() ? string2 + validationError.key() : validationError.key()), constraintViolation.getConstraintDescriptor().getAnnotation().annotationType().getSimpleName(), validationError.arguments() != null ? validationError.arguments().toArray() : new Object[]{}, validationError.message());
    }

    private List<ValidationError> getFieldErrorsAsValidationErrors(Lang lang, BindingResult bindingResult) {
        return bindingResult.getFieldErrors().stream().map(fieldError -> {
            Object object = fieldError.getObjectName() + "." + fieldError.getField();
            if (((String)object).startsWith("target.") && this.rootName == null) {
                object = ((String)object).substring(7);
            }
            if (fieldError.isBindingFailure()) {
                ImmutableList.Builder builder = ImmutableList.builder();
                MessagesImpl messagesImpl = lang != null ? new MessagesImpl(lang, this.messagesApi) : null;
                for (String string : fieldError.getCodes()) {
                    string = REPLACE_TYPEMISMATCH.matcher(string).replaceAll(Matcher.quoteReplacement(INVALID_MSG_KEY));
                    if (messagesImpl != null && !messagesImpl.isDefinedAt(string).booleanValue()) continue;
                    builder.add((Object)string);
                }
                ImmutableList immutableList = builder.build();
                return new ValidationError((String)object, immutableList.isEmpty() ? Arrays.asList(INVALID_MSG_KEY) : immutableList.reverse(), this.convertErrorArguments(fieldError.getArguments()));
            }
            return new ValidationError((String)object, fieldError.getDefaultMessage(), this.convertErrorArguments(fieldError.getArguments()));
        }).collect(Collectors.toList());
    }

    private List<ValidationError> globalErrorsAsValidationErrors(BindingResult bindingResult) {
        return bindingResult.getGlobalErrors().stream().map(objectError -> new ValidationError("", objectError.getDefaultMessage(), this.convertErrorArguments(objectError.getArguments()))).collect(Collectors.toList());
    }

    public Form<T> bind(Lang lang, TypedMap typedMap, java.util.Map<String, String> map, String ... stringArray) {
        return this.bind(lang, typedMap, map, Collections.emptyMap(), stringArray);
    }

    public Form<T> bind(Lang lang, TypedMap typedMap, java.util.Map<String, String> map, java.util.Map<String, Http.MultipartFormData.FilePart<?>> map2, String ... stringArray) {
        boolean bl;
        DataBinder dataBinder = this.dataBinder(stringArray);
        java.util.Map<String, Object> map3 = this.getObjectData(map, map2);
        Set<ConstraintViolation<Object>> set = this.runValidation(lang, typedMap, dataBinder, map3);
        BindingResult bindingResult = dataBinder.getBindingResult();
        set.forEach(constraintViolation -> this.addConstraintViolationToBindingResult((ConstraintViolation<Object>)constraintViolation, bindingResult));
        boolean bl2 = bl = bindingResult.hasErrors() || bindingResult.getGlobalErrorCount() > 0;
        if (bl) {
            List<ValidationError> list = this.getFieldErrorsAsValidationErrors(lang, bindingResult);
            List<ValidationError> list2 = this.globalErrorsAsValidationErrors(bindingResult);
            list.addAll(list2);
            return new Form<Object>(this.rootName, this.backedType, map, map2, list, Optional.ofNullable(bindingResult.getTarget()), this.groups, this.messagesApi, this.formatters, this.validatorFactory, this.config, lang, this.directFieldAccess);
        }
        return new Form<Object>(this.rootName, this.backedType, map, map2, this.errors, Optional.ofNullable(bindingResult.getTarget()), this.groups, this.messagesApi, this.formatters, this.validatorFactory, this.config, lang, this.directFieldAccess);
    }

    private List<Object> convertErrorArguments(Object[] objectArray) {
        if (objectArray == null) {
            return Collections.emptyList();
        }
        List list = Arrays.stream(objectArray).filter(object -> !(object instanceof DefaultMessageSourceResolvable)).collect(Collectors.toList());
        return Collections.unmodifiableList(list);
    }

    public java.util.Map<String, String> rawData() {
        return Collections.unmodifiableMap(this.rawData);
    }

    public java.util.Map<String, Http.MultipartFormData.FilePart<?>> files() {
        return Collections.unmodifiableMap(this.files);
    }

    public String name() {
        return this.rootName;
    }

    public Optional<T> value() {
        return this.value;
    }

    public Form<T> fill(T t) {
        if (t == null) {
            throw new RuntimeException("Cannot fill a form with a null value");
        }
        return new Form<T>(this.rootName, this.backedType, new HashMap<String, String>(), new HashMap(), new ArrayList<ValidationError>(), Optional.ofNullable(t), this.groups, this.messagesApi, this.formatters, this.validatorFactory, this.config, this.lang, this.directFieldAccess);
    }

    public boolean hasErrors() {
        return !this.errors.isEmpty();
    }

    public boolean hasGlobalErrors() {
        return !this.globalErrors().isEmpty();
    }

    public List<ValidationError> globalErrors() {
        return Collections.unmodifiableList(this.errors.stream().filter(validationError -> validationError.key().isEmpty()).collect(Collectors.toList()));
    }

    public Optional<ValidationError> globalError() {
        return this.globalErrors().stream().findFirst();
    }

    public List<ValidationError> errors() {
        return Collections.unmodifiableList(this.errors);
    }

    public List<ValidationError> errors(String string) {
        if (string == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.errors.stream().filter(validationError -> validationError.key().equals(string)).collect(Collectors.toList()));
    }

    public Optional<ValidationError> error(String string) {
        return this.errors(string).stream().findFirst();
    }

    public JsonNode errorsAsJson() {
        return this.errorsAsJson(this.lang);
    }

    public JsonNode errorsAsJson(Lang lang) {
        HashMap hashMap = new HashMap();
        this.errors.forEach(validationError -> {
            if (validationError != null) {
                ArrayList<String> arrayList = new ArrayList<String>();
                if (this.messagesApi != null && lang != null) {
                    ArrayList<String> arrayList2 = new ArrayList<String>(validationError.messages());
                    Collections.reverse(arrayList2);
                    arrayList.add(this.messagesApi.get((play.api.i18n.Lang)lang, arrayList2, new Object[]{PlayMagic.translate(validationError.arguments(), (MessagesProvider)new MessagesImpl(lang, this.messagesApi))}));
                } else {
                    arrayList.add(validationError.message());
                }
                hashMap.put(validationError.key(), arrayList);
            }
        });
        return Json.toJson(hashMap);
    }

    public T get() {
        return this.get(this.lang);
    }

    public T get(Lang lang) {
        if (!this.errors.isEmpty()) {
            throw new IllegalStateException("Error(s) binding form: " + String.valueOf(this.errorsAsJson(lang)));
        }
        return this.value.get();
    }

    public Form<T> withError(ValidationError validationError) {
        if (validationError == null) {
            throw new NullPointerException("Can't reject null-values");
        }
        ArrayList<ValidationError> arrayList = new ArrayList<ValidationError>(this.errors);
        arrayList.add(validationError);
        return new Form<T>(this.rootName, this.backedType, this.rawData, this.files, arrayList, this.value, this.groups, this.messagesApi, this.formatters, this.validatorFactory, this.config, this.lang, this.directFieldAccess);
    }

    public Form<T> withError(String string, String string2, List<Object> list) {
        return this.withError(new ValidationError(string, string2, list != null ? new ArrayList<Object>(list) : new ArrayList()));
    }

    public Form<T> withError(String string, String string2) {
        return this.withError(string, string2, new ArrayList<Object>());
    }

    public Form<T> withGlobalError(String string, List<Object> list) {
        return this.withError("", string, list);
    }

    public Form<T> withGlobalError(String string) {
        return this.withGlobalError(string, new ArrayList<Object>());
    }

    public Form<T> discardingErrors() {
        return new Form<T>(this.rootName, this.backedType, this.rawData, this.files, new ArrayList<ValidationError>(), this.value, this.groups, this.messagesApi, this.formatters, this.validatorFactory, this.config, this.lang, this.directFieldAccess);
    }

    public Field apply(String string) {
        return this.apply(string, this.lang);
    }

    public Field apply(String string, Lang lang) {
        return this.field(string, lang);
    }

    public Field field(String string) {
        return this.field(string, this.lang);
    }

    public Field field(String string, Lang lang) {
        int n;
        Object object;
        Annotation[] annotationArray;
        Display display;
        BeanDescriptor beanDescriptor;
        Object object2;
        Object object3;
        ConfigurablePropertyAccessor configurablePropertyAccessor;
        String string2 = null;
        Http.MultipartFormData.FilePart filePart = null;
        if (this.rawData.containsKey(string)) {
            string2 = this.rawData.get(string);
        } else if (this.files.containsKey(string)) {
            filePart = this.files.get(string);
        } else if (this.value.isPresent()) {
            configurablePropertyAccessor = this.propertyAccessor(this.value.get());
            configurablePropertyAccessor.setAutoGrowNestedPaths(true);
            object3 = string;
            if (this.rootName != null && string.startsWith(this.rootName + ".")) {
                object3 = string.substring(this.rootName.length() + 1);
            }
            if (configurablePropertyAccessor.isReadableProperty((String)object3) && (object2 = configurablePropertyAccessor.getPropertyValue((String)object3)) != null) {
                if (object2 instanceof Http.MultipartFormData.FilePart) {
                    filePart = (Http.MultipartFormData.FilePart)object2;
                } else if (this.formatters != null) {
                    Object object4 = object3;
                    string2 = Form.withRequestLocale(lang, () -> this.lambda$field$16(configurablePropertyAccessor, (String)object4, object2));
                } else {
                    string2 = object2.toString();
                }
            }
        }
        configurablePropertyAccessor = null;
        object3 = this.propertyAccessor(this.blankInstance());
        object3.setAutoGrowNestedPaths(true);
        try {
            for (Annotation annotation : object3.getPropertyTypeDescriptor(string).getAnnotations()) {
                beanDescriptor = annotation.annotationType();
                if (!beanDescriptor.isAnnotationPresent(Display.class) || !(display = beanDescriptor.getAnnotation(Display.class)).name().startsWith("format.")) continue;
                annotationArray = new ArrayList();
                object = display.attributes();
                int n2 = ((String[])object).length;
                for (int i = 0; i < n2; ++i) {
                    Object object5 = object[i];
                    Object object6 = null;
                    try {
                        object6 = annotation.getClass().getDeclaredMethod((String)object5, new Class[0]).invoke((Object)annotation, new Object[0]);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    annotationArray.add(object6);
                }
                configurablePropertyAccessor = F.Tuple((Object)display.name(), Collections.unmodifiableList(annotationArray));
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        object2 = new ArrayList();
        Class clazz = this.backedType;
        String string3 = string;
        if (this.rootName != null && string3.startsWith(this.rootName + ".")) {
            string3 = string3.substring(this.rootName.length() + 1);
        }
        if ((n = string3.lastIndexOf(46)) > 0) {
            clazz = object3.getPropertyType(string3.substring(0, n));
            string3 = string3.substring(n + 1);
        }
        if (clazz != null && this.validatorFactory != null && (beanDescriptor = this.validatorFactory.getValidator().getConstraintsForClass(clazz)) != null && (display = beanDescriptor.getConstraintsForProperty(string3)) != null) {
            Class[] classArray;
            annotationArray = null;
            for (object = clazz; object != null; object = ((Class)object).getSuperclass()) {
                java.lang.reflect.Field field = null;
                try {
                    field = ((Class)object).getDeclaredField(string3);
                }
                catch (NoSuchFieldException | SecurityException exception) {
                    continue;
                }
                annotationArray = AnnotationUtils.unwrapContainerAnnotations((Annotation[])field.getDeclaredAnnotations());
                break;
            }
            ElementDescriptor.ConstraintFinder constraintFinder = display.findConstraints();
            if (this.groups != null) {
                classArray = this.groups;
            } else {
                Class[] classArray2 = new Class[1];
                classArray = classArray2;
                classArray2[0] = Default.class;
            }
            object2 = Constraints.displayableConstraint(constraintFinder.unorderedAndMatchingGroups(classArray).getConstraintDescriptors(), annotationArray);
        }
        return new Field(this, string, (List<F.Tuple<String, List<Object>>>)object2, (F.Tuple<String, List<Object>>)configurablePropertyAccessor, this.errors(string), string2, filePart);
    }

    public Optional<Lang> lang() {
        return Optional.ofNullable(this.lang);
    }

    public Form<T> withLang(Lang lang) {
        return new Form<T>(this.rootName, this.backedType, this.rawData, this.files, this.errors, this.value, this.groups, this.messagesApi, this.formatters, this.validatorFactory, this.config, lang, this.directFieldAccess);
    }

    public Form<T> withDirectFieldAccess(boolean bl) {
        return new Form<T>(this.rootName, this.backedType, this.rawData, this.files, this.errors, this.value, this.groups, this.messagesApi, this.formatters, this.validatorFactory, this.config, this.lang, bl);
    }

    ConfigurablePropertyAccessor propertyAccessor(Object object) {
        return this.directFieldAccess ? new DirectFieldAccessor(object) : new BeanWrapperImpl(object);
    }

    public String toString() {
        return "Form(of=" + String.valueOf(this.backedType) + ", data=" + String.valueOf(this.rawData) + ", value=" + String.valueOf(this.value) + ", errors=" + String.valueOf(this.errors) + ")";
    }

    private static <T> T withRequestLocale(Lang lang, Supplier<T> supplier) {
        try {
            LocaleContextHolder.setLocale((Locale)(lang != null ? lang.toLocale() : null));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            T t = supplier.get();
            return t;
        }
        finally {
            LocaleContextHolder.resetLocaleContext();
        }
    }

    private /* synthetic */ String lambda$field$16(ConfigurablePropertyAccessor configurablePropertyAccessor, String string, Object object) {
        return this.formatters.print(configurablePropertyAccessor.getPropertyTypeDescriptor(string), object);
    }

    static {
        internalAnnotationAttributes.add("message");
        internalAnnotationAttributes.add("groups");
        internalAnnotationAttributes.add("payload");
    }

    public static class Field {
        private final Form<?> form;
        private final String name;
        private final List<F.Tuple<String, List<Object>>> constraints;
        private final F.Tuple<String, List<Object>> format;
        private final List<ValidationError> errors;
        private final String value;
        private final Http.MultipartFormData.FilePart<?> file;

        public Field(Form<?> form, String string, List<F.Tuple<String, List<Object>>> list, F.Tuple<String, List<Object>> tuple, List<ValidationError> list2, String string2) {
            this(form, string, list, tuple, list2, string2, null);
        }

        public Field(Form<?> form, String string, List<F.Tuple<String, List<Object>>> list, F.Tuple<String, List<Object>> tuple, List<ValidationError> list2, Http.MultipartFormData.FilePart<?> filePart) {
            this(form, string, list, tuple, list2, null, filePart);
        }

        public Field(Form<?> form, String string, List<F.Tuple<String, List<Object>>> list, F.Tuple<String, List<Object>> tuple, List<ValidationError> list2, String string2, Http.MultipartFormData.FilePart<?> filePart) {
            this.form = form;
            this.name = string;
            this.constraints = list != null ? new ArrayList<F.Tuple<String, List<Object>>>(list) : new ArrayList();
            this.format = tuple;
            this.errors = list2 != null ? new ArrayList<ValidationError>(list2) : new ArrayList();
            this.value = string2;
            this.file = filePart;
        }

        public Optional<String> name() {
            return Optional.ofNullable(this.name);
        }

        public Optional<String> value() {
            return Optional.ofNullable(this.value);
        }

        public <A> Optional<Http.MultipartFormData.FilePart<A>> file() {
            return Optional.ofNullable(this.file);
        }

        public List<ValidationError> errors() {
            return Collections.unmodifiableList(this.errors);
        }

        public List<F.Tuple<String, List<Object>>> constraints() {
            return Collections.unmodifiableList(this.constraints);
        }

        public F.Tuple<String, List<Object>> format() {
            return this.format;
        }

        public List<Integer> indexes() {
            if (this.form == null) {
                return Collections.emptyList();
            }
            Function<String, Pattern> function = string -> Pattern.compile("^" + Pattern.quote(string) + "\\[(\\d+)\\].*$");
            return Collections.unmodifiableList(this.form.value().map(object -> {
                Object object2;
                String string = this.name;
                if (this.form.name() != null && this.name.startsWith(this.form.name() + ".")) {
                    string = this.name.substring(this.form.name().length() + 1);
                }
                if (object instanceof DynamicForm.Dynamic) {
                    TreeSet<Integer> treeSet = new TreeSet<Integer>();
                    DynamicForm.Dynamic dynamic = (DynamicForm.Dynamic)object;
                    Pattern pattern = (Pattern)function.apply(string);
                    for (String string2 : dynamic.getData().keySet()) {
                        Matcher matcher = pattern.matcher(string2);
                        if (!matcher.matches()) continue;
                        treeSet.add(Integer.parseInt(matcher.group(1)));
                    }
                    ArrayList arrayList = new ArrayList(treeSet);
                    Collections.sort(arrayList);
                    return arrayList;
                }
                ArrayList<Integer> arrayList = new ArrayList<Integer>();
                ConfigurablePropertyAccessor configurablePropertyAccessor = this.form.propertyAccessor(object);
                configurablePropertyAccessor.setAutoGrowNestedPaths(true);
                if (configurablePropertyAccessor.isReadableProperty(string) && (object2 = configurablePropertyAccessor.getPropertyValue(string)) instanceof Collection) {
                    for (int i = 0; i < ((Collection)object2).size(); ++i) {
                        arrayList.add(i);
                    }
                }
                return arrayList;
            }).orElseGet(() -> {
                TreeSet<Integer> treeSet = new TreeSet<Integer>();
                Pattern pattern = (Pattern)function.apply(this.name);
                LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>(this.form.rawData().keySet());
                linkedHashSet.addAll(this.form.files().keySet());
                for (String string : linkedHashSet) {
                    Matcher matcher = pattern.matcher(string);
                    if (!matcher.matches()) continue;
                    treeSet.add(Integer.parseInt(matcher.group(1)));
                }
                ArrayList arrayList = new ArrayList(treeSet);
                Collections.sort(arrayList);
                return arrayList;
            }));
        }

        public Field sub(String string) {
            return this.sub(string, this.form.lang);
        }

        public Field sub(String string, Lang lang) {
            String string2 = string.startsWith("[") ? this.name + string : this.name + "." + string;
            return this.form.field(string2, lang);
        }

        public String toString() {
            return "Form.Field(" + this.name + ")";
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.ANNOTATION_TYPE})
    public static @interface Display {
        public String name();

        public String[] attributes() default {};
    }
}

