/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.cache;

import io.ebean.annotation.CacheBeanTuning;
import io.ebean.annotation.CacheQueryTuning;

public class ServerCacheOptions {
    private int maxSize;
    private int maxIdleSecs;
    private int maxSecsToLive;
    private int trimFrequency;
    private boolean nearCache;

    public ServerCacheOptions() {
    }

    public ServerCacheOptions(CacheBeanTuning tuning) {
        this.maxSize = tuning.maxSize();
        this.maxIdleSecs = tuning.maxIdleSecs();
        this.maxSecsToLive = tuning.maxSecsToLive();
        this.trimFrequency = tuning.trimFrequency();
    }

    public ServerCacheOptions(CacheQueryTuning cacheTuning) {
        this.maxSize = cacheTuning.maxSize();
        this.maxIdleSecs = cacheTuning.maxIdleSecs();
        this.maxSecsToLive = cacheTuning.maxSecsToLive();
        this.trimFrequency = cacheTuning.trimFrequency();
    }

    public ServerCacheOptions(boolean nearCache, CacheBeanTuning tuning) {
        this(tuning);
        this.nearCache = nearCache;
    }

    public ServerCacheOptions applyDefaults(ServerCacheOptions defaults) {
        if (this.maxSize == 0) {
            this.maxSize = defaults.getMaxSize();
        }
        if (this.maxIdleSecs == 0) {
            this.maxIdleSecs = defaults.getMaxIdleSecs();
        }
        if (this.maxSecsToLive == 0) {
            this.maxSecsToLive = defaults.getMaxSecsToLive();
        }
        if (this.trimFrequency == 0) {
            this.trimFrequency = defaults.getTrimFrequency();
        }
        return this;
    }

    public ServerCacheOptions copy() {
        ServerCacheOptions copy = new ServerCacheOptions();
        copy.maxSize = this.maxSize;
        copy.maxIdleSecs = this.maxIdleSecs;
        copy.maxSecsToLive = this.maxSecsToLive;
        copy.trimFrequency = this.trimFrequency;
        copy.nearCache = this.nearCache;
        return copy;
    }

    public ServerCacheOptions copy(boolean nearCache) {
        ServerCacheOptions copy = this.copy();
        copy.nearCache = nearCache;
        return copy;
    }

    public boolean isNearCache() {
        return this.nearCache;
    }

    public void setNearCache(boolean nearCache) {
        this.nearCache = nearCache;
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public void setMaxSize(int maxSize) {
        this.maxSize = maxSize;
    }

    public int getMaxIdleSecs() {
        return this.maxIdleSecs;
    }

    public void setMaxIdleSecs(int maxIdleSecs) {
        this.maxIdleSecs = maxIdleSecs;
    }

    public int getMaxSecsToLive() {
        return this.maxSecsToLive;
    }

    public void setMaxSecsToLive(int maxSecsToLive) {
        this.maxSecsToLive = maxSecsToLive;
    }

    public int getTrimFrequency() {
        return this.trimFrequency;
    }

    public void setTrimFrequency(int trimFrequency) {
        this.trimFrequency = trimFrequency;
    }
}

