/*
 * Decompiled with CFR 0.152.
 */
package play.libs.ws.ahc;

import com.typesafe.sslconfig.ssl.SystemConfiguration;
import com.typesafe.sslconfig.util.LoggerFactory;
import java.io.IOException;
import java.net.URI;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.function.Function;
import javax.inject.Inject;
import org.apache.pekko.Done;
import org.apache.pekko.stream.Materializer;
import org.apache.pekko.stream.javadsl.Source;
import org.apache.pekko.util.ByteString;
import org.apache.pekko.util.ByteStringBuilder;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import play.api.libs.ws.ahc.AhcConfigBuilder;
import play.api.libs.ws.ahc.AhcLoggerFactory;
import play.api.libs.ws.ahc.AhcWSClientConfig;
import play.api.libs.ws.ahc.DefaultStreamedAsyncHandler;
import play.api.libs.ws.ahc.StreamedState;
import play.api.libs.ws.ahc.cache.AhcHttpCache;
import play.api.libs.ws.ahc.cache.CachingAsyncHttpClient;
import play.libs.ws.StandaloneWSClient;
import play.libs.ws.StandaloneWSResponse;
import play.libs.ws.ahc.StandaloneAhcWSRequest;
import play.libs.ws.ahc.StandaloneAhcWSResponse;
import play.libs.ws.ahc.StreamedResponse;
import play.shaded.ahc.org.asynchttpclient.AsyncCompletionHandler;
import play.shaded.ahc.org.asynchttpclient.AsyncHandler;
import play.shaded.ahc.org.asynchttpclient.AsyncHttpClient;
import play.shaded.ahc.org.asynchttpclient.AsyncHttpClientConfig;
import play.shaded.ahc.org.asynchttpclient.DefaultAsyncHttpClient;
import play.shaded.ahc.org.asynchttpclient.DefaultAsyncHttpClientConfig;
import play.shaded.ahc.org.asynchttpclient.HttpResponseBodyPart;
import play.shaded.ahc.org.asynchttpclient.Request;
import play.shaded.ahc.org.asynchttpclient.Response;
import scala.collection.Map;
import scala.collection.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.jdk.javaapi.FutureConverters;

public class StandaloneAhcWSClient
implements StandaloneWSClient {
    private final AsyncHttpClient asyncHttpClient;
    private final Materializer materializer;

    @Inject
    public StandaloneAhcWSClient(AsyncHttpClient asyncHttpClient, Materializer materializer) {
        this.asyncHttpClient = asyncHttpClient;
        this.materializer = materializer;
    }

    public Object getUnderlying() {
        return this.asyncHttpClient;
    }

    public StandaloneAhcWSRequest url(String string) {
        return new StandaloneAhcWSRequest(this, string, this.materializer);
    }

    public void close() throws IOException {
        this.asyncHttpClient.close();
    }

    CompletionStage<StandaloneWSResponse> execute(Request request) {
        Promise promise = Promise$.MODULE$.apply();
        ResponseAsyncCompletionHandler responseAsyncCompletionHandler = new ResponseAsyncCompletionHandler((Promise<StandaloneWSResponse>)promise);
        try {
            this.asyncHttpClient.executeRequest(request, (AsyncHandler)responseAsyncCompletionHandler);
        }
        catch (RuntimeException runtimeException) {
            promise.failure((Throwable)runtimeException);
        }
        Future future = promise.future();
        return FutureConverters.asJava((Future)future);
    }

    CompletionStage<StandaloneWSResponse> executeStream(Request request, ExecutionContext executionContext) {
        Promise promise = Promise$.MODULE$.apply();
        final Promise promise2 = Promise$.MODULE$.apply();
        Function<StreamedState, StandaloneWSResponse> function = streamedState -> {
            final Publisher<HttpResponseBodyPart> publisher = streamedState.publisher();
            Publisher<HttpResponseBodyPart> publisher2 = new Publisher<HttpResponseBodyPart>(){

                public void subscribe(final Subscriber<? super HttpResponseBodyPart> subscriber) {
                    publisher.subscribe((Subscriber)new Subscriber<HttpResponseBodyPart>(){

                        public void onSubscribe(Subscription subscription) {
                            subscriber.onSubscribe(subscription);
                        }

                        public void onNext(HttpResponseBodyPart httpResponseBodyPart) {
                            subscriber.onNext((Object)httpResponseBodyPart);
                        }

                        public void onError(Throwable throwable) {
                            subscriber.onError(throwable);
                        }

                        public void onComplete() {
                            FutureConverters.asJava((Future)promise2.future()).handle((done, throwable) -> {
                                if (done != null) {
                                    subscriber.onComplete();
                                } else {
                                    subscriber.onError(throwable);
                                }
                                return null;
                            });
                        }
                    });
                }
            };
            return new StreamedResponse(this, streamedState.statusCode(), streamedState.statusText(), (URI)streamedState.uriOption().get(), (Map<String, Seq<String>>)streamedState.responseHeaders(), publisher2, this.asyncHttpClient.getConfig().isUseLaxCookieEncoder());
        };
        this.asyncHttpClient.executeRequest(request, new DefaultStreamedAsyncHandler<StandaloneWSResponse>(function, promise, (Promise<Done>)promise2));
        return FutureConverters.asJava((Future)promise.future());
    }

    public static StandaloneAhcWSClient create(AhcWSClientConfig ahcWSClientConfig, Materializer materializer) {
        return StandaloneAhcWSClient.create(ahcWSClientConfig, null, materializer);
    }

    public static StandaloneAhcWSClient create(AhcWSClientConfig ahcWSClientConfig, AhcHttpCache ahcHttpCache, Materializer materializer) {
        AhcLoggerFactory ahcLoggerFactory = new AhcLoggerFactory(org.slf4j.LoggerFactory.getILoggerFactory());
        AhcConfigBuilder ahcConfigBuilder = new AhcConfigBuilder(ahcWSClientConfig);
        DefaultAsyncHttpClientConfig.Builder builder = ahcConfigBuilder.configure();
        new SystemConfiguration((LoggerFactory)ahcLoggerFactory).configure(ahcWSClientConfig.wsClientConfig().ssl());
        DefaultAsyncHttpClientConfig defaultAsyncHttpClientConfig = builder.build();
        DefaultAsyncHttpClient defaultAsyncHttpClient = new DefaultAsyncHttpClient((AsyncHttpClientConfig)defaultAsyncHttpClientConfig);
        Object object = ahcHttpCache != null ? new CachingAsyncHttpClient((AsyncHttpClient)defaultAsyncHttpClient, ahcHttpCache) : defaultAsyncHttpClient;
        return new StandaloneAhcWSClient((AsyncHttpClient)object, materializer);
    }

    ByteString blockingToByteString(Source<ByteString, ?> source) {
        try {
            return source.runFold((Object)ByteString.createBuilder(), ByteStringBuilder::append, this.materializer).thenApply(ByteStringBuilder::result).toCompletableFuture().get();
        }
        catch (InterruptedException | ExecutionException exception) {
            throw new RuntimeException(exception);
        }
    }

    private static class ResponseAsyncCompletionHandler
    extends AsyncCompletionHandler<Response> {
        private final Promise<StandaloneWSResponse> scalaPromise;

        public ResponseAsyncCompletionHandler(Promise<StandaloneWSResponse> promise) {
            this.scalaPromise = promise;
        }

        public Response onCompleted(Response response) {
            StandaloneAhcWSResponse standaloneAhcWSResponse = new StandaloneAhcWSResponse(response);
            this.scalaPromise.success((Object)standaloneAhcWSResponse);
            return response;
        }

        public void onThrowable(Throwable throwable) {
            this.scalaPromise.failure(throwable);
        }
    }
}

