/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.bouncycastle.asn1.cms;

import de.businesslogics.bouncycastle.asn1.ASN1Encodable;
import de.businesslogics.bouncycastle.asn1.ASN1EncodableVector;
import de.businesslogics.bouncycastle.asn1.ASN1Object;
import de.businesslogics.bouncycastle.asn1.ASN1ObjectIdentifier;
import de.businesslogics.bouncycastle.asn1.ASN1Primitive;
import de.businesslogics.bouncycastle.asn1.ASN1Sequence;
import de.businesslogics.bouncycastle.asn1.ASN1TaggedObject;
import de.businesslogics.bouncycastle.asn1.BERSequence;
import de.businesslogics.bouncycastle.asn1.BERTaggedObject;
import de.businesslogics.bouncycastle.asn1.DLSequence;
import de.businesslogics.bouncycastle.asn1.DLTaggedObject;
import de.businesslogics.bouncycastle.asn1.cms.CMSObjectIdentifiers;

public class ContentInfo
extends ASN1Object
implements CMSObjectIdentifiers {
    private final ASN1ObjectIdentifier contentType;
    private final ASN1Encodable content;
    private final boolean isDefiniteLength;

    public static ContentInfo getInstance(Object object) {
        if (object instanceof ContentInfo) {
            return (ContentInfo)object;
        }
        if (object != null) {
            return new ContentInfo(ASN1Sequence.getInstance((Object)object));
        }
        return null;
    }

    private ContentInfo(ASN1Sequence aSN1Sequence) {
        if (aSN1Sequence.size() < 1 || aSN1Sequence.size() > 2) {
            throw new IllegalArgumentException("Bad sequence size: " + aSN1Sequence.size());
        }
        this.contentType = (ASN1ObjectIdentifier)aSN1Sequence.getObjectAt(0);
        if (aSN1Sequence.size() > 1) {
            ASN1TaggedObject aSN1TaggedObject = ASN1TaggedObject.getInstance((Object)aSN1Sequence.getObjectAt(1), (int)128);
            if (!aSN1TaggedObject.isExplicit() || aSN1TaggedObject.getTagNo() != 0) {
                throw new IllegalArgumentException("Bad tag for 'content'");
            }
            this.content = aSN1TaggedObject.getExplicitBaseObject();
        } else {
            this.content = null;
        }
        this.isDefiniteLength = !(aSN1Sequence instanceof BERSequence);
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector(2);
        aSN1EncodableVector.add((ASN1Encodable)this.contentType);
        if (this.content != null) {
            if (this.isDefiniteLength) {
                aSN1EncodableVector.add((ASN1Encodable)new DLTaggedObject(0, this.content));
            } else {
                aSN1EncodableVector.add((ASN1Encodable)new BERTaggedObject(0, this.content));
            }
        }
        return this.isDefiniteLength ? new DLSequence(aSN1EncodableVector) : new BERSequence(aSN1EncodableVector);
    }
}

