/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.zkasecurity;

import de.businesslogics.util.HexTool;
import de.businesslogics.zkasecurity.E001PublicKey;
import de.businesslogics.zkasecurity.RSAPublicKey;
import java.security.DigestException;
import java.security.MessageDigest;

public class X001PublicKey
implements RSAPublicKey {
    static final byte[] SIGPREFIX = new byte[]{48, 33, 48, 9, 6, 5, 43, 14, 3, 2, 26, 5, 0, 4, 20};
    protected java.security.interfaces.RSAPublicKey publicKey;
    protected final String userId;

    public X001PublicKey(String userId, java.security.interfaces.RSAPublicKey publicKey) {
        this.userId = userId;
        this.publicKey = publicKey;
    }

    @Override
    public byte[] getHash() {
        return X001PublicKey.getHash(this.publicKey);
    }

    @Override
    public String getBcsId() {
        return this.userId;
    }

    @Override
    public byte[] getModulus() {
        return HexTool.stripZeros(this.publicKey.getModulus().toByteArray());
    }

    @Override
    public byte[] getPublicExponent() {
        return HexTool.stripZeros(this.publicKey.getPublicExponent().toByteArray());
    }

    @Override
    public java.security.interfaces.RSAPublicKey getPublicKey() {
        return this.publicKey;
    }

    public static byte[] getHash(java.security.interfaces.RSAPublicKey pub) {
        return E001PublicKey.getHash(pub);
    }

    public static byte[] digest(MessageDigest digest) {
        try {
            byte[] toReturn = new byte[SIGPREFIX.length + digest.getDigestLength()];
            System.arraycopy(SIGPREFIX, 0, toReturn, 0, SIGPREFIX.length);
            digest.digest(toReturn, SIGPREFIX.length, toReturn.length - SIGPREFIX.length);
            return toReturn;
        }
        catch (DigestException de) {
            throw new RuntimeException(de);
        }
    }
}

