/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.zkasecurity;

import de.businesslogics.crypto.BCRSAPkcs1PaddingCipher;
import de.businesslogics.zkasecurity.DirectSecurity;
import de.businesslogics.zkasecurity.KeyStore;
import de.businesslogics.zkasecurity.PasswordCallback;
import de.businesslogics.zkasecurity.RSAPrivateKey;
import de.businesslogics.zkasecurity.X001PublicKey;
import java.io.IOException;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.SecureRandom;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.RSAKeyGenParameterSpec;

public class X001PrivateKey
extends X001PublicKey
implements RSAPrivateKey {
    private static final char[] EMPTY_PWD = "".toCharArray();
    public static RSAKeyGenParameterSpec KEYGEN_PARAMETER = new RSAKeyGenParameterSpec(2048, new BigInteger("010001", 16));
    public static final String DIGEST_ALGORITHM = "http://www.w3.org/2000/09/xmldsig#sha1";
    private java.security.interfaces.RSAPrivateKey privKey = null;

    public X001PrivateKey(String userid, SecureRandom random) throws GeneralSecurityException {
        this(userid, random, KEYGEN_PARAMETER);
    }

    public X001PrivateKey(String userid, SecureRandom random, int bitLength) throws GeneralSecurityException {
        super(userid, null);
        if (bitLength < 1024 || bitLength > 16384) {
            throw new IllegalArgumentException("Wrong bit length " + bitLength);
        }
        KeyPairGenerator gen = DirectSecurity.getRSAKeyPairGenerator();
        if (random != null) {
            gen.initialize(new RSAKeyGenParameterSpec(bitLength, new BigInteger("010001", 16)), random);
        } else {
            gen.initialize(new RSAKeyGenParameterSpec(bitLength, new BigInteger("010001", 16)));
        }
        KeyPair pair = gen.generateKeyPair();
        this.publicKey = (RSAPublicKey)pair.getPublic();
        this.privKey = (java.security.interfaces.RSAPrivateKey)pair.getPrivate();
    }

    public X001PrivateKey(String userid, SecureRandom random, RSAKeyGenParameterSpec spec) throws GeneralSecurityException {
        super(userid, null);
        KeyPairGenerator gen = DirectSecurity.getRSAKeyPairGenerator();
        if (random != null) {
            gen.initialize(spec, random);
        } else {
            gen.initialize(spec);
        }
        KeyPair pair = gen.generateKeyPair();
        this.publicKey = (RSAPublicKey)pair.getPublic();
        this.privKey = (java.security.interfaces.RSAPrivateKey)pair.getPrivate();
    }

    private X001PrivateKey(String userId, KeyPair pair) {
        super(userId, (RSAPublicKey)pair.getPublic());
        this.privKey = (java.security.interfaces.RSAPrivateKey)pair.getPrivate();
    }

    public X001PrivateKey(String bcsid, java.security.interfaces.RSAPrivateKey privKey, RSAPublicKey pubKey) {
        super(bcsid, pubKey);
        this.privKey = privKey;
    }

    public static X001PrivateKey fromPKCS(byte[] data, String userid, PasswordCallback passwordCallback) throws IOException, GeneralSecurityException {
        char[] pwd = EMPTY_PWD;
        if (passwordCallback != null) {
            pwd = passwordCallback.getPassword();
        }
        return new X001PrivateKey(userid, KeyStore.decryptStore(data, pwd));
    }

    @Override
    public byte[] toPKCS(PasswordCallback passwordCallback) {
        char[] pwd = EMPTY_PWD;
        if (passwordCallback != null) {
            pwd = passwordCallback.getPassword();
        }
        return KeyStore.encryptStore(this.getPrivateKey(), pwd);
    }

    @Override
    public java.security.interfaces.RSAPrivateKey getPrivateKey() {
        return this.privKey;
    }

    public byte[] authenticate(byte[] oidSha1) {
        return X001PrivateKey.authenticate(this.privKey, oidSha1);
    }

    public static byte[] authenticate(java.security.interfaces.RSAPrivateKey privKey, byte[] oidSha1) {
        try {
            BCRSAPkcs1PaddingCipher rsa = new BCRSAPkcs1PaddingCipher();
            rsa.init(1, privKey);
            return rsa.doFinal(oidSha1);
        }
        catch (GeneralSecurityException gse) {
            throw new RuntimeException("Weird security setup", gse);
        }
    }
}

