/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.zkasecurity;

import de.businesslogics.bouncycastle.asn1.ASN1Encodable;
import de.businesslogics.bouncycastle.asn1.ASN1EncodableVector;
import de.businesslogics.bouncycastle.asn1.ASN1InputStream;
import de.businesslogics.bouncycastle.asn1.ASN1Integer;
import de.businesslogics.bouncycastle.asn1.ASN1OctetString;
import de.businesslogics.bouncycastle.asn1.ASN1OutputStream;
import de.businesslogics.bouncycastle.asn1.DEROctetString;
import de.businesslogics.bouncycastle.asn1.DERSequence;
import de.businesslogics.bouncycastle.asn1.pkcs.EncryptedPrivateKeyInfo;
import de.businesslogics.bouncycastle.asn1.pkcs.EncryptionScheme;
import de.businesslogics.bouncycastle.asn1.pkcs.PBES2Parameters;
import de.businesslogics.bouncycastle.asn1.pkcs.PBKDF2Params;
import de.businesslogics.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import de.businesslogics.bouncycastle.asn1.x509.AlgorithmIdentifier;
import de.businesslogics.bouncycastle.crypto.BlockCipher;
import de.businesslogics.bouncycastle.crypto.CipherParameters;
import de.businesslogics.bouncycastle.crypto.InvalidCipherTextException;
import de.businesslogics.bouncycastle.crypto.PBEParametersGenerator;
import de.businesslogics.bouncycastle.crypto.engines.DESedeEngine;
import de.businesslogics.bouncycastle.crypto.generators.PKCS5S2ParametersGenerator;
import de.businesslogics.bouncycastle.crypto.modes.CBCBlockCipher;
import de.businesslogics.bouncycastle.crypto.paddings.PaddedBufferedBlockCipher;
import de.businesslogics.bouncycastle.crypto.params.ParametersWithIV;
import de.businesslogics.zkasecurity.DirectSecurity;
import de.businesslogics.zkasecurity.InvalidPasswordException;
import de.businesslogics.zkasecurity.KeyFactory;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.util.Arrays;

public class KeyStore {
    public static KeyPair decryptStore(byte[] store, char[] password) throws InvalidPasswordException {
        byte[] out = KeyStore.decryptData(store, password);
        try {
            PKCS8EncodedKeySpec key = new PKCS8EncodedKeySpec(out);
            KeyFactory factory = DirectSecurity.getRSAKeyFactory();
            RSAPrivateCrtKey privKey = (RSAPrivateCrtKey)factory.generatePrivate(key);
            PublicKey pubKey = factory.generatePublic(new RSAPublicKeySpec(privKey.getModulus(), privKey.getPublicExponent()));
            return new KeyPair(pubKey, privKey);
        }
        catch (RuntimeException runtime) {
            throw new InvalidPasswordException(runtime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] decryptData(byte[] data, char[] password) throws InvalidPasswordException {
        try {
            EncryptedPrivateKeyInfo info;
            PKCS5S2ParametersGenerator generator = new PKCS5S2ParametersGenerator();
            try (ASN1InputStream dIn = new ASN1InputStream(data);){
                info = EncryptedPrivateKeyInfo.getInstance((Object)dIn.readObject());
            }
            PBES2Parameters alg = PBES2Parameters.getInstance((Object)info.getEncryptionAlgorithm().getParameters());
            PBKDF2Params func = (PBKDF2Params)alg.getKeyDerivationFunc().getParameters();
            EncryptionScheme scheme = alg.getEncryptionScheme();
            int keySize = 192;
            int iterationCount = func.getIterationCount().intValue();
            byte[] salt = func.getSalt();
            generator.init(PBEParametersGenerator.PKCS5PasswordToBytes((char[])password), salt, iterationCount);
            byte[] iv = ((ASN1OctetString)scheme.getParameters()).getOctets();
            ParametersWithIV param = new ParametersWithIV(generator.generateDerivedParameters(keySize), iv);
            PaddedBufferedBlockCipher cipher = new PaddedBufferedBlockCipher((BlockCipher)new CBCBlockCipher((BlockCipher)new DESedeEngine()));
            cipher.init(false, (CipherParameters)param);
            byte[] tmp = info.getEncryptedData();
            byte[] out = new byte[cipher.getOutputSize(tmp.length)];
            int len = cipher.processBytes(tmp, 0, tmp.length, out, 0);
            len += cipher.doFinal(out, len);
            if (len < out.length) {
                byte[] toReturn = new byte[len];
                System.arraycopy(out, 0, toReturn, 0, len);
                return toReturn;
            }
            return out;
        }
        catch (Exception invalid) {
            throw new InvalidPasswordException(invalid.getMessage());
        }
    }

    public static byte[] encryptData(byte[] data, char[] password) throws IOException, InvalidPasswordException {
        try {
            SecureRandom rnd = new SecureRandom();
            byte[] salt = new byte[8];
            byte[] iv = new byte[8];
            rnd.nextBytes(salt);
            rnd.nextBytes(iv);
            PKCS5S2ParametersGenerator generator = new PKCS5S2ParametersGenerator();
            generator.init(PBEParametersGenerator.PKCS5PasswordToBytes((char[])password), salt, 2048);
            ParametersWithIV paramIv = new ParametersWithIV(generator.generateDerivedParameters(192), iv);
            PaddedBufferedBlockCipher cipher = new PaddedBufferedBlockCipher((BlockCipher)new CBCBlockCipher((BlockCipher)new DESedeEngine()));
            cipher.init(true, (CipherParameters)paramIv);
            byte[] enc = new byte[cipher.getOutputSize(data.length)];
            int len = cipher.processBytes(data, 0, data.length, enc, 0);
            cipher.doFinal(enc, len);
            EncryptedPrivateKeyInfo keyInfo = new EncryptedPrivateKeyInfo((AlgorithmIdentifier)new PKCS8AlgorithmParameters(salt, 2048, iv), enc);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            ASN1OutputStream derOut = ASN1OutputStream.create((OutputStream)out, (String)"DER");
            derOut.writeObject((ASN1Encodable)keyInfo.toASN1Primitive());
            derOut.close();
            return out.toByteArray();
        }
        catch (InvalidCipherTextException invalid) {
            throw new InvalidPasswordException(invalid.getMessage());
        }
        catch (RuntimeException runtime) {
            throw new InvalidPasswordException(runtime);
        }
    }

    public static byte[] encryptStore(PrivateKey privKey, char[] password) {
        try {
            KeyFactory factory = DirectSecurity.getRSAKeyFactory();
            PKCS8EncodedKeySpec pkcs8 = factory.getKeySpec(privKey, PKCS8EncodedKeySpec.class);
            byte[] encoded = pkcs8.getEncoded();
            return KeyStore.encryptData(encoded, password);
        }
        catch (Exception e) {
            throw new RuntimeException("Weird security setup", e);
        }
    }

    public static void main(String[] args) throws IOException, InvalidPasswordException {
        char[] myPassword = "geheim".toCharArray();
        byte[] myData = "my data".getBytes();
        byte[] encrypted = KeyStore.encryptData(myData, myPassword);
        byte[] decrypted = KeyStore.decryptData(encrypted, myPassword);
        System.out.println("Equal: " + Arrays.equals(myData, decrypted));
    }

    private static class PKCS8AlgorithmParameters
    extends AlgorithmIdentifier {
        public PKCS8AlgorithmParameters(byte[] salt, int iteration, byte[] iv) {
            super(PKCSObjectIdentifiers.id_PBES2, (ASN1Encodable)PKCS8AlgorithmParameters.getDERObject(salt, iteration, iv));
        }

        public static DERSequence getDERObject(byte[] salt, int iteration, byte[] iv) {
            ASN1EncodableVector v1 = new ASN1EncodableVector();
            ASN1EncodableVector sub1 = new ASN1EncodableVector();
            ASN1EncodableVector sub2 = new ASN1EncodableVector();
            ASN1EncodableVector sub3 = new ASN1EncodableVector();
            sub1.add((ASN1Encodable)PKCSObjectIdentifiers.id_PBKDF2);
            sub2.add((ASN1Encodable)new DEROctetString(salt));
            sub2.add((ASN1Encodable)new ASN1Integer((long)iteration));
            sub1.add((ASN1Encodable)new DERSequence(sub2));
            v1.add((ASN1Encodable)new DERSequence(sub1));
            sub3.add((ASN1Encodable)PKCSObjectIdentifiers.des_EDE3_CBC);
            sub3.add((ASN1Encodable)new DEROctetString(iv));
            v1.add((ASN1Encodable)new DERSequence(sub3));
            return new DERSequence(v1);
        }
    }
}

