/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.zkasecurity;

import de.businesslogics.crypto.BCBlockCipher;
import de.businesslogics.crypto.BCRSAPkcs1PaddingCipher;
import de.businesslogics.crypto.CipherOutputStream;
import de.businesslogics.util.HexTool;
import de.businesslogics.zkasecurity.RSAPublicKey;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.SecureRandom;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;

public class E002PublicKey
implements RSAPublicKey {
    static final byte[] SPACE = new byte[]{32};
    static final byte[] IV = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    protected java.security.interfaces.RSAPublicKey publicKey;
    protected final String bcsid;

    public E002PublicKey(String bcsid, java.security.interfaces.RSAPublicKey publicKey) {
        this.bcsid = bcsid;
        this.publicKey = publicKey;
    }

    @Override
    public String getBcsId() {
        return this.bcsid;
    }

    @Override
    public byte[] getHash() {
        return E002PublicKey.getHash(this.publicKey);
    }

    @Override
    public byte[] getModulus() {
        return HexTool.stripZeros(this.publicKey.getModulus().toByteArray());
    }

    @Override
    public byte[] getPublicExponent() {
        return HexTool.stripZeros(this.publicKey.getPublicExponent().toByteArray());
    }

    @Override
    public java.security.interfaces.RSAPublicKey getPublicKey() {
        return this.publicKey;
    }

    public static byte[] getHash(java.security.interfaces.RSAPublicKey pub) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            digest.update(pub.getPublicExponent().toString(16).getBytes("US-ASCII"));
            digest.update(SPACE);
            digest.update(pub.getModulus().toString(16).getBytes("US-ASCII"));
            return digest.digest();
        }
        catch (Exception gse) {
            throw new RuntimeException(gse);
        }
    }

    public static SecretKey createSecretKey() {
        try {
            KeyGenerator generator = KeyGenerator.getInstance("AES");
            generator.init(128);
            return generator.generateKey();
        }
        catch (GeneralSecurityException gse) {
            throw new RuntimeException(gse);
        }
    }

    public byte[] encrypt(SecretKey secret) {
        return E002PublicKey.encrypt(this.publicKey, secret.getEncoded());
    }

    public static byte[] encrypt(java.security.interfaces.RSAPublicKey pub, byte[] secret) {
        try {
            BCRSAPkcs1PaddingCipher cipher = new BCRSAPkcs1PaddingCipher();
            cipher.init(1, pub);
            return cipher.doFinal(secret);
        }
        catch (GeneralSecurityException gse) {
            throw new RuntimeException(gse);
        }
    }

    public static OutputStream encryptData(SecretKey secret, OutputStream is) {
        try {
            BCBlockCipher bc = BCBlockCipher.createAESCBCX923Padding();
            bc.init(1, secret, new IvParameterSpec(IV), new SecureRandom());
            return new CipherOutputStream(bc, is);
        }
        catch (GeneralSecurityException gse) {
            throw new RuntimeException(gse);
        }
    }
}

