/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.zkasecurity;

import de.businesslogics.crypto.BCBlockCipher;
import de.businesslogics.crypto.BCRSAPkcs1PaddingCipher;
import de.businesslogics.crypto.CipherInputStream;
import de.businesslogics.crypto.CipherOutputStream;
import de.businesslogics.zkasecurity.DirectSecurity;
import de.businesslogics.zkasecurity.E001PublicKey;
import de.businesslogics.zkasecurity.KeyStore;
import de.businesslogics.zkasecurity.PasswordCallback;
import de.businesslogics.zkasecurity.RSAPrivateKey;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.SecureRandom;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.RSAKeyGenParameterSpec;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class E001PrivateKey
extends E001PublicKey
implements RSAPrivateKey {
    public static RSAKeyGenParameterSpec KEYGEN_PARAMETER = new RSAKeyGenParameterSpec(2048, new BigInteger("010001", 16));
    public static final String DIGEST_ALGORITHM = "http://www.w3.org/2000/09/xmldsig#sha1";
    private java.security.interfaces.RSAPrivateKey privKey = null;
    private static final char[] EMPTY_PWD = new char[0];

    public E001PrivateKey(String bcsid, SecureRandom random) throws GeneralSecurityException {
        this(bcsid, random, KEYGEN_PARAMETER);
    }

    public E001PrivateKey(String bcsid, SecureRandom random, int bitLength) throws GeneralSecurityException {
        super(bcsid, null);
        if (bitLength < 1024 || bitLength > 16384) {
            throw new IllegalArgumentException("Wrong bit length " + bitLength);
        }
        KeyPairGenerator gen = DirectSecurity.getRSAKeyPairGenerator();
        if (random != null) {
            gen.initialize(new RSAKeyGenParameterSpec(bitLength, new BigInteger("010001", 16)), random);
        } else {
            gen.initialize(new RSAKeyGenParameterSpec(bitLength, new BigInteger("010001", 16)));
        }
        KeyPair pair = gen.generateKeyPair();
        this.publicKey = (RSAPublicKey)pair.getPublic();
        this.privKey = (java.security.interfaces.RSAPrivateKey)pair.getPrivate();
    }

    public E001PrivateKey(String bcsid, SecureRandom random, RSAKeyGenParameterSpec spec) throws GeneralSecurityException {
        super(bcsid, null);
        KeyPairGenerator gen = DirectSecurity.getRSAKeyPairGenerator();
        if (random != null) {
            gen.initialize(spec, random);
        } else {
            gen.initialize(spec);
        }
        KeyPair pair = gen.generateKeyPair();
        this.publicKey = (RSAPublicKey)pair.getPublic();
        this.privKey = (java.security.interfaces.RSAPrivateKey)pair.getPrivate();
    }

    private E001PrivateKey(String bcsid, KeyPair pair) {
        super(bcsid, (RSAPublicKey)pair.getPublic());
        this.privKey = (java.security.interfaces.RSAPrivateKey)pair.getPrivate();
    }

    public E001PrivateKey(String bcsid, java.security.interfaces.RSAPrivateKey privKey, RSAPublicKey pubKey) {
        super(bcsid, pubKey);
        this.privKey = privKey;
    }

    public static E001PrivateKey fromPKCS(byte[] data, String bcsid, PasswordCallback passwordCallback) throws IOException, GeneralSecurityException {
        return new E001PrivateKey(bcsid, KeyStore.decryptStore(data, passwordCallback != null ? passwordCallback.getPassword() : EMPTY_PWD));
    }

    @Override
    public byte[] toPKCS(PasswordCallback callback) {
        return KeyStore.encryptStore(this.getPrivateKey(), callback != null ? callback.getPassword() : EMPTY_PWD);
    }

    @Override
    public java.security.interfaces.RSAPrivateKey getPrivateKey() {
        return this.privKey;
    }

    public byte[] decrypt(byte[] secret) throws IllegalBlockSizeException, BadPaddingException {
        return E001PrivateKey.decrypt(this.privKey, secret);
    }

    public static byte[] decrypt(java.security.interfaces.RSAPrivateKey priv, byte[] secret) throws IllegalBlockSizeException, BadPaddingException {
        BCRSAPkcs1PaddingCipher cipher;
        try {
            cipher = new BCRSAPkcs1PaddingCipher();
            cipher.init(2, priv);
        }
        catch (GeneralSecurityException gse) {
            throw new RuntimeException(gse);
        }
        return cipher.doFinal(secret);
    }

    public static InputStream decryptData(byte[] secret, InputStream is) {
        try {
            SecretKeySpec key = new SecretKeySpec(secret, "DESede");
            BCBlockCipher bc = BCBlockCipher.createDESedeCBCX923Padding();
            bc.init(2, key, new IvParameterSpec(IV));
            return new CipherInputStream(bc, is);
        }
        catch (GeneralSecurityException gse) {
            throw new RuntimeException(gse);
        }
    }

    public static InputStream decryptData(SecretKey key, InputStream is) {
        try {
            BCBlockCipher bc = BCBlockCipher.createDESedeCBCX923Padding();
            bc.init(2, key, new IvParameterSpec(IV));
            return new CipherInputStream(bc, is);
        }
        catch (GeneralSecurityException gse) {
            throw new RuntimeException(gse);
        }
    }

    public static OutputStream decryptData(SecretKey key, OutputStream dest) {
        try {
            BCBlockCipher bc = BCBlockCipher.createDESedeCBCX923Padding();
            bc.init(2, key, new IvParameterSpec(IV));
            return new CipherOutputStream(bc, dest);
        }
        catch (GeneralSecurityException gse) {
            throw new RuntimeException(gse);
        }
    }
}

