/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.zkasecurity;

import de.businesslogics.bouncycastle.jcajce.provider.asymmetric.rsa.KeyFactorySpi;
import de.businesslogics.bouncycastle.jcajce.provider.asymmetric.rsa.KeyPairGeneratorSpi;
import de.businesslogics.zkasecurity.KeyFactory;
import java.security.Key;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;

public class DirectSecurity {
    public static KeyPairGenerator getRSAKeyPairGenerator() {
        return new KeyPairGeneratorSpi();
    }

    public static KeyFactory getRSAKeyFactory() {
        return new RSAKeyFactoryWrapper();
    }

    private static class RSAKeyFactoryWrapper
    extends KeyFactorySpi
    implements KeyFactory {
        private RSAKeyFactoryWrapper() {
        }

        @Override
        public <T extends KeySpec> T getKeySpec(Key key, Class<T> keySpec) {
            try {
                return (T)super.engineGetKeySpec(key, keySpec);
            }
            catch (InvalidKeySpecException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public PrivateKey generatePrivate(KeySpec keySpec) {
            try {
                return super.engineGeneratePrivate(keySpec);
            }
            catch (InvalidKeySpecException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public PublicKey generatePublic(KeySpec keySpec) {
            try {
                return super.engineGeneratePublic(keySpec);
            }
            catch (InvalidKeySpecException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

