/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.zkasecurity;

import de.businesslogics.crypto.BCRSANopaddingCipher;
import de.businesslogics.security.jce.Provider;
import de.businesslogics.util.HexTool;
import de.businesslogics.zkasecurity.RSAPublicKey;
import java.security.DigestException;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.security.SignatureException;
import java.util.Arrays;

public class A006PublicKey
implements RSAPublicKey {
    private static final byte[] SPACE = new byte[]{32};
    static final byte[] EIGHTZEROS = new byte[]{0, 0, 0, 0, 0, 0, 0, 0};
    protected java.security.interfaces.RSAPublicKey publicKey = null;

    public A006PublicKey(java.security.interfaces.RSAPublicKey publicKey) {
        this.publicKey = publicKey;
    }

    @Override
    public byte[] getHash() {
        return A006PublicKey.getHash(this.publicKey);
    }

    @Override
    public String getBcsId() {
        return null;
    }

    @Override
    public byte[] getModulus() {
        return HexTool.stripZeros(this.publicKey.getModulus().toByteArray());
    }

    @Override
    public byte[] getPublicExponent() {
        return HexTool.stripZeros(this.publicKey.getPublicExponent().toByteArray());
    }

    public static byte[] getHash(java.security.interfaces.RSAPublicKey key) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            digest.update(key.getPublicExponent().toString(16).getBytes("US-ASCII"));
            digest.update(SPACE);
            digest.update(key.getModulus().toString(16).getBytes("US-ASCII"));
            return digest.digest();
        }
        catch (Exception gse) {
            throw new RuntimeException(gse);
        }
    }

    @Override
    public java.security.interfaces.RSAPublicKey getPublicKey() {
        return this.publicKey;
    }

    public byte[] verify(byte[] signature, byte[] digest) throws GeneralSecurityException {
        BCRSANopaddingCipher rsa = new BCRSANopaddingCipher();
        rsa.init(2, this.publicKey);
        int modBits = this.publicKey.getModulus().bitLength();
        signature = Provider.scale(signature, (modBits + 7) / 8);
        byte[] decrypted = rsa.doFinal(signature);
        int emLen = (modBits + 6) / 8;
        decrypted = Provider.scale(decrypted, emLen);
        return A006PublicKey.emsa_pss_verify(digest, decrypted, modBits - 1);
    }

    private static final byte[] emsa_pss_verify(byte[] M, byte[] EM, int emBits) throws SignatureException {
        byte[] dbMask;
        byte[] toReturn;
        int hLen;
        MessageDigest digest;
        try {
            digest = MessageDigest.getInstance("SHA-256");
            hLen = digest.getDigestLength();
            toReturn = new byte[2 * hLen];
            digest.update(M);
            digest.digest(toReturn, 0, hLen);
        }
        catch (GeneralSecurityException gse) {
            throw new RuntimeException(gse);
        }
        if (EM.length < 66) {
            throw new SignatureException("step 3: Message to short (" + EM.length + " bytes)");
        }
        if (EM[EM.length - 1] != -68) {
            throw new SignatureException("step 4: Last byte not 0xbc");
        }
        byte[] H = new byte[hLen];
        int i = EM.length - hLen - 1;
        byte[] maskedDB = new byte[i];
        System.arraycopy(EM, 0, maskedDB, 0, i);
        System.arraycopy(EM, i, H, 0, hLen);
        int bit = 128;
        int i2 = 0;
        for (int pos = EM.length * 8; pos > emBits; --pos) {
            if ((EM[i2] & bit) == 0) continue;
            throw new SignatureException("step 6: Non-zero bit :" + pos);
        }
        byte[] DB2 = dbMask = A006PublicKey.mgf1(H, EM.length - hLen - 1, digest);
        i2 = dbMask.length;
        while (--i2 >= 0) {
            DB2[i2] = (byte)(dbMask[i2] ^ maskedDB[i2]);
        }
        int bit2 = 128;
        int i3 = 0;
        for (int pos = EM.length * 8; pos > emBits; --pos) {
            int n = i3++;
            DB2[n] = (byte)(DB2[n] & (byte)(0xFF ^ bit2));
            if ((bit2 >>= 1) != 0) continue;
            bit2 = 128;
        }
        i2 = EM.length - 2 * hLen - 2;
        while (--i2 >= 0) {
            if (DB2[i2] == 0) continue;
            throw new SignatureException("step 10: Non-zero byte at postion " + i2);
        }
        if (DB2[EM.length - 2 * hLen - 2] != 1) {
            throw new SignatureException("step 10: No 1 at postion " + (EM.length - 2 * hLen - 2));
        }
        System.arraycopy(DB2, DB2.length - hLen, toReturn, hLen, hLen);
        digest.update(EIGHTZEROS);
        digest.update(toReturn);
        byte[] H1 = digest.digest();
        if (!Arrays.equals(H1, H)) {
            throw new SignatureException("step 14: differing digests expected " + HexTool.toHex(H) + " found " + HexTool.toHex(H1));
        }
        return toReturn;
    }

    public byte[] getDSI(byte[] digest, byte[] salt) {
        return A006PublicKey.getDSI(digest, salt, this.publicKey.getModulus().bitLength());
    }

    public static byte[] getDSI(byte[] digest, byte[] salt, int modBits) {
        if (salt == null) {
            salt = new byte[32];
            new SecureRandom().nextBytes(salt);
        }
        return A006PublicKey.emsa_pss_encode(digest, modBits - 1, salt);
    }

    private static byte[] emsa_pss_encode(byte[] M, int emBits, byte[] salt) {
        int hLen;
        MessageDigest digest;
        try {
            digest = MessageDigest.getInstance("SHA-256");
            hLen = digest.getDigestLength();
        }
        catch (GeneralSecurityException gse) {
            throw new RuntimeException(gse);
        }
        byte[] mHash = digest.digest(M);
        int emLen = (emBits + 7) / 8;
        byte[] EM = new byte[emLen];
        if (emLen < hLen + salt.length + 2) {
            throw new IllegalArgumentException("Encoding error");
        }
        digest.update(EIGHTZEROS);
        digest.update(mHash);
        digest.update(salt);
        byte[] H = digest.digest();
        byte[] DB2 = new byte[emLen - hLen - 1];
        DB2[DB2.length - salt.length - 1] = 1;
        System.arraycopy(salt, 0, DB2, DB2.length - salt.length, salt.length);
        byte[] dbMask = A006PublicKey.mgf1(H, emLen - hLen - 1, digest);
        int i = dbMask.length;
        while (--i >= 0) {
            EM[i] = (byte)(dbMask[i] ^ DB2[i]);
        }
        int bit = 128;
        int i2 = 0;
        for (int pos = emLen * 8; pos > emBits; --pos) {
            int n = i2++;
            EM[n] = (byte)(EM[n] & (byte)(0xFF ^ bit));
            if ((bit >>= 1) != 0) continue;
            bit = 128;
        }
        System.arraycopy(H, 0, EM, dbMask.length, hLen);
        EM[emLen - 1] = -68;
        return EM;
    }

    static final byte[] mgf1(byte[] mfgSeed, int maskLen, MessageDigest digest) {
        byte[] toReturn = new byte[maskLen];
        int hLen = digest.getDigestLength();
        int p = 0;
        byte[] c = new byte[4];
        while (p < maskLen) {
            digest.update(mfgSeed);
            digest.update(c);
            int toCopy = maskLen - p;
            if (toCopy >= hLen) {
                try {
                    digest.digest(toReturn, p, hLen);
                }
                catch (DigestException de) {
                    throw new RuntimeException(de);
                }
                p += hLen;
                toCopy = 4;
                do {
                    int n = --toCopy;
                    c[n] = (byte)(c[n] + 1);
                } while (c[toCopy] == 0);
                continue;
            }
            byte[] d = digest.digest();
            System.arraycopy(d, 0, toReturn, p, toCopy);
            p = maskLen;
        }
        return toReturn;
    }
}

