/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.zkasecurity;

import de.businesslogics.crypto.BCRSAPkcs1PaddingCipher;
import de.businesslogics.security.jce.Provider;
import de.businesslogics.util.HexTool;
import de.businesslogics.zkasecurity.RSAPublicKey;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.SignatureException;
import java.util.Arrays;

public class A005PublicKey
implements RSAPublicKey {
    public static final byte[] SIGPREFIX = new byte[]{48, 49, 48, 13, 6, 9, 96, -122, 72, 1, 101, 3, 4, 2, 1, 5, 0, 4, 32};
    private static final byte[] SPACE = new byte[]{32};
    protected java.security.interfaces.RSAPublicKey publicKey = null;

    public A005PublicKey(java.security.interfaces.RSAPublicKey publicKey) {
        this.publicKey = publicKey;
    }

    @Override
    public byte[] getHash() {
        return A005PublicKey.getHash(this.getPublicKey());
    }

    public static byte[] getHash(java.security.interfaces.RSAPublicKey key) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            digest.update(key.getPublicExponent().toString(16).getBytes("US-ASCII"));
            digest.update(SPACE);
            digest.update(key.getModulus().toString(16).getBytes("US-ASCII"));
            return digest.digest();
        }
        catch (Exception gse) {
            throw new RuntimeException(gse);
        }
    }

    @Override
    public String getBcsId() {
        return null;
    }

    @Override
    public byte[] getModulus() {
        return HexTool.stripZeros(this.getPublicKey().getModulus().toByteArray());
    }

    @Override
    public byte[] getPublicExponent() {
        return HexTool.stripZeros(this.getPublicKey().getPublicExponent().toByteArray());
    }

    @Override
    public java.security.interfaces.RSAPublicKey getPublicKey() {
        return this.publicKey;
    }

    public byte[] getDsi(byte[] digest) {
        int N = (this.getPublicKey().getModulus().bitLength() + 7) / 8;
        byte[] toReturn = new byte[N - 1];
        toReturn[0] = 1;
        int offset = N - 33 - SIGPREFIX.length;
        Arrays.fill(toReturn, 1, offset - 1, (byte)-1);
        toReturn[offset - 1] = 0;
        if (digest.length == 32) {
            System.arraycopy(SIGPREFIX, 0, toReturn, offset, SIGPREFIX.length);
            offset += SIGPREFIX.length;
        }
        System.arraycopy(digest, 0, toReturn, offset, digest.length);
        return toReturn;
    }

    public static byte[] digest(byte[] digest) {
        if (digest.length == SIGPREFIX.length + 32) {
            return digest;
        }
        byte[] toReturn = new byte[SIGPREFIX.length + digest.length];
        System.arraycopy(SIGPREFIX, 0, toReturn, 0, SIGPREFIX.length);
        System.arraycopy(digest, 0, toReturn, SIGPREFIX.length, digest.length);
        return toReturn;
    }

    public byte[] verify(byte[] signature, byte[] digest) throws GeneralSecurityException {
        digest = A005PublicKey.digest(digest);
        BCRSAPkcs1PaddingCipher rsa = new BCRSAPkcs1PaddingCipher();
        int modBits = this.publicKey.getModulus().bitLength();
        signature = Provider.scale(signature, (modBits + 7) / 8);
        rsa.init(2, this.publicKey);
        byte[] decrypted = rsa.doFinal(signature);
        if (Arrays.equals(decrypted, digest)) {
            return digest;
        }
        throw new SignatureException("expected digest=" + HexTool.toHex(digest) + "\nsigned=" + HexTool.toHex(decrypted));
    }
}

