/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.zkasecurity;

import de.businesslogics.crypto.BCRSANopaddingCipher;
import de.businesslogics.zkasecurity.A005PublicKey;
import de.businesslogics.zkasecurity.DirectSecurity;
import de.businesslogics.zkasecurity.KeyStore;
import de.businesslogics.zkasecurity.PasswordCallback;
import de.businesslogics.zkasecurity.RSAPrivateKey;
import java.io.IOException;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.SecureRandom;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.RSAKeyGenParameterSpec;

public class A005PrivateKey
extends A005PublicKey
implements RSAPrivateKey {
    private static final char[] EMPTY_PWD = "".toCharArray();
    private java.security.interfaces.RSAPrivateKey privKey = null;

    public A005PrivateKey(int bitLength, SecureRandom random) throws GeneralSecurityException {
        super(null);
        if (bitLength < 1536 || bitLength > 16384) {
            throw new IllegalArgumentException("Wrong bit length " + bitLength);
        }
        KeyPairGenerator gen = DirectSecurity.getRSAKeyPairGenerator();
        RSAKeyGenParameterSpec KEYGEN_PARAMETER = new RSAKeyGenParameterSpec(bitLength, new BigInteger("010001", 16));
        if (random != null) {
            gen.initialize(KEYGEN_PARAMETER, random);
        } else {
            gen.initialize(KEYGEN_PARAMETER);
        }
        KeyPair pair = gen.generateKeyPair();
        this.publicKey = (RSAPublicKey)pair.getPublic();
        this.privKey = (java.security.interfaces.RSAPrivateKey)pair.getPrivate();
    }

    public A005PrivateKey(KeyPair pair) {
        super((RSAPublicKey)pair.getPublic());
        this.privKey = (java.security.interfaces.RSAPrivateKey)pair.getPrivate();
    }

    public A005PrivateKey(java.security.interfaces.RSAPrivateKey privKey, RSAPublicKey pubKey) {
        super(pubKey);
        this.privKey = privKey;
    }

    public static A005PrivateKey fromPKCS(byte[] data, PasswordCallback passwordCallback) throws IOException, GeneralSecurityException {
        char[] pwd = EMPTY_PWD;
        if (passwordCallback != null) {
            pwd = passwordCallback.getPassword();
        }
        return new A005PrivateKey(KeyStore.decryptStore(data, pwd));
    }

    @Override
    public byte[] toPKCS(PasswordCallback passwordCallback) {
        char[] pwd = EMPTY_PWD;
        if (passwordCallback != null) {
            pwd = passwordCallback.getPassword();
        }
        return KeyStore.encryptStore(this.getPrivateKey(), pwd);
    }

    @Override
    public java.security.interfaces.RSAPrivateKey getPrivateKey() {
        return this.privKey;
    }

    public byte[] sign(byte[] dsi) {
        if (dsi.length <= 32 + SIGPREFIX.length) {
            dsi = this.getDsi(dsi);
        }
        try {
            BCRSANopaddingCipher rsa = new BCRSANopaddingCipher();
            rsa.init(1, this.privKey);
            return rsa.doFinal(dsi);
        }
        catch (GeneralSecurityException gse) {
            throw new RuntimeException(gse);
        }
    }
}

