/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.zkasecurity;

import de.businesslogics.security.jce.BcsSignature;
import de.businesslogics.zkasecurity.A004PublicKey;
import java.security.GeneralSecurityException;
import java.security.SignatureException;

public class A004Verifier {
    protected BcsSignature bcsSig = new BcsSignature();

    public A004Verifier(A004PublicKey key) throws GeneralSecurityException {
        this.bcsSig.engineInitVerify(key.getPublicKey());
    }

    public void addBytes(byte[] data, int offset, int length) throws SignatureException {
        this.bcsSig.engineUpdate(data, offset, length);
    }

    public boolean verify(byte[] signature, int offset) throws SignatureException {
        byte[] rawSig = new byte[128];
        System.arraycopy(signature, offset + 4 + 4 + 3, rawSig, 0, 128);
        return this.bcsSig.engineVerify(rawSig);
    }

    public boolean verify(byte[] signature) throws SignatureException {
        return this.verify(signature, 0);
    }

    int getSignatureSize() {
        return 512;
    }
}

