/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.zkasecurity;

import de.businesslogics.security.jce.Provider;
import de.businesslogics.zkasecurity.A004PrivateKey;
import de.businesslogics.zkasecurity.A004Verifier;
import java.security.GeneralSecurityException;
import java.security.SignatureException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;

public class A004Signature
extends A004Verifier {
    private static final byte[] BLANKS = "                                                                                                                                ".getBytes();
    private A004PrivateKey key = null;

    public A004Signature(A004PrivateKey key) throws GeneralSecurityException {
        super(key);
        this.bcsSig.engineInitSign(key.getPrivateKey());
        this.key = key;
    }

    public byte[] finish(String filename, Date filedate, String orderType) throws SignatureException {
        byte[] sig = this.bcsSig.engineSign();
        return A004Signature.createSignatureFile(this.key.getBcsId(), filename, filedate, orderType, sig);
    }

    public static byte[] createSignatureFile(String userId, String filename, Date filedate, String orderType, byte[] sig) {
        byte[] toReturn = new byte[512];
        toReturn[0] = 65;
        toReturn[1] = 48;
        toReturn[2] = 48;
        toReturn[3] = 52;
        toReturn[4] = 49;
        toReturn[5] = 48;
        toReturn[6] = 50;
        toReturn[7] = 52;
        byte[] tmp = orderType.getBytes();
        int length = Math.min(3, tmp.length);
        System.arraycopy(tmp, 0, toReturn, 8, length);
        if (length < 3) {
            System.arraycopy(BLANKS, 0, toReturn, 8 + length, 3 - length);
        }
        System.arraycopy(Provider.scale(sig, 128), 0, toReturn, 11, 128);
        tmp = userId.getBytes();
        length = Math.min(8, tmp.length);
        System.arraycopy(tmp, 0, toReturn, 139, length);
        if (length < 8) {
            System.arraycopy(BLANKS, 0, toReturn, 139 + length, 8 - length);
        }
        tmp = filename == null ? new byte[]{} : filename.getBytes();
        length = Math.min(128, tmp.length);
        System.arraycopy(tmp, 0, toReturn, 147, length);
        if (length < 128) {
            System.arraycopy(BLANKS, 0, toReturn, 147 + length, 128 - length);
        }
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd HHmmss ");
        if (filedate != null) {
            byte[] ftime = df.format(filedate).getBytes();
            System.arraycopy(ftime, 0, toReturn, 275, 16);
        } else {
            Arrays.fill(toReturn, 275, 291, (byte)32);
        }
        byte[] stime = df.format(new Date()).getBytes();
        System.arraycopy(stime, 0, toReturn, 291, 16);
        Arrays.fill(toReturn, 307, toReturn.length, (byte)0);
        return toReturn;
    }
}

