/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.zkasecurity;

import de.businesslogics.security.jce.Provider;
import de.businesslogics.zkasecurity.RSAPublicKey;
import java.security.GeneralSecurityException;
import java.util.Arrays;

public class A004PublicKey
implements RSAPublicKey {
    protected java.security.interfaces.RSAPublicKey publicKey = null;
    protected String userId = null;

    public A004PublicKey(String userId, java.security.interfaces.RSAPublicKey publicKey) {
        this.userId = userId;
        this.publicKey = publicKey;
    }

    public static byte[] getHash(java.security.interfaces.RSAPublicKey key) {
        return Provider.getRipeMdHash(key);
    }

    @Override
    public byte[] getHash() throws GeneralSecurityException {
        return A004PublicKey.getHash(this.publicKey);
    }

    public static byte[] getINI(String userId, java.security.interfaces.RSAPublicKey key) {
        byte[] ini = new byte[512];
        Arrays.fill(ini, (byte)32);
        System.arraycopy("A004".getBytes(), 0, ini, 0, 4);
        System.arraycopy(userId.getBytes(), 0, ini, 4, userId.getBytes().length);
        System.arraycopy("1024".getBytes(), 0, ini, 12, 4);
        System.arraycopy(Provider.getExponent(key), 0, ini, 16, 128);
        System.arraycopy("1024".getBytes(), 0, ini, 144, 4);
        System.arraycopy(Provider.getModulus(key), 0, ini, 148, 128);
        Arrays.fill(ini, 276, ini.length, (byte)0);
        return ini;
    }

    public byte[] getINI() {
        return A004PublicKey.getINI(this.userId, this.publicKey);
    }

    public static A004PublicKey fromINI(byte[] ini) throws GeneralSecurityException {
        byte[] mod = new byte[128];
        byte[] exp = new byte[128];
        System.arraycopy(ini, 16, exp, 0, 128);
        System.arraycopy(ini, 148, mod, 0, 128);
        String userId = new String(ini, 4, 8);
        return new A004PublicKey(userId, Provider.buildKey(mod, exp));
    }

    @Override
    public String getBcsId() {
        return this.userId;
    }

    @Override
    public byte[] getModulus() {
        return Provider.getModulus(this.publicKey);
    }

    @Override
    public byte[] getPublicExponent() {
        return Provider.getExponent(this.publicKey);
    }

    @Override
    public java.security.interfaces.RSAPublicKey getPublicKey() {
        return this.publicKey;
    }
}

