/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.zkasecurity;

import de.businesslogics.crypto.BCRSANopaddingCipher;
import de.businesslogics.security.jce.BcsSignature;
import de.businesslogics.security.jce.Provider;
import de.businesslogics.zkasecurity.A004PublicKey;
import de.businesslogics.zkasecurity.DirectSecurity;
import de.businesslogics.zkasecurity.KeyStore;
import de.businesslogics.zkasecurity.PasswordCallback;
import de.businesslogics.zkasecurity.RSAPrivateKey;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.SecureRandom;
import java.security.interfaces.RSAPublicKey;

public class A004PrivateKey
extends A004PublicKey
implements RSAPrivateKey {
    private static final char[] EMPTY_PWD = "".toCharArray();
    private java.security.interfaces.RSAPrivateKey privKey = null;

    public A004PrivateKey(String userid, SecureRandom random) throws GeneralSecurityException {
        super(userid, null);
        KeyPairGenerator gen = DirectSecurity.getRSAKeyPairGenerator();
        if (random != null) {
            gen.initialize(Provider.A004_KEYGEN_PARAMETER, random);
        } else {
            gen.initialize(Provider.A004_KEYGEN_PARAMETER);
        }
        KeyPair pair = gen.generateKeyPair();
        this.publicKey = (RSAPublicKey)pair.getPublic();
        this.privKey = (java.security.interfaces.RSAPrivateKey)pair.getPrivate();
    }

    private A004PrivateKey(String userId, KeyPair pair) {
        super(userId, (RSAPublicKey)pair.getPublic());
        this.privKey = (java.security.interfaces.RSAPrivateKey)pair.getPrivate();
    }

    public A004PrivateKey(String userId, java.security.interfaces.RSAPrivateKey privKey, RSAPublicKey pubKey) {
        super(userId, pubKey);
        this.privKey = privKey;
    }

    public static A004PrivateKey fromPKCS(byte[] data, String userid, PasswordCallback passwordCallback) throws IOException, GeneralSecurityException {
        char[] pwd = EMPTY_PWD;
        if (passwordCallback != null) {
            pwd = passwordCallback.getPassword();
        }
        return new A004PrivateKey(userid, KeyStore.decryptStore(data, pwd));
    }

    @Override
    public byte[] toPKCS(PasswordCallback passwordCallback) {
        char[] pwd = EMPTY_PWD;
        if (passwordCallback != null) {
            pwd = passwordCallback.getPassword();
        }
        return KeyStore.encryptStore(this.getPrivateKey(), pwd);
    }

    @Override
    public java.security.interfaces.RSAPrivateKey getPrivateKey() {
        return this.privKey;
    }

    public byte[] sign(byte[] hash) {
        return this.signRaw(new BcsSignature.A004Parameter(hash, null).getDsi());
    }

    public byte[] signRaw(byte[] dsi) {
        try {
            BCRSANopaddingCipher rsa = new BCRSANopaddingCipher();
            rsa.init(1, this.privKey);
            return Provider.scale(rsa.doFinal(dsi), 128);
        }
        catch (GeneralSecurityException gse) {
            throw new RuntimeException(gse);
        }
    }
}

