/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.validation;

import java.util.regex.Pattern;

public enum RegularExpressions {
    UPPER_CASE_CHARACHTERS_AND_DIGITS("[A-Z0-9]*"),
    ALPHANUMERIC("[A-Za-z0-9]*"),
    JAVA_PACKAGE("[[A-Za-z]{1}[.^;]*\\.]*[A-Za-z]{1}[.^;]*"),
    CFONB_FILE("[A-Z0-9\\]\\[ \\.\\-/\\*()]*"),
    CFONB_GUI("[A-Za-z0-9\u00c1\u00e1\u00c0\u00e0\u00c2\u00e2\u00c4\u00e4\u00c6\u00e6\u00c7\u00e7\u00c9\u00e9\u00c8\u00e8\u00ca\u00ea\u00cb\u00eb\u00cd\u00ed\u00cc\u00ec\u00ce\u00ee\u00cf\u00ef\u00d3\u00f3\u00d2\u00f2\u00d4\u00f4\u00d6\u00f6\u0152\u0153\u00da\u00fa\u00d9\u00f9\u00db\u00fb\u00dc\u00fc\u0178\u00ff\\]\\[ \\.\\-/\\*()]*"),
    CFONB_GUI_WITH_PLACEHOLDER("[A-Za-z0-9\u00c1\u00e1\u00c0\u00e0\u00c2\u00e2\u00c4\u00e4\u00c6\u00e6\u00c7\u00e7\u00c9\u00e9\u00c8\u00e8\u00ca\u00ea\u00cb\u00eb\u00cd\u00ed\u00cc\u00ec\u00ce\u00ee\u00cf\u00ef\u00d3\u00f3\u00d2\u00f2\u00d4\u00f4\u00d6\u00f6\u0152\u0153\u00da\u00fa\u00d9\u00f9\u00db\u00fb\u00dc\u00fc\u0178\u00ff\\]\\[ \\.\\-/\\*()$+]*"),
    DTAUS("[A-Z0-9\u00c4\u00d6\u00dc\u00fc\u00df \\.,&\\-/\\+\\*$%]*"),
    DTAUS_GUI("[A-Za-z0-9\u00c4\u00e4\u00d6\u00f6\u00dc\u00fc\u00df \\.,&\\-/\\+\\*$%]*"),
    DTAUS_GUI_WITH_PLACEHOLDER("[A-Za-z0-9\u00c4\u00e4\u00d6\u00f6\u00dc\u00fc\u00df \\.,&\\-/\\+\\*$%)(]*"),
    DTAZV_GUI("[A-Za-z0-9\u00c4\u00e4\u00d6\u00f6\u00dc\u00fc\u00df \\.,\\-/\\+]*"),
    SEPA("[A-Za-z0-9 \\.,\\-/\\+)(?:']*"),
    SEPA_GUI("[A-Za-z0-9\u00df\u00c1\u00e1\u00c0\u00e0\u00c2\u00e2\u00c4\u00e4\u00c6\u00e6\u00c7\u00e7\u00c9\u00e9\u00c8\u00e8\u00ca\u00ea\u00cb\u00eb\u00cd\u00ed\u00cc\u00ec\u00ce\u00ee\u00cf\u00ef\u00d3\u00f3\u00d2\u00f2\u00d4\u00f4\u00d6\u00f6\u0152\u0153\u00da\u00fa\u00d9\u00f9\u00db\u00fb\u00dc\u00fc\u0178\u00ff\u00f8\u00e6\u00d8\u00e5_ \\.,\\-/\\+)(?&*$%:']*"),
    SEPA_GUI_WITH_PLACEHOLDER("[A-Za-z0-9\u00df\u00c1\u00e1\u00c0\u00e0\u00c2\u00e2\u00c4\u00e4\u00c6\u00e6\u00c7\u00e7\u00c9\u00e9\u00c8\u00e8\u00ca\u00ea\u00cb\u00eb\u00cd\u00ed\u00cc\u00ec\u00ce\u00ee\u00cf\u00ef\u00d3\u00f3\u00d2\u00f2\u00d4\u00f4\u00d6\u00f6\u0152\u0153\u00da\u00fa\u00d9\u00f9\u00db\u00fb\u00dc\u00fc\u0178\u00ff\u00f8\u00e6\u00d8\u00e5_ \\.,\\-/\\+)(?&*$%:'$]*"),
    SEPA_FOREIGN_GUI("[A-Za-z0-9\u00df\u00c1\u00e1\u00c0\u00e0\u00c2\u00e2\u00c4\u00e4\u00c6\u00e6\u00c7\u00e7\u00c9\u00e9\u00c8\u00e8\u00ca\u00ea\u00cb\u00eb\u00cd\u00ed\u00cc\u00ec\u00ce\u00ee\u00cf\u00ef\u00d3\u00f3\u00d2\u00f2\u00d4\u00f4\u00d6\u00f6\u0152\u0153\u00da\u00fa\u00d9\u00f9\u00db\u00fb\u00dc\u00fc\u0178\u00ff\u00f8\u00e6\u00d8\u00e5_ \\.,\\-/\\+)(?&:'<>@]*"),
    SEPA_FOREIGN_GUI_WITH_PLACEHOLDER("[A-Za-z0-9\u00df\u00c1\u00e1\u00c0\u00e0\u00c2\u00e2\u00c4\u00e4\u00c6\u00e6\u00c7\u00e7\u00c9\u00e9\u00c8\u00e8\u00ca\u00ea\u00cb\u00eb\u00cd\u00ed\u00cc\u00ec\u00ce\u00ee\u00cf\u00ef\u00d3\u00f3\u00d2\u00f2\u00d4\u00f4\u00d6\u00f6\u0152\u0153\u00da\u00fa\u00d9\u00f9\u00db\u00fb\u00dc\u00fc\u0178\u00ff\u00f8\u00e6\u00d8\u00e5_ \\.,\\-/\\+)(?&:'<>@$]*"),
    SEPA_CREDITOR_ID("DE\\d{2}[A-Za-z0-9]{3}0\\d{10}|AT\\d{2}[A-Za-z0-9]{3}0\\d{10}|CH\\d{2}[A-Za-z0-9]{3}\\d{11}|BE\\d{2}[A-Za-z0-9]{3}\\d{10}|BE\\d{2}[A-Za-z0-9]{3}\\d{3}D\\d{9}|(?!DE)(?!AT)(?!CH)(?!BE)([A-Z]{2})[0-9]{2}([A-Za-z0-9]|[\\+|\\?|/|\\-|:|\\(|\\)|\\.|,|']){4,31}"),
    SEPA_LEI("[A-Z0-9]{18,18}[0-9]{2,2}"),
    SEPA_RESTRICTED_IDENTIFICATION_1("([A-Za-z0-9]|[\\+|\\?|/|\\-|:|\\(|\\)|\\.|,|'| ]){1,35}"),
    SEPA_RESTRICTED_IDENTIFICATION_2("([A-Za-z0-9]|[\\+|\\?|/|\\-|:|\\(|\\)|\\.|,|'| ]){1,35}"),
    SEPA_RESTRICTED_IDENTIFICATION_1_WITHOUT_SPACE("([A-Za-z0-9]|[\\+|\\?|/|\\-|:|\\(|\\)|\\.|,|']){1,35}"),
    SWIFT("[A-Za-z0-9 \\.,\\-/\\+)(?:']*"),
    DIGITS("[0-9]*"),
    NUMERIC("[0-9\\.,-]*"),
    POSITIVE_NUMERIC("[0-9\\.,]*"),
    DATE("[0-9\\.,/]*"),
    EMAIL("[A-Za-z0-9._%+-]+@(?:[A-Za-z0-9-]+\\.)+[A-Za-z]+"),
    EUR("EUR"),
    PHONE("^[0-9,+,(), ,#,'\\-',*,/,]{1,}(,[0-9,-, ,]+){0,}$"),
    ALPHA("([A-Za-z])*"),
    ALL(".*"),
    ALL_CR_LF("(?s).*"),
    BIC("[A-Z]{6,6}[A-Z2-9][A-NP-Z0-9]([A-Z0-9]{3,3}){0,1}"),
    COUNTRY_CODE("[A-Z]{2,2}"),
    CREDITOR_REFERENCE_ISO11649("RF\\d{2}\\p{Alnum}{0,21}"),
    GERMAN_BANK_CODE(System.getProperty("de.businesslogics.validation.RegularExpressions.GERMAN_BANK_CODE", "[1-8]{1}[0-9]{7}")),
    FRENCH_BANK_CODE("[0-9]{5}"),
    IBAN("AD\\d{2}\\d{4}\\d{4}\\p{Alnum}{12}|AE\\d{2}\\d{3}\\d{16}|AL\\d{2}\\d{8}\\p{Alnum}{16}|AT\\d{2}\\d{5}\\d{11}|AZ\\d{2}[A-Z]{4}\\p{Alnum}{20}|BA\\d{2}\\d{3}\\d{3}\\d{8}\\d{2}|BE\\d{2}\\d{3}\\d{7}\\d{2}|BG\\d{2}[A-Z]{4}\\d{4}\\d{2}\\p{Alnum}{8}|BH\\d{2}[A-Z]{4}\\p{Alnum}{14}|BI\\d{2}\\d{5}\\d{5}\\d{11}\\d{2}|BR\\d{2}\\d{8}\\d{5}\\d{10}[A-Z]{1}\\p{Alnum}{1}|BY\\d{2}\\p{Alnum}{4}\\d{4}\\p{Alnum}{16}|CH\\d{2}\\d{5}\\p{Alnum}{12}|CR\\d{2}\\d{4}\\d{14}|CY\\d{2}\\d{3}\\d{5}\\p{Alnum}{16}|CZ\\d{2}\\d{4}\\d{6}\\d{10}|DE\\d{2}\\d{8}\\d{10}|DJ\\d{2}\\d{5}\\d{5}\\d{11}\\d{2}|DK\\d{2}\\d{4}\\d{9}\\d{1}|DO\\d{2}\\p{Alnum}{4}\\d{20}|EE\\d{2}\\d{2}\\d{2}\\d{11}\\d{1}|EG\\d{2}\\d{4}\\d{4}\\d{17}|ES\\d{2}\\d{4}\\d{4}\\d{1}\\d{1}\\d{10}|FI\\d{2}\\d{3}\\d{11}|FK\\d{2}[A-Z]{2}\\d{12}|FO\\d{2}\\d{4}\\d{9}\\d{1}|FR\\d{2}\\d{5}\\d{5}\\p{Alnum}{11}\\d{2}|GB\\d{2}[A-Z]{4}\\d{6}\\d{8}|GE\\d{2}[A-Z]{2}\\d{16}|GI\\d{2}[A-Z]{4}\\p{Alnum}{15}|GL\\d{2}\\d{4}\\d{9}\\d{1}|GR\\d{2}\\d{3}\\d{4}\\p{Alnum}{16}|GT\\d{2}\\p{Alnum}{4}\\p{Alnum}{20}|HN\\d{2}[A-Z]{4}\\d{20}|HR\\d{2}\\d{7}\\d{10}|HU\\d{2}\\d{3}\\d{4}\\d{1}\\d{15}\\d{1}|IE\\d{2}[A-Z]{4}\\d{6}\\d{8}|IL\\d{2}\\d{3}\\d{3}\\d{13}|IQ\\d{2}[A-Z]{4}\\d{3}\\d{12}|IS\\d{2}\\d{4}\\d{2}\\d{6}\\d{10}|IT\\d{2}[A-Z]{1}\\d{5}\\d{5}\\p{Alnum}{12}|JO\\d{2}[A-Z]{4}\\d{4}\\p{Alnum}{18}|KW\\d{2}[A-Z]{4}\\p{Alnum}{22}|KZ\\d{2}\\d{3}\\p{Alnum}{13}|LB\\d{2}\\d{4}\\p{Alnum}{20}|LC\\d{2}[A-Z]{4}\\p{Alnum}{24}|LI\\d{2}\\d{5}\\p{Alnum}{12}|LT\\d{2}\\d{5}\\d{11}|LU\\d{2}\\d{3}\\p{Alnum}{13}|LV\\d{2}[A-Z]{4}\\p{Alnum}{13}|LY\\d{2}\\d{3}\\d{3}\\d{15}|MC\\d{2}\\d{5}\\d{5}\\p{Alnum}{11}\\d{2}|MD\\d{2}\\p{Alnum}{2}\\p{Alnum}{18}|ME\\d{2}\\d{3}\\d{13}\\d{2}|MK\\d{2}\\d{3}\\p{Alnum}{10}\\d{2}|MN\\d{2}\\d{4}\\d{12}|MR\\d{2}\\d{5}\\d{5}\\d{11}\\d{2}|MT\\d{2}[A-Z]{4}\\d{5}\\p{Alnum}{18}|MU\\d{2}[A-Z]{4}\\d{2}\\d{2}\\d{12}\\d{3}[A-Z]{3}|NI\\d{2}[A-Z]{4}\\d{20}|NL\\d{2}[A-Z]{4}\\d{10}|NO\\d{2}\\d{4}\\d{6}\\d{1}|OM\\d{2}\\d{3}\\p{Alnum}{16}|PK\\d{2}[A-Z]{4}\\p{Alnum}{16}|PL\\d{2}\\d{8}\\d{16}|PS\\d{2}[A-Z]{4}\\p{Alnum}{21}|PT\\d{2}\\d{4}\\d{4}\\d{11}\\d{2}|QA\\d{2}[A-Z]{4}\\p{Alnum}{21}|RO\\d{2}[A-Z]{4}\\p{Alnum}{16}|RS\\d{2}\\d{3}\\d{13}\\d{2}|RU\\d{2}\\d{9}\\d{5}\\p{Alnum}{15}|SA\\d{2}\\d{2}\\p{Alnum}{18}|SC\\d{2}[A-Z]{4}\\d{2}\\d{2}\\d{16}[A-Z]{3}|SD\\d{2}\\d{2}\\d{12}|SE\\d{2}\\d{3}\\d{16}\\d{1}|SI\\d{2}\\d{5}\\d{8}\\d{2}|SK\\d{2}\\d{4}\\d{6}\\d{10}|SM\\d{2}[A-Z]{1}\\d{5}\\d{5}\\p{Alnum}{12}|SO\\d{2}\\d{4}\\d{3}\\d{12}|ST\\d{2}\\d{4}\\d{4}\\d{11}\\d{2}|SV\\d{2}[A-Z]{4}\\d{20}|TL\\d{2}\\d{3}\\d{14}\\d{2}|TN\\d{2}\\d{2}\\d{3}\\d{13}\\d{2}|TR\\d{2}\\d{5}\\d{1}\\p{Alnum}{16}|UA\\d{2}\\d{6}\\p{Alnum}{19}|VA\\d{2}\\d{3}\\d{15}|VG\\d{2}[A-Z]{4}\\d{16}|XK\\d{2}\\d{4}\\d{10}\\d{2}|YE\\d{2}[A-Z]{4}\\d{4}\\p{Alnum}{18}"),
    EXPERIMENTAL_IBAN("AO\\d{2}\\p{Alnum}{21}|BF\\d{2}\\p{Alnum}{2}\\d{3}\\d{19}|BJ\\d{2}\\p{Alnum}{24}|CF\\d{2}\\p{Alnum}{23}|CG\\d{2}\\p{Alnum}{23}|CI\\d{2}\\p{Alnum}{2}\\d{3}\\d{19}|CM\\d{2}\\d{10}\\d{13}|CV\\d{2}\\p{Alnum}{21}|DZ\\d{2}\\p{Alnum}{2}\\d{3}\\d{17}|GA\\d{2}\\p{Alnum}{23}|GQ\\d{2}\\p{Alnum}{23}|GW\\d{2}\\p{Alnum}{21}|IR\\d{2}\\p{Alnum}{22}|KM\\d{2}\\p{Alnum}{23}|MA\\d{2}\\p{Alnum}{24}|MG\\d{2}\\d{10}\\d{13}|ML\\d{2}\\p{Alnum}{24}|MZ\\d{2}\\p{Alnum}{21}|NE\\d{2}\\p{Alnum}{24}|SN\\d{2}\\p{Alnum}{2}\\d{3}\\d{19}|TD\\d{2}\\p{Alnum}{23}|TG\\d{2}\\p{Alnum}{24}"),
    GERMAN_ACCOUNT_NUMBER("[0-9]{1,10}"),
    YEAR("(\\*)|" + RegularExpressions.getRegExp(1970, 2099)),
    MONTH("(\\*)|" + RegularExpressions.getRegExp(1, 12)),
    HOUR("(\\*)|" + RegularExpressions.getRegExp(0, 23)),
    MINUTE("(\\*)|" + RegularExpressions.getRegExp(0, 59)),
    DAY_OF_MONTH("(\\*)|(\\?)|" + RegularExpressions.getRegExp(1, 31)),
    HEX_CHAR("[A-F0-9]"),
    HEX_STRING("[a-fA-F0-9]*"),
    HOST_ID("[A-Za-z0-9\\-]*"),
    UNCHECKED(""),
    EBICS_V24_PARTNER_ID("[a-zA-Z0-9,=]{1,35}"),
    EBICS_V24_HOST_ID("\\S{1,35}"),
    EBICS_V24_USER_ID("[a-zA-Z0-9,=]{1,35}"),
    SUBSITUTION_PATTERN("(?s)(((?!\\$\\().)|(\\$\\(((?!\\$\\().)*\\)))*"),
    ORDER_NUMBER("[A-Z][A-Z0-9]{3}"),
    ORDER_TYPE("[A-Z0-9]{3}"),
    FRENCH_FILE_TYPE("[a-z0-9]+(\\.[a-z0-9]+)*"),
    AUSTRIA_BANK_CODE("[0-9]{5}"),
    AUSTRIA_ACCOUNT_NUMBER("[0-9]{1,11}"),
    AUSTRIA_TAX_NUMBER("([0-9]|[/|\\-| ]){1,35}"),
    CZ_BANK_CODE("[0-9]{4}"),
    CZ_ACCOUNT_NUMBER("[0-9]{1,16}"),
    SK_BANK_CODE("[0-9]{4}"),
    SK_ACCOUNT_NUMBER("[0-9]{1,16}"),
    HUNGARY_BANK_CODE("[0-9]{1,8}"),
    HUNGARY_ACCOUNT_NUMBER("[0-9]{1,16}"),
    BA_BANK_CODE("[0-9]{6}"),
    BA_ACCOUNT_NUMBER("[0-9]{1,10}"),
    ME_BANK_CODE("[0-9]{3}"),
    ME_ACCOUNT_NUMBER("[0-9]{1,15}"),
    RS_BANK_CODE("[0-9]{3}"),
    RS_ACCOUNT_NUMBER("[0-9]{1,15}"),
    PL_BANK_CODE("[0-9]{1,8}"),
    PL_ACCOUNT_NUMBER("[0-9]{1,16}"),
    CAMT53_BKTXCD("([0-9]{3}|[A-Z0-9]{4}\\+[0-9]{3}[\\+.{0,10}[[\\+]{1}.{0,15}]{0,1}]{0,1})"),
    ANY_BANK_CODE("[a-zA-Z0-9]{1,35}"),
    AUBSB_BANK_CODE("[0-9]{6,6}"),
    ATBLZ_BANK_CODE("[0-9]{5,5}"),
    CACPA_BANK_CODE("[0-9]{9,9}"),
    CHBCC_BANK_CODE("[0-9]{3,5}"),
    CHSIC_BANK_CODE("[0-9]{6,6}"),
    CNAPS_BANK_CODE("[0-9]{12,12}"),
    CNCIP_BANK_CODE("[a-zA-Z0-9]{11}"),
    ESNCC_BANK_CODE("[0-9]{8,9}"),
    GBDSC_BANK_CODE("[0-9]{6,6}"),
    GRBIC_BANK_CODE("[0-9]{7,7}"),
    HKNCC_BANK_CODE("[0-9]{3,3}"),
    IENCC_BANK_CODE("[0-9]{6,6}"),
    INFSC_BANK_CODE("[a-zA-Z0-9]{11,11}"),
    ITNCC_BANK_CODE("[0-9]{10,10}"),
    JPZGN_BANK_CODE("[0-9]{7,7}"),
    KRBOK_BANK_CODE("[0-9]{4,4}"),
    MZBMO_BANK_CODE("[a-zA-Z0-9]{1.15}"),
    NZNCC_BANK_CODE("[0-9]{6,6}"),
    NZRSA_BANK_CODE("[0-9A-Z]{8,15}"),
    PLKNR_BANK_CODE("[0-9]{8,8}"),
    PTNCC_BANK_CODE("[0-9]{8,8}"),
    RUCBC_BANK_CODE("[0-9]{9,9}"),
    SESBA_BANK_CODE("[0-9]{4,4}"),
    SGIBG_BANK_CODE("[0-9]{3,4}|[0-9]{7,7}"),
    THCBC_BANK_CODE("[0-9]{3,3}"),
    TWNCC_BANK_CODE("[0-9]{7,7}"),
    USABA_BANK_CODE("[0-9]{9,9}"),
    USPID_BANK_CODE("[0-9]{4,4}"),
    ZANCC_BANK_CODE("[0-9]{6,6}"),
    SWISS_REFERENCE_NUMBER("[0-9]{27}"),
    SWISS_ESR_NUMBER("01[0-9]{6}|03[0-9]{7}"),
    SWISS_POST_ACCOUNT_NUMBER("[0-9]{9}"),
    SWISS_IID("[1-9]{1}[0-9]{4}"),
    INJECTION_CSV("^[\r\t@+=-].*"),
    NUMBER_OR_DECIMALS("[+-]?([0-9]+[\\.,]?[0-9]*|\\.[0-9]+)"),
    INVALID_FILE_NAME_CHARS(".*[\\/:*?\"<>|].*"),
    FORBIDDEN_FILE_NAME_CHARS("[\\\\/:*?\"<>|]"),
    BTF_SERVICE_PATTERN("(?<serviceName>\\p{Alnum}{3})(:(?<scope>\\p{Alnum}{2,3})?(:(?<option>\\p{Alnum}{3,10}))?)?_(?<msgName>[\\p{Alnum}.]{1,10})(:(?<variant>\\d{3})?(:(?<version>\\d{2})?(:(?<format>\\p{Alnum}{1,4}))?))?(_(?<container>\\p{Alpha}{3}))?");

    private final String regexp;
    private Pattern pattern;

    private static String getRegExp(int start, int end) {
        StringBuilder sb = new StringBuilder();
        for (int i = start; i < end; ++i) {
            sb.append("(");
            sb.append(i);
            sb.append(")");
            if (i >= end - 1) continue;
            sb.append("|");
        }
        return "(" + String.valueOf(sb) + ")((,)|(-)" + String.valueOf(sb) + ")*";
    }

    private RegularExpressions(String regexp) {
        this.regexp = regexp;
    }

    @Deprecated
    public String getRegExp() {
        return this.regexp;
    }

    public boolean matches(String input) {
        return this.getPattern().matcher(input == null ? "" : input).matches();
    }

    public Pattern getPattern() {
        if (this.pattern == null) {
            this.pattern = Pattern.compile(this.regexp);
        }
        return this.pattern;
    }
}

