/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.util.xml;

import de.businesslogics.ebics.schema.OutputContentHandler;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XSDDowngrader
extends DefaultHandler {
    private ByteArrayOutputStream bos = new ByteArrayOutputStream();
    private OutputContentHandler och = new OutputContentHandler(this.bos);
    private int skipping = 0;

    private XSDDowngrader() throws IOException {
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.och.setDocumentLocator(locator);
    }

    @Override
    public void startDocument() throws SAXException {
        this.och.startDocument();
    }

    @Override
    public void endDocument() throws SAXException {
        this.och.endDocument();
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        if (this.skipping == 0) {
            this.och.startPrefixMapping(prefix, uri);
        }
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
        if (this.skipping == 0) {
            this.och.endPrefixMapping(prefix);
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        if (this.skipping > 0) {
            ++this.skipping;
            return;
        }
        if ("http://www.w3.org/2001/XMLSchema".equals(uri) && "assert".equals(localName)) {
            this.skipping = 1;
            return;
        }
        this.och.startElement(uri, localName, qName, atts);
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (this.skipping > 0) {
            --this.skipping;
            return;
        }
        this.och.endElement(uri, localName, qName);
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.skipping == 0) {
            this.och.characters(ch, start, length);
        }
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        if (this.skipping == 0) {
            this.och.ignorableWhitespace(ch, start, length);
        }
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
        if (this.skipping == 0) {
            this.och.processingInstruction(target, data);
        }
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
        if (this.skipping == 0) {
            this.och.skippedEntity(name);
        }
    }

    public static InputStream convert(InputStream is) throws IOException, SAXException {
        SAXParser parser;
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setValidating(false);
        factory.setNamespaceAware(true);
        try {
            factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            parser = factory.newSAXParser();
        }
        catch (Exception e) {
            throw new RuntimeException("No parser available", e);
        }
        XSDDowngrader dg = new XSDDowngrader();
        parser.parse(is, (DefaultHandler)dg);
        return new ByteArrayInputStream(dg.bos.toByteArray());
    }
}

