/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.util.xml;

import de.businesslogics.bcs.core.YYMMDD;
import de.businesslogics.ebics.schema.types.TimeStamp;
import de.businesslogics.ebics.schema.types.XMLDate;
import de.businesslogics.format.ticket.HashHolder;
import de.businesslogics.util.HexTool;
import de.businesslogics.util.LogUtils;
import de.businesslogics.util.Objects;
import de.businesslogics.util.SystemUtils;
import de.businesslogics.util.xml.ClassPathLSInput;
import de.businesslogics.util.xml.OutputSAXParser;
import de.businesslogics.util.xml.XSDDowngrader;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.ValidatorHandler;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public abstract class SmartDefaultHandler
extends DefaultHandler
implements LSResourceResolver {
    private static final Logger LOGGER = Logger.getLogger(SmartDefaultHandler.class.getName());
    private static final Map<Class<? extends SmartDefaultHandler>, Maps> SUBCLASSES = new ConcurrentHashMap<Class<? extends SmartDefaultHandler>, Maps>();
    private static final Map<String, Schema> SCHEMAS = new ConcurrentHashMap<String, Schema>();
    private static final Class<?>[] START_METHOD_PARAMS = new Class[]{Attributes.class};
    private static final Class<?>[] END_METHOD_PARAMS = new Class[0];
    protected Locator locator;
    private final StringBuilder value = new StringBuilder();
    private Path path;
    private final HashMap<Path, Method> startMethods;
    private final HashMap<Path, Method> endMethods;
    private final HashSet<Path> rootElements;
    private boolean knownRootElement;
    private SmartDefaultHandler sub;
    private int subParserDepth;
    private static final String SCHEMA_URI;
    private static final String XSD_1_1_URI = "http://www.w3.org/XML/XMLSchema/v1.1";

    public SmartDefaultHandler() {
        this(null, true);
    }

    public SmartDefaultHandler(String uri, boolean add) {
        Maps maps = SmartDefaultHandler.getMethods(this.getClass(), uri, add);
        this.startMethods = maps.startMethods;
        this.endMethods = maps.endMethods;
        this.rootElements = maps.rootElements;
    }

    protected String getNamespaceSchemaLocations() {
        return null;
    }

    protected boolean requireXsd11() {
        return false;
    }

    @Override
    public final InputSource resolveEntity(String publicId, String systemId) throws IOException, SAXException {
        if (systemId.startsWith("file://")) {
            systemId = systemId.substring(7);
        }
        InputStream is = null;
        if (systemId.endsWith(".xsd") && (is = SmartDefaultHandler.class.getResourceAsStream(systemId)) != null && SCHEMA_URI != XSD_1_1_URI && this.requireXsd11()) {
            is = XSDDowngrader.convert(is);
            LOGGER.warning("Downgrading " + systemId + " to XSD-1.0");
        }
        assert (is != null) : systemId + " not found";
        InputSource tr = new InputSource(is);
        tr.setPublicId(publicId);
        tr.setSystemId(systemId);
        return tr;
    }

    @Override
    public LSInput resolveResource(String type, String namespaceURI, String publicId, String systemId, String baseURI) {
        Object mySystemId = systemId;
        if (systemId.startsWith("file://")) {
            mySystemId = systemId.substring(7);
        }
        if (!((String)mySystemId).startsWith("/")) {
            int i;
            String myBaseURI = baseURI;
            if (myBaseURI.startsWith("file://")) {
                myBaseURI = myBaseURI.substring(7);
            }
            if ((i = myBaseURI.lastIndexOf(47)) >= 0) {
                mySystemId = myBaseURI.substring(0, i + 1) + (String)mySystemId;
            }
        }
        return new ClassPathLSInput((String)mySystemId, publicId, (String)mySystemId, baseURI);
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        Method m;
        if (this.sub != null) {
            this.sub.startElement(uri, localName, qName, attributes);
            ++this.subParserDepth;
            return;
        }
        this.path = new Path(this.path, uri, localName);
        if (!this.knownRootElement) {
            if (!this.rootElements.contains(this.path)) {
                throw new SAXParseException("Unhandled root element '" + String.valueOf(this.path) + "'", this.locator);
            }
            this.knownRootElement = true;
        }
        if ((m = this.startMethods.get(this.path)) != null) {
            try {
                if (LOGGER.isLoggable(Level.FINEST)) {
                    LOGGER.finest("Calling " + m.getName());
                }
                this.sub = (SmartDefaultHandler)m.invoke((Object)this, attributes);
                if (this.sub != null) {
                    this.subParserDepth = 1;
                    this.sub.setDocumentLocator(this.locator);
                    this.sub.startDocument();
                    this.sub.startElement(uri, localName, qName, attributes);
                }
            }
            catch (InvocationTargetException ite) {
                SmartDefaultHandler.throwSAXException(ite);
            }
            catch (IllegalAccessException e) {
                throw new SAXException(e);
            }
        }
        this.value.setLength(0);
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        Method m;
        if (this.sub != null) {
            this.sub.endElement(uri, localName, qName);
            --this.subParserDepth;
            if (this.subParserDepth != 0) {
                return;
            }
            this.sub.endDocument();
            this.sub = null;
        }
        if ((m = this.endMethods.get(this.path)) != null) {
            try {
                if (LOGGER.isLoggable(Level.FINEST)) {
                    LOGGER.finest("Calling " + m.getName());
                }
                m.invoke((Object)this, new Object[0]);
            }
            catch (InvocationTargetException ite) {
                SmartDefaultHandler.throwSAXException(ite);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
        this.path = this.path.parent;
    }

    private static void throwSAXException(InvocationTargetException ite) throws SAXException {
        Throwable t = ite.getCause();
        if (t instanceof SAXException) {
            throw (SAXException)t;
        }
        if (t instanceof Error) {
            throw (Error)t;
        }
        if (t instanceof RuntimeException) {
            throw (RuntimeException)t;
        }
        if (t instanceof Exception) {
            throw new SAXException((Exception)t);
        }
        throw new SAXException(ite);
    }

    protected Path getPath() {
        return this.path;
    }

    protected String getString() {
        return this.value.toString();
    }

    protected int getInt() throws SAXParseException {
        String s = this.getCondensed();
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException nfe) {
            throw new SAXParseException("Invalid number " + s, this.locator);
        }
    }

    protected long getLong() throws SAXParseException {
        String s = this.getCondensed();
        try {
            return Long.parseLong(s);
        }
        catch (NumberFormatException nfe) {
            throw new SAXParseException("Invalid number " + s, this.locator);
        }
    }

    private static char replaceWhite(char ch) {
        return (char)(ch <= 13 && (ch == 9 || ch == 10 || ch == 13) ? 32 : ch);
    }

    protected void condense() {
        char ch;
        boolean inWhite = false;
        int pos = 0;
        int len = this.value.length();
        int w = 0;
        while (pos < len) {
            if ((ch = SmartDefaultHandler.replaceWhite(this.value.charAt(pos++))) == ' ') continue;
            this.value.setCharAt(w++, ch);
            break;
        }
        while (pos < len) {
            if ((ch = SmartDefaultHandler.replaceWhite(this.value.charAt(pos++))) == ' ') {
                inWhite = true;
                continue;
            }
            if (inWhite) {
                this.value.setCharAt(w++, ' ');
                inWhite = false;
            }
            this.value.setCharAt(w++, ch);
        }
        this.value.setLength(w);
    }

    protected String getCondensed() {
        this.condense();
        return this.getString();
    }

    protected BigDecimal getDecimal() throws SAXParseException {
        String s = this.getCondensed();
        try {
            return new BigDecimal(s);
        }
        catch (NumberFormatException nfe) {
            throw new SAXParseException("Invalid decimal " + s, this.locator);
        }
    }

    protected boolean getBoolean() throws SAXParseException {
        String s = this.getCondensed();
        try {
            return Boolean.parseBoolean(s);
        }
        catch (NumberFormatException nfe) {
            throw new SAXParseException("Invalid boolean " + s, this.locator);
        }
    }

    protected YYMMDD getDate() throws SAXParseException {
        return XMLDate.fromString(this.getCondensed(), this.locator);
    }

    protected Date getDateTime() throws SAXParseException {
        String s = this.getCondensed();
        try {
            return TimeStamp.fromString(s, true);
        }
        catch (ParseException e) {
            throw new SAXParseException("Invalid date " + s, this.locator);
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.sub != null) {
            this.sub.characters(ch, start, length);
            return;
        }
        this.value.append(ch, start, length);
    }

    @Override
    public void error(SAXParseException e) throws SAXParseException {
        LOGGER.fine("SAXParseException at " + e.getSystemId() + ":" + e.getLineNumber() + ":" + e.getColumnNumber() + ": " + String.valueOf(e));
        throw e;
    }

    @Override
    public void warning(SAXParseException e) throws SAXParseException {
        this.error(e);
    }

    public void parse(InputStream in) throws SAXException, IOException {
        SAXParser parser;
        SAXParserFactory factory = SAXParserFactory.newInstance();
        String nssl = this.getNamespaceSchemaLocations();
        factory.setValidating(nssl != null);
        factory.setNamespaceAware(true);
        try {
            factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        }
        catch (Exception e) {
            LogUtils.logp(LOGGER, Level.FINE, LOGGER.getName(), "parse", "Failed to disallow DOCTYPE declaration!", e);
        }
        try {
            parser = factory.newSAXParser();
            if (factory.isValidating()) {
                XMLReader xmlReader = parser.getXMLReader();
                xmlReader.setFeature("http://xml.org/sax/features/validation", true);
                xmlReader.setFeature("http://apache.org/xml/features/validation/schema", true);
                xmlReader.setProperty("http://apache.org/xml/properties/schema/external-schemaLocation", nssl);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("No parser available", e);
        }
        parser.parse(in, (DefaultHandler)this);
    }

    public OutputSAXParser getOutputSAXParser(ContentHandler ch) throws IOException, SAXException {
        String namespaces = this.getNamespaceSchemaLocations();
        if (namespaces != null) {
            ValidatorHandler vh = this.getSchema(namespaces).newValidatorHandler();
            vh.setContentHandler(ch);
            vh.setResourceResolver(this);
            ch = vh;
        }
        OutputSAXParser toReturn = new OutputSAXParser();
        toReturn.setContentHandler(ch);
        return toReturn;
    }

    public OutputSAXParser getOutputSAXParser() throws IOException, SAXException {
        return this.getOutputSAXParser(this);
    }

    @Override
    public void startDocument() throws SAXException {
        this.path = null;
        this.sub = null;
        this.knownRootElement = false;
    }

    protected static void appendNamespaceSchemaLocation(StringBuilder sb, String publicId, String systemId) {
        if (sb.length() != 0) {
            sb.append(' ');
        }
        sb.append(publicId).append(' ').append(systemId);
    }

    protected static String finishNamespaceSchemaLocations(StringBuilder sb) {
        return sb.length() == 0 ? null : sb.toString();
    }

    private static Maps getMethods(Class<? extends SmartDefaultHandler> clazz, String uri, boolean add) {
        Maps toReturn = SUBCLASSES.get(clazz);
        if (toReturn != null) {
            return toReturn;
        }
        try {
            Class<? extends SmartDefaultHandler> c = clazz;
            toReturn = new Maps(uri);
            while (!SmartDefaultHandler.class.equals(c)) {
                for (Method m : c.getDeclaredMethods()) {
                    Callback callback = m.getAnnotation(Callback.class);
                    if (callback == null) continue;
                    for (String field : callback.value()) {
                        toReturn.add(c, field, m);
                    }
                }
                c = c.getSuperclass();
            }
            if (uri != null && add) {
                Maps maps2 = new Maps(null);
                c = clazz;
                while (!SmartDefaultHandler.class.equals(c)) {
                    for (Method m : c.getDeclaredMethods()) {
                        Callback callback = m.getAnnotation(Callback.class);
                        if (callback == null) continue;
                        for (String field : callback.value()) {
                            maps2.add(c, field, m);
                        }
                    }
                    c = c.getSuperclass();
                }
                toReturn.endMethods.putAll(maps2.endMethods);
                toReturn.rootElements.addAll(maps2.rootElements);
                toReturn.startMethods.putAll(maps2.startMethods);
            }
            SUBCLASSES.put(clazz, toReturn);
            assert (toReturn.ensureAllUsed(clazz, add ? null : uri));
        }
        catch (Exception e) {
            SystemUtils.throwRuntimeException(e);
        }
        return toReturn;
    }

    private Schema getSchema(String namespaces) throws SAXException, IOException {
        Schema toReturn = SCHEMAS.get(namespaces);
        if (toReturn == null) {
            String[] s = namespaces.split(" ");
            Source[] sources = new Source[s.length / 2];
            for (int i = 0; i < s.length; i += 2) {
                sources[i / 2] = new SAXSource(this.resolveEntity(s[i], s[i + 1]));
            }
            SchemaFactory sf = SchemaFactory.newInstance(SCHEMA_URI);
            sf.setResourceResolver(this);
            toReturn = sf.newSchema(sources);
            SCHEMAS.put(namespaces, toReturn);
        }
        return toReturn;
    }

    @Deprecated
    public static void setGivenHash(HashHolder h, String s, Locator locator) throws SAXParseException {
        if (HashHolder.UPPERCASE_HASH) {
            int i = s.length();
            while (--i >= 0) {
                char c = s.charAt(i);
                if (c < 'a' || c > 'f') continue;
                throw new SAXParseException("Hash must not contain lowercase letters", locator);
            }
        }
        h.setGivenHash(HexTool.fromHex(s));
    }

    static {
        String s = XSD_1_1_URI;
        try {
            SchemaFactory.newInstance(s);
        }
        catch (Exception e) {
            s = "http://www.w3.org/2001/XMLSchema";
        }
        SCHEMA_URI = s;
    }

    private static class Maps {
        private final HashMap<Path, Method> startMethods = new HashMap();
        private final HashMap<Path, Method> endMethods = new HashMap();
        private final HashSet<Path> rootElements = new HashSet();
        private final String uri;
        private final Map<Path, Path> pathMap = new HashMap<Path, Path>();

        public Maps(String uri) {
            this.uri = uri;
        }

        public void add(Class<? extends SmartDefaultHandler> clazz, String field, Method m) throws SecurityException, NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
            Object[] params;
            Field f = clazz.getDeclaredField(field);
            Path p = (Path)f.get(null);
            if (this.uri != null) {
                if (this.pathMap.containsKey(p)) {
                    p = this.pathMap.get(p);
                } else {
                    Path parent = this.buildParent(p.parent);
                    p = new Path(parent, this.uri, p.localName);
                }
            }
            if (Arrays.equals(START_METHOD_PARAMS, params = m.getParameterTypes())) {
                m2 = this.startMethods.put(p, m);
                if (m2 != null) {
                    throw new RuntimeException("@Callback(\"" + field + "\")" + String.valueOf(m2) + " overwrites " + String.valueOf(m));
                }
            } else if (Arrays.equals(END_METHOD_PARAMS, params)) {
                m2 = this.endMethods.put(p, m);
                if (m2 != null) {
                    throw new RuntimeException("@Callback(\"" + field + "\")" + String.valueOf(m2) + " overwrites " + String.valueOf(m));
                }
            } else {
                throw new RuntimeException(m.toString() + " has wrong parameters");
            }
            while (p.parent != null) {
                p = p.parent;
            }
            this.rootElements.add(p);
        }

        private Path buildParent(Path path) {
            if (path == null) {
                return null;
            }
            if (path.uri.equals(this.uri)) {
                return path;
            }
            if (this.pathMap.containsKey(path)) {
                return this.pathMap.get(path);
            }
            Path parent = null;
            if (path.parent != null) {
                parent = this.buildParent(path.parent);
            }
            Path toReturn = new Path(parent, this.uri, path.localName);
            this.pathMap.put(path, toReturn);
            return toReturn;
        }

        boolean ensureAllUsed(Class<? extends SmartDefaultHandler> clazz, String uri) throws IllegalArgumentException, IllegalAccessException {
            while (!clazz.equals(SmartDefaultHandler.class)) {
                Field[] fields;
                for (Field f : fields = clazz.getDeclaredFields()) {
                    if (!f.getType().equals(Path.class)) continue;
                    Path p = (Path)f.get(null);
                    if (uri != null) {
                        if (this.pathMap.containsKey(p)) {
                            p = this.pathMap.get(p);
                        } else {
                            Path parent = this.buildParent(p.parent);
                            p = new Path(parent, uri, p.localName);
                        }
                    }
                    if (this.startMethods.containsKey(p) || this.endMethods.containsKey(p)) continue;
                    throw new RuntimeException(f.toString() + " not used");
                }
                clazz = clazz.getSuperclass();
            }
            return true;
        }
    }

    protected static class Path {
        private final Path parent;
        private final String uri;
        private final String localName;
        private final int hashCode;

        public Path(Path parent, String uri, String localName) {
            this.parent = parent;
            this.uri = uri;
            this.localName = localName;
            int i = localName.hashCode() * 31 + uri.hashCode();
            this.hashCode = parent != null ? parent.hashCode * 31 + i : i;
        }

        public Path(Path parent, String localName) {
            this(parent, parent.uri, localName);
        }

        public Path getParent() {
            return this.parent;
        }

        public String getUri() {
            return this.uri;
        }

        public String getLocalName() {
            return this.localName;
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Path)) {
                return false;
            }
            Path o = (Path)obj;
            if (o.hashCode != this.hashCode) {
                return false;
            }
            return o.localName.equals(this.localName) && o.uri.equals(this.uri) && Objects.equals(o.parent, this.parent);
        }

        private void toString(StringBuilder sb) {
            if (this.parent != null) {
                this.parent.toString(sb);
                sb.append('>');
            }
            if (this.parent == null || !this.parent.uri.equals(this.uri)) {
                sb.append(this.uri).append('&');
            }
            sb.append(this.localName);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            this.toString(sb);
            return sb.toString();
        }

        public Path prefixPath(Path newRoot) {
            if (newRoot == null) {
                return this;
            }
            if (this.parent != null) {
                return new Path(this.parent.prefixPath(newRoot), this.uri, this.localName);
            }
            return new Path(newRoot, this.uri, this.localName);
        }
    }

    @Target(value={ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    protected static @interface Callback {
        public String[] value();
    }
}

