/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.util.xml;

import de.businesslogics.util.xml.OutputSAXParser;
import java.io.IOException;
import java.io.OutputStream;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class OutputSAXParserStream
extends OutputStream {
    private OutputSAXParser op;

    public OutputSAXParserStream(ContentHandler handler) throws IOException {
        this.op = new OutputSAXParser();
        try {
            this.op.setContentHandler(handler);
        }
        catch (SAXException se) {
            IOException ioe = new IOException(OutputSAXParserStream.getMessage(se));
            ioe.initCause(se);
            throw ioe;
        }
    }

    public OutputSAXParserStream(OutputSAXParser op) {
        this.op = op;
    }

    @Override
    public void write(int b) throws IOException {
        byte[] oneByte = new byte[]{(byte)b};
        this.write(oneByte, 0, 1);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        try {
            this.op.write(b, off, len);
        }
        catch (SAXException se) {
            IOException toThrow = new IOException(OutputSAXParserStream.getMessage(se));
            toThrow.initCause(se);
            throw toThrow;
        }
    }

    @Override
    public void close() throws IOException {
        if (this.op == null) {
            return;
        }
        try {
            this.op.close();
            this.op = null;
        }
        catch (SAXException se) {
            IOException toThrow = new IOException(OutputSAXParserStream.getMessage(se));
            toThrow.initCause(se);
            throw toThrow;
        }
    }

    public static String getMessage(SAXException se) {
        if (!(se instanceof SAXParseException)) {
            return se.getMessage();
        }
        SAXParseException spe = (SAXParseException)se;
        StringBuilder sb = new StringBuilder();
        OutputSAXParserStream.append(sb, "publicId", spe.getPublicId());
        OutputSAXParserStream.append(sb, "systemId", spe.getSystemId());
        if (spe.getLineNumber() >= 0) {
            OutputSAXParserStream.append(sb, "lineNumber", Integer.toString(spe.getLineNumber()));
        }
        if (spe.getColumnNumber() >= 0) {
            OutputSAXParserStream.append(sb, "columnNumber", Integer.toString(spe.getColumnNumber()));
        }
        OutputSAXParserStream.append(sb, null, spe.getMessage());
        return sb.toString();
    }

    private static void append(StringBuilder sb, String label, String value) {
        if (value == null) {
            return;
        }
        if (sb.length() > 0) {
            sb.append("; ");
        }
        if (label != null) {
            sb.append(label).append(": ");
        }
        sb.append(value);
    }
}

