/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.util.xml;

import de.businesslogics.util.StringUtils;
import de.businesslogics.util.xml.ByteOrderMarkDetector;
import de.businesslogics.util.xml.CharMode;
import de.businesslogics.util.xml.EmptyUriException;
import de.businesslogics.util.xml.EncodingMismatchException;
import de.businesslogics.util.xml.FixedRuleMissingException;
import de.businesslogics.util.xml.GarbageAtEndException;
import de.businesslogics.util.xml.InvalidAttributeException;
import de.businesslogics.util.xml.InvalidPrefixException;
import de.businesslogics.util.xml.MalformedInputException;
import de.businesslogics.util.xml.MisplacedXmlDeclarationException;
import de.businesslogics.util.xml.MyLocator;
import de.businesslogics.util.xml.OutputSAXAttributes;
import de.businesslogics.util.xml.OutputSAXListener;
import de.businesslogics.util.xml.PrefixMapping;
import de.businesslogics.util.xml.RuleMissingException;
import de.businesslogics.util.xml.SAXPointException;
import de.businesslogics.util.xml.SourceInterval;
import de.businesslogics.util.xml.UndefinedEncodingException;
import de.businesslogics.util.xml.UndefinedEntityException;
import de.businesslogics.util.xml.UndefinedPrefixException;
import de.businesslogics.util.xml.UnexpectedElementEndException;
import de.businesslogics.util.xml.UnexpectedEndOfFileException;
import de.businesslogics.util.xml.UnmappableException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class OutputSAXParser
extends MyLocator
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final int MIN_LENGTH = 1;
    private static final boolean debug = false;
    private Rule rule = new Document_Rule(this);
    private String explicitEncoding = null;
    private CharsetDecoder decoder = null;
    private final char[] buffer = new char[4096];
    private final CharBuffer charBuffer = CharBuffer.wrap(this.buffer);
    final ByteBuffer byteBuffer = ByteBuffer.allocate(4096);
    final MyLocator decodeLocator = new MyLocator();
    private ByteOrderMarkDetector bomd = new ByteOrderMarkDetector();
    private final StringBuilder sb = new StringBuilder();
    private boolean waitForEncoding = true;
    private boolean closed = false;
    private OutputSAXListener listener = new OutputSAXListener();
    private CharMode mode = CharMode.Plain;
    private boolean fatalError = false;
    private String currentElement;
    private String attributeName;
    private String attributeValue;
    final MyLocator elementNameStart = new MyLocator();
    private final MyLocator elementStart = new MyLocator();
    private final MyLocator elementEnd = new MyLocator();
    private final MyLocator attributeNameStart = new MyLocator();
    private final MyLocator attributeNameEnd = new MyLocator();
    private final MyLocator attributeValueStart = new MyLocator();
    private final MyLocator attributeValueEnd = new MyLocator();
    private final OutputSAXAttributes attributes = new OutputSAXAttributes();
    private final List<RawAttribute> rawAttributes = new ArrayList<RawAttribute>(10);
    private final HashMap<String, String> prefixMapping = new HashMap();
    private final Stack<PrefixMapping> mappingStack = new Stack();
    private final Stack<String> elementStack = new Stack();
    private ContentHandler contentHandler;
    private boolean forceUTF8 = false;
    ErrorHandler errorHandler = new ErrorHandler(this){

        @Override
        public void warning(SAXParseException exception) throws SAXException {
            throw exception;
        }

        @Override
        public void error(SAXParseException exception) throws SAXException {
            throw exception;
        }

        @Override
        public void fatalError(SAXParseException exception) throws SAXException {
            throw exception;
        }
    };

    public void setContentHandler(ContentHandler contentHandler) throws SAXException {
        this.contentHandler = contentHandler;
        contentHandler.setDocumentLocator(this);
        contentHandler.startDocument();
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    private void sendToRule() throws SAXException {
        this.charBuffer.flip();
        while (this.charBuffer.remaining() > 0 && this.rule != null) {
            this.rule.write(this.charBuffer);
        }
    }

    public void close() throws SAXException {
        CoderResult cr;
        if (this.closed) {
            return;
        }
        this.closed = true;
        do {
            cr = this.decoder.decode(ByteBuffer.allocate(0), this.charBuffer, true);
            this.decoder.flush(this.charBuffer);
            if (cr.isError()) {
                try {
                    cr.throwException();
                }
                catch (Exception e) {
                    throw new SAXException(e);
                }
            }
            this.charBuffer.append('\uffff');
            this.sendToRule();
            if (this.charBuffer.remaining() > 1) {
                throw new SAXException("Unexpected characters at end of file");
            }
            this.listener.endDocument();
        } while (cr.isOverflow());
        if (this.rule != null) {
            throw new UnexpectedEndOfFileException("Open rules:" + this.rule.getNameStack(), this);
        }
        if (this.contentHandler != null) {
            this.contentHandler.endDocument();
        }
    }

    String getUri(String prefix, MyLocator locator) throws SAXException {
        String toReturn = this.prefixMapping.get(prefix);
        if (toReturn != null) {
            return toReturn;
        }
        if (prefix.length() != 0) {
            this.errorHandler.error(new UndefinedPrefixException(prefix, locator));
        }
        return "";
    }

    void openTagStart() {
        this.listener.elementStart();
        this.elementStart.assign(this);
        this.attributes.clear();
        this.rawAttributes.clear();
    }

    /*
     * WARNING - void declaration
     */
    void openTagComplete() throws SAXException {
        String localName;
        this.elementStack.push(this.currentElement);
        for (RawAttribute rawAttribute : this.rawAttributes) {
            if (rawAttribute.name.equals("xmlns")) {
                String oldUri = this.prefixMapping.put("", rawAttribute.value);
                this.mappingStack.push(new PrefixMapping(this.elementStack.size(), "", oldUri));
                if (this.contentHandler == null) continue;
                this.contentHandler.startPrefixMapping("", rawAttribute.value);
                continue;
            }
            if (!rawAttribute.name.startsWith("xmlns:")) continue;
            String ns = rawAttribute.name.substring(6);
            if (ns != null && ns.trim().length() == 0) {
                this.errorHandler.error(new UndefinedPrefixException("''", rawAttribute.nameEnd));
            }
            if (ns != null && ns.startsWith("xmlns")) {
                this.errorHandler.error(new InvalidPrefixException("'xmlns'", rawAttribute.nameStart));
            }
            if (rawAttribute.value.length() == 0) {
                this.errorHandler.error(new EmptyUriException(rawAttribute.valueStart));
            }
            String oldUri = this.prefixMapping.put(ns, rawAttribute.value);
            this.mappingStack.push(new PrefixMapping(this.elementStack.size(), ns, oldUri));
            if (this.contentHandler == null) continue;
            this.contentHandler.startPrefixMapping(ns, rawAttribute.value);
        }
        HashSet<String> s = new HashSet<String>();
        for (RawAttribute ra : this.rawAttributes) {
            String aUri;
            String aLocalName;
            if (s.contains(ra.name)) {
                this.errorHandler.error(new InvalidAttributeException(ra.name, ra.nameStart));
            }
            s.add(ra.name);
            if (ra.name.equals("xmlns") || ra.name.startsWith("xmlns:")) continue;
            int i = ra.name.indexOf(58);
            if (i > 0) {
                String aPrefix = ra.name.substring(0, i);
                aLocalName = ra.name.substring(i + 1);
                aUri = this.getUri(aPrefix, ra.nameStart);
            } else {
                aLocalName = ra.name;
                aUri = "";
            }
            this.attributes.addAttribute(aUri, aLocalName, ra.name, ra.value, new SourceInterval(ra.nameStart.getAbsPosition(), ra.nameEnd.getAbsPosition()), new SourceInterval(ra.valueStart.getAbsPosition(), ra.valueEnd.getAbsPosition()));
        }
        int i = this.currentElement.indexOf(58);
        if (i > 0) {
            MyLocator tmpLocator = new MyLocator(this.elementStart);
            tmpLocator.advance('<');
            localName = this.currentElement.substring(i + 1);
            String string = this.getUri(this.currentElement.substring(0, i), tmpLocator);
        } else {
            localName = this.currentElement;
            String string = this.getUri("", this.elementStart);
        }
        this.elementEnd.assign(this);
        if (this.contentHandler != null) {
            void var2_7;
            this.contentHandler.startElement((String)var2_7, localName, this.currentElement, this.attributes);
        }
        this.attributes.clear();
        this.rawAttributes.clear();
    }

    String getExpectecdEndOrSb() {
        String expectedEnd;
        if (!this.elementStack.isEmpty() && (expectedEnd = this.elementStack.peek()).contentEquals(this.sb)) {
            this.sb.setLength(0);
            return expectedEnd;
        }
        return this.clearSb();
    }

    void elementDone(String elementName) throws SAXException {
        String uri;
        String localName;
        int i;
        String expectedEnd;
        this.listener.elementEnd();
        if (elementName == null) {
            elementName = "";
        }
        String string = expectedEnd = this.elementStack.isEmpty() ? "" : this.elementStack.pop();
        if (!expectedEnd.equals(elementName)) {
            this.errorHandler.error(new UnexpectedElementEndException(elementName, expectedEnd, this));
            int ss = this.elementStack.size();
            while (--ss >= 0 && !((String)this.elementStack.get(ss)).equals(elementName)) {
            }
            if (ss < 0) {
                return;
            }
            while (!(expectedEnd = this.elementStack.peek()).equals(elementName)) {
                this.elementDone(expectedEnd);
            }
            this.elementStack.pop();
        }
        if ((i = elementName.indexOf(58)) > 0) {
            localName = elementName.substring(i + 1);
            uri = this.getUri(elementName.substring(0, i), this.elementStart);
        } else {
            localName = elementName;
            uri = this.getUri("", this.elementStart);
        }
        if (this.contentHandler != null) {
            this.contentHandler.endElement(uri, localName, elementName);
        }
        int level = this.elementStack.size();
        while (!this.mappingStack.isEmpty() && this.mappingStack.peek().level > level) {
            PrefixMapping pm = this.mappingStack.pop();
            if (this.contentHandler != null) {
                this.contentHandler.endPrefixMapping(pm.prefix);
            }
            if (pm.oldMapping != null) {
                this.prefixMapping.put(pm.prefix, pm.oldMapping);
                continue;
            }
            this.prefixMapping.remove(pm.prefix);
        }
    }

    void addAttribute() {
        this.rawAttributes.add(new RawAttribute(this.attributeName, this.attributeValue, this.attributeNameStart, this.attributeNameEnd, this.attributeValueStart, this.attributeValueEnd));
    }

    public void setListener(OutputSAXListener listener) {
        this.listener = listener;
    }

    public void write(byte[] content, int offset, int length) throws SAXException {
        while (length > 0) {
            CoderResult cr;
            if (this.decoder == null) {
                --length;
                if (this.bomd.nextByte(content[offset++])) continue;
                this.decoder = this.bomd.getFound().newDecoder();
                ByteOrderMarkDetector.BOM bom = this.bomd.getBomFound();
                if (bom != null) {
                    this.listener.bomFound(bom.header);
                }
                byte[] b = this.bomd.getReplay();
                this.bomd = null;
                this.write(b, 0, b.length);
                continue;
            }
            if (this.waitForEncoding) {
                this.byteBuffer.put(content, offset, 1);
                --length;
                ++offset;
            } else {
                int i = this.byteBuffer.remaining();
                if (i > length) {
                    i = length;
                }
                this.byteBuffer.put(content, offset, i);
                length -= i;
                offset += i;
            }
            this.byteBuffer.flip();
            do {
                int oldPosition = this.charBuffer.position();
                cr = this.decoder.decode(this.byteBuffer, this.charBuffer, false);
                this.decodeLocator.advance(this.charBuffer, oldPosition, this.charBuffer.position());
                if (this.fatalError) {
                    this.charBuffer.flip();
                    this.listener.ejectUnparsedTail(this.charBuffer);
                    this.charBuffer.clear();
                    continue;
                }
                if (cr.isError()) {
                    byte[] errorBytes = new byte[cr.length()];
                    this.byteBuffer.get(errorBytes);
                    SAXPointException se = cr.isMalformed() ? new MalformedInputException(errorBytes, this.decodeLocator) : new UnmappableException(errorBytes, this.decodeLocator);
                    this.errorHandler.error(se);
                    this.charBuffer.put('.');
                    this.decodeLocator.advance('.');
                }
                this.charBuffer.flip();
                try {
                    int oldRemaining;
                    while ((oldRemaining = this.charBuffer.remaining()) > 1) {
                        Rule oldRule = this.rule;
                        this.rule.write(this.charBuffer);
                        if (oldRemaining == this.charBuffer.remaining() && oldRule == this.rule) break;
                        if (this.rule != null) continue;
                        throw new GarbageAtEndException("Unexpected characters at end of file", this);
                    }
                    this.charBuffer.compact();
                }
                catch (SAXParseException se) {
                    this.errorHandler.fatalError(se);
                    this.fatalError = true;
                    this.waitForEncoding = false;
                    this.decoder.onMalformedInput(CodingErrorAction.REPLACE);
                    this.decoder.onUnmappableCharacter(CodingErrorAction.REPLACE);
                    this.decoder.replaceWith(".");
                    this.listener.ejectUnparsedTail(this.charBuffer);
                    this.charBuffer.clear();
                }
            } while (cr.isOverflow());
            this.byteBuffer.compact();
        }
    }

    void charactersToSb(int i) {
        this.sb.append(this.charBuffer, 0, i);
        int pos = this.charBuffer.position();
        this.listener.characters(this.buffer, pos, i);
        this.advance(this.buffer, pos, i += pos);
        this.charBuffer.position(i);
    }

    void charactersSkip(int i) {
        int pos = this.charBuffer.position();
        this.listener.characters(this.buffer, pos, i);
        this.advance(this.buffer, pos, i += pos);
        this.charBuffer.position(i);
    }

    void charactersSkipNoNL(int i) {
        int pos = this.charBuffer.position();
        this.listener.characters(this.buffer, pos, i);
        this.advanceChars(i);
        this.charBuffer.position(i + pos);
    }

    String clearSb() {
        String toReturn = this.sb.toString();
        this.sb.setLength(0);
        return toReturn;
    }

    public CharMode setMode(CharMode mode) {
        CharMode toReturn = this.mode;
        this.listener.mode(mode);
        this.mode = mode;
        return toReturn;
    }

    public boolean isForceUTF8() {
        return this.forceUTF8;
    }

    public void setForceUTF8(boolean forceUTF8) {
        this.forceUTF8 = forceUTF8;
    }

    void checkEncoding() throws SAXParseException {
        this.waitForEncoding = false;
        if (this.forceUTF8 && !StandardCharsets.UTF_8.equals(this.decoder.charset())) {
            throw new SAXParseException("Expected UTF-8 encoding", this);
        }
    }

    public String getExplicitEncoding() {
        return this.explicitEncoding;
    }

    public MyLocator getElementNameStart() {
        return this.elementNameStart;
    }

    public MyLocator getElementStart() {
        return this.elementStart;
    }

    public SourceInterval getElementTagLocation() {
        return new SourceInterval(this.elementStart.getAbsPosition(), this.elementEnd.getAbsPosition());
    }

    private static class Document_Rule
    extends SequenceRule {
        private static final long serialVersionUID = 1L;

        Document_Rule(OutputSAXParser parser) {
            this.setParser(parser);
            this.add(new OptionalRule(new Prolog_Rule()));
            this.add(new Element_Rule());
            this.add(new OptionalManyRule(new Misc_Rule()));
        }
    }

    static abstract class Rule
    implements Serializable {
        Rule parentRule;
        Rule returnRule;
        OutputSAXParser parser;
        private static final long serialVersionUID = 1L;

        protected Rule() {
        }

        abstract void write(CharBuffer var1) throws SAXException;

        abstract int matches(CharBuffer var1);

        void setParser(OutputSAXParser parser) {
            this.parser = parser;
        }

        OutputSAXParser getParser() {
            return this.parser;
        }

        String getName() {
            return this.getClass().getCanonicalName().substring(43);
        }

        public String getNameStack() {
            StringBuilder sb = new StringBuilder();
            Rule r = this;
            while (r != null) {
                sb.append("\n\t").append(r.getName());
                r = r.parentRule;
            }
            return sb.toString();
        }

        void setReturnRule(Rule returnRule) {
            this.returnRule = returnRule;
        }

        Rule start() {
            return this;
        }

        protected void completed() throws SAXException {
            this.parser.rule = this.returnRule;
        }
    }

    private static class RawAttribute {
        final String name;
        final String value;
        final MyLocator nameStart;
        final MyLocator nameEnd;
        final MyLocator valueStart;
        final MyLocator valueEnd;

        public RawAttribute(String name, String value, MyLocator nameStart, MyLocator nameEnd, MyLocator valueStart, MyLocator valueEnd) {
            this.name = name;
            this.value = value;
            this.nameStart = new MyLocator(nameStart);
            this.nameEnd = new MyLocator(nameEnd);
            this.valueStart = new MyLocator(valueStart);
            this.valueEnd = new MyLocator(valueEnd);
        }
    }

    private static class S_Rule
    extends Rule {
        private static final long serialVersionUID = 1L;

        private S_Rule() {
        }

        @Override
        void write(CharBuffer buffer) throws SAXException {
            int i;
            int r = buffer.remaining();
            for (i = 0; i < r && S_Rule.matches(buffer.charAt(i)); ++i) {
            }
            OutputSAXParser p = this.getParser();
            if (i > 0) {
                p.charactersSkip(i);
            }
            if (i < r) {
                this.completed();
            }
        }

        @Override
        int matches(CharBuffer buffer) {
            return S_Rule.matches(buffer.charAt(0)) ? 1 : 0;
        }

        private static boolean matches(char c) {
            return c == '\t' || c == '\n' || c == '\r' || c == ' ';
        }
    }

    private static class Reference_Rule
    extends OrRule {
        private static final long serialVersionUID = 1L;

        Reference_Rule() {
            this.add(new CharRef_Rule());
            this.add(new EntityRef_Rule());
        }

        @Override
        int matches(CharBuffer buffer) {
            char c = buffer.charAt(0);
            if (c != '&') {
                return 0;
            }
            if (buffer.remaining() < 2) {
                return -1;
            }
            c = buffer.charAt(1);
            this.theRule = c == '#' ? (Rule)this.rules.get(0) : (Rule)this.rules.get(1);
            return this.theRule.matches(buffer);
        }
    }

    private static class EntityRef_Rule
    extends SequenceRule {
        private static final long serialVersionUID = 1L;
        private static final Map<String, Character> ENTITIES = new HashMap<String, Character>();

        EntityRef_Rule() {
            this.add(new FixedRule("&"));
            this.add(new EntityName_Rule());
            this.add(new FixedRule(";"));
        }

        static {
            ENTITIES.put("amp", Character.valueOf('&'));
            ENTITIES.put("apos", Character.valueOf('\''));
            ENTITIES.put("gt", Character.valueOf('>'));
            ENTITIES.put("lt", Character.valueOf('<'));
            ENTITIES.put("quot", Character.valueOf('\"'));
        }

        private class EntityName_Rule
        extends Name_Rule {
            private static final long serialVersionUID = 1L;
            private final MyLocator entityNameLocator = new MyLocator();
            private final char[] oneChar = new char[1];

            private EntityName_Rule() {
            }

            @Override
            Rule start() {
                this.parser.sb.setLength(0);
                this.entityNameLocator.assign(this.parser);
                return super.start();
            }

            @Override
            protected void completed() throws SAXException {
                super.completed();
                String entityName = this.parser.clearSb();
                Character entity = ENTITIES.get(entityName);
                if (entity == null) {
                    UndefinedEntityException uee = new UndefinedEntityException(entityName, this.entityNameLocator);
                    this.parser.errorHandler.error(uee);
                } else {
                    this.oneChar[0] = entity.charValue();
                    this.parser.contentHandler.characters(this.oneChar, 0, 1);
                }
            }
        }
    }

    private static class Element_Rule
    extends SequenceRule {
        private static final long serialVersionUID = 1L;
        private final Content_Rule contentRule = new Content_Rule();
        private int level = 0;

        Element_Rule() {
            this.add(new ElementStartRule());
            this.add(new ElementNameRule());
            this.add(new OptionalManyRule(new STag_Rule2()));
            OrRule or = new OrRule(){
                private static final long serialVersionUID = 1L;

                @Override
                int matches(CharBuffer buffer) {
                    char c = buffer.charAt(0);
                    if (c == '/') {
                        this.theRule = (Rule)this.rules.get(0);
                    } else if (c == '>') {
                        this.theRule = (Rule)this.rules.get(1);
                    } else {
                        return 0;
                    }
                    return this.theRule.matches(buffer);
                }
            };
            or.add(new EmptyElementEndRule());
            or.add(new Element_content());
            this.add(or);
            this.contentRule.setElementRule(this);
        }

        @Override
        Rule start() {
            ++this.level;
            OutputSAXParser p = this.getParser();
            p.openTagStart();
            return super.start();
        }

        @Override
        protected void completed() throws SAXException {
            --this.level;
            if (this.level == 0) {
                super.completed();
            } else {
                this.parser.rule = this.contentRule.returnRule;
                this.pos = 4;
            }
        }

        private static class ElementStartRule
        extends Rule {
            private static final long serialVersionUID = 1L;

            private ElementStartRule() {
            }

            @Override
            void write(CharBuffer buffer) throws SAXException {
                this.parser.charactersSkipNoNL(1);
                this.completed();
            }

            @Override
            int matches(CharBuffer buffer) {
                if ('<' != buffer.charAt(0)) {
                    return 0;
                }
                if (buffer.remaining() < 2) {
                    return -1;
                }
                char c = buffer.charAt(1);
                return c != '!' && c != '/' ? 1 : 0;
            }
        }

        private static class ElementNameRule
        extends Name_Rule {
            private static final long serialVersionUID = 1L;
            private CharMode oldMode;

            private ElementNameRule() {
            }

            @Override
            Rule start() {
                this.oldMode = this.getParser().setMode(CharMode.ElementName);
                this.parser.sb.setLength(0);
                this.parser.elementNameStart.assign(this.parser);
                return super.start();
            }

            @Override
            protected void completed() throws SAXException {
                super.completed();
                this.parser.currentElement = this.parser.clearSb();
                this.parser.setMode(this.oldMode);
            }
        }

        private static class EmptyElementEndRule
        extends FixedRule {
            private static final long serialVersionUID = 1L;

            EmptyElementEndRule() {
                super("/>");
            }

            @Override
            protected void completed() throws SAXException {
                super.completed();
                OutputSAXParser p = this.getParser();
                p.openTagComplete();
                p.elementDone(p.currentElement);
            }
        }

        private class Element_content
        extends SequenceRule {
            private static final long serialVersionUID = 1L;

            Element_content() {
                this.add(new NonEmptyElementOpenCompleteRule());
                this.add(new OptionalManyRule(Element_Rule.this.contentRule));
                this.add(new ETag_Rule());
            }

            @Override
            protected void completed() throws SAXException {
                super.completed();
                this.pos = 1;
            }
        }

        private static class ETag_Rule
        extends SequenceRule {
            private static final long serialVersionUID = 1L;

            ETag_Rule() {
                this.add(new FixedRule("</"));
                this.add(new ClosingElementNameRule());
                this.add(new OptionalRule(new S_Rule()));
                this.add(new FixedRule(">"));
            }

            @Override
            Rule start() {
                this.parser.elementStart.assign(this.parser);
                this.parser.listener.contentEnd();
                return super.start();
            }

            @Override
            protected void completed() throws SAXException {
                super.completed();
                this.parser.elementEnd.assign(this.parser);
                this.parser.elementDone(this.parser.currentElement);
            }
        }

        private static class NonEmptyElementOpenCompleteRule
        extends FixedRule {
            private static final long serialVersionUID = 1L;

            NonEmptyElementOpenCompleteRule() {
                super(">");
            }

            @Override
            protected void completed() throws SAXException {
                super.completed();
                this.parser.listener.contentStart();
                this.parser.openTagComplete();
            }
        }

        private static class ClosingElementNameRule
        extends Name_Rule {
            private static final long serialVersionUID = 1L;
            private CharMode oldMode;

            private ClosingElementNameRule() {
            }

            @Override
            Rule start() {
                this.oldMode = this.getParser().setMode(CharMode.ElementName);
                this.parser.sb.setLength(0);
                this.parser.elementNameStart.assign(this.parser);
                return super.start();
            }

            @Override
            protected void completed() throws SAXException {
                super.completed();
                this.parser.currentElement = this.parser.getExpectecdEndOrSb();
                this.parser.setMode(this.oldMode);
            }
        }
    }

    private static class Content_Rule
    extends OrRule {
        private static final long serialVersionUID = 1L;
        final CharData_Rule cdr = new CharData_Rule();
        final CDSect_Rule cdata = new CDSect_Rule();
        final Comment_Rule cmr = new Comment_Rule();
        final Reference_Rule rr = new Reference_Rule();
        Element_Rule er;

        Content_Rule() {
            this.add(this.cdr);
            this.add(this.cdata);
            this.add(this.cmr);
            this.add(this.rr);
        }

        @Override
        int matches(CharBuffer buffer) {
            char c = buffer.charAt(0);
            if (c == '<') {
                if (buffer.remaining() < 2) {
                    return -1;
                }
                c = buffer.charAt(1);
                if (c != '!') {
                    this.theRule = this.er;
                    return this.theRule.matches(buffer);
                }
                if (buffer.remaining() < 3) {
                    return -1;
                }
                c = buffer.charAt(2);
                this.theRule = c == '[' ? this.cdata : this.cmr;
                return this.theRule.matches(buffer);
            }
            if (c == '&') {
                this.theRule = this.rr;
                return this.theRule.matches(buffer);
            }
            this.theRule = this.cdr;
            return 1;
        }

        void setElementRule(Element_Rule er) {
            this.add(er);
            this.er = er;
        }
    }

    private static class CharRef_Rule
    extends OrRule {
        private static final long serialVersionUID = 1L;

        CharRef_Rule() {
            this.add(new CharRefHex_Rule());
            this.add(new CharRefDecimal_Rule());
        }

        @Override
        int matches(CharBuffer buffer) {
            char c = buffer.charAt(0);
            if (c != '&') {
                return 0;
            }
            if (buffer.remaining() < 2) {
                return -1;
            }
            c = buffer.charAt(1);
            if (c != '#') {
                return 0;
            }
            if (buffer.remaining() < 3) {
                return -1;
            }
            c = buffer.charAt(2);
            this.theRule = c == 'x' ? (Rule)this.rules.get(0) : (Rule)this.rules.get(1);
            return this.theRule.matches(buffer);
        }

        static class CharRefHex_Rule
        extends SequenceRule {
            private static final long serialVersionUID = 1L;

            CharRefHex_Rule() {
                this.add(new FixedRule("&#x"));
                this.add(new HexDigits_Rule());
                this.add(new FixedRule(";"));
            }

            private static class HexDigits_Rule
            extends CharSequenceRule {
                private static final long serialVersionUID = 1L;
                private final char[] oneChar = new char[1];

                private HexDigits_Rule() {
                }

                @Override
                boolean matches(char c) {
                    return c >= '0' && c <= '9' || c >= 'A' && c <= 'F' || c >= 'a' && c <= 'f';
                }

                @Override
                Rule start() {
                    this.parser.sb.setLength(0);
                    return super.start();
                }

                @Override
                protected void completed() throws SAXException {
                    super.completed();
                    String ref = this.parser.clearSb();
                    this.oneChar[0] = (char)Integer.parseInt(ref, 16);
                    this.parser.contentHandler.characters(this.oneChar, 0, 1);
                }
            }
        }

        static class CharRefDecimal_Rule
        extends SequenceRule {
            private static final long serialVersionUID = 1L;

            CharRefDecimal_Rule() {
                this.add(new FixedRule("&#"));
                this.add(new DecimalDigits_Rule());
                this.add(new FixedRule(";"));
            }

            private static class DecimalDigits_Rule
            extends CharSequenceRule {
                private static final long serialVersionUID = 1L;
                private final char[] oneChar = new char[1];

                private DecimalDigits_Rule() {
                }

                @Override
                boolean matches(char c) {
                    return c >= '0' && c <= '9';
                }

                @Override
                Rule start() {
                    this.parser.sb.setLength(0);
                    return super.start();
                }

                @Override
                protected void completed() throws SAXException {
                    super.completed();
                    String ref = this.parser.clearSb();
                    this.oneChar[0] = (char)Integer.parseInt(ref);
                    this.parser.contentHandler.characters(this.oneChar, 0, 1);
                }
            }
        }
    }

    private static class CharData_Rule
    extends Rule {
        private static final long serialVersionUID = 1L;

        private CharData_Rule() {
        }

        @Override
        int matches(CharBuffer buffer) {
            char c = buffer.charAt(0);
            return c != '&' && c != '<' ? 1 : 0;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        void write(CharBuffer buffer) throws SAXException {
            int matched;
            int r = buffer.remaining();
            int i = buffer.position();
            OutputSAXParser p = this.getParser();
            char[] ch = p.buffer;
            while (r > 0) {
                block7: {
                    --r;
                    char c = ch[i];
                    if (c == ']') {
                        if (r >= 2) {
                            if (ch[i + 1] == ']' && ch[i + 2] == '>') {
                                throw new SAXParseException("The character sequence \"]]>\" must not appear in content unless used to mark the end of a CDATA section.", p);
                            }
                            break block7;
                        } else {
                            r = 0;
                            break;
                        }
                    }
                    if (c == '&' || c == '<') break;
                }
                ++i;
            }
            if ((matched = i - buffer.position()) > 0) {
                p.contentHandler.characters(ch, buffer.position(), matched);
                p.charactersSkip(matched);
            }
            if (r > 0) {
                this.completed();
            }
        }
    }

    private static class STag_Rule2
    extends SequenceRule {
        private static final long serialVersionUID = 1L;

        STag_Rule2() {
            this.add(new S_Rule());
            this.add(new OptionalRule(new Attribute_Rule()));
        }
    }

    private static class Attribute_Rule
    extends SequenceRule {
        private static final long serialVersionUID = 1L;

        Attribute_Rule() {
            this.add(new AttrNameRule());
            this.add(new Eq_Rule());
            this.add(new AttValue_Rule());
        }

        @Override
        protected void completed() throws SAXException {
            super.completed();
            this.parser.addAttribute();
        }

        private static class AttrNameRule
        extends Name_Rule {
            private static final long serialVersionUID = 1L;
            CharMode oldMode;

            private AttrNameRule() {
            }

            @Override
            Rule start() {
                this.oldMode = this.parser.setMode(CharMode.AttributeName);
                this.parser.attributeNameStart.assign(this.parser);
                this.parser.sb.setLength(0);
                return super.start();
            }

            @Override
            protected void completed() throws SAXException {
                super.completed();
                this.parser.setMode(this.oldMode);
                this.parser.attributeNameEnd.assign(this.parser);
                this.parser.attributeName = this.parser.clearSb();
            }
        }
    }

    static class AttValue_Rule
    extends SequenceRule {
        private static final long serialVersionUID = 1L;
        private CharMode oldMode;
        private char delimiter;
        private final StringBuilder value = new StringBuilder();

        AttValue_Rule() {
            this.add(new OpeningValue());
            this.add(new OptionalRule(new ValueRule()));
            this.add(new ClosingValue());
        }

        private class OpeningValue
        extends Rule {
            private static final long serialVersionUID = 1L;

            private OpeningValue() {
            }

            @Override
            protected void completed() throws SAXException {
                AttValue_Rule.this.oldMode = this.parser.setMode(CharMode.AttributeValue);
                AttValue_Rule.this.value.setLength(0);
                this.parser.attributeValueStart.assign(this.parser);
                super.completed();
            }

            @Override
            void write(CharBuffer buffer) throws SAXException {
                this.parser.charactersSkipNoNL(1);
                this.completed();
            }

            @Override
            int matches(CharBuffer buffer) {
                char ch = buffer.charAt(0);
                if (ch != '\'' && ch != '\"') {
                    return 0;
                }
                AttValue_Rule.this.delimiter = ch;
                return 1;
            }
        }

        private class ValueRule
        extends Rule {
            private static final long serialVersionUID = 1L;
            final MyLocator referenceLocator = new MyLocator();

            private ValueRule() {
            }

            @Override
            Rule start() {
                this.referenceLocator.absPosition = 0;
                return super.start();
            }

            @Override
            void write(CharBuffer buffer) throws SAXException {
                int charPos;
                char c;
                int i;
                int r = buffer.limit();
                OutputSAXParser p = this.getParser();
                char[] ch = p.buffer;
                for (i = charPos = buffer.position(); i < r && this.matches(c = ch[i]); ++i) {
                    if (this.referenceLocator.absPosition == 0) {
                        if (c == '&') {
                            this.referenceLocator.assign(p);
                            this.referenceLocator.absPosition += i;
                            p.sb.setLength(0);
                        } else {
                            AttValue_Rule.this.value.append(c);
                        }
                    } else if (c == ';') {
                        String ref = p.clearSb();
                        if (ref.length() > 1 && ref.charAt(0) == '#') {
                            try {
                                char myChar = ref.length() > 2 && ref.charAt(1) == 'x' ? (char)Integer.parseInt(ref.substring(2), 16) : (char)Integer.parseInt(ref.substring(1));
                                AttValue_Rule.this.value.append(myChar);
                            }
                            catch (NumberFormatException nfe) {
                                this.parser.errorHandler.error(new SAXParseException("Invalid character reference: " + ref, this.referenceLocator));
                            }
                        } else {
                            Character entity = EntityRef_Rule.ENTITIES.get(ref);
                            if (entity == null) {
                                UndefinedEntityException uee = new UndefinedEntityException(ref, this.referenceLocator);
                                this.parser.errorHandler.error(uee);
                            } else {
                                AttValue_Rule.this.value.append(entity.charValue());
                            }
                        }
                        this.referenceLocator.absPosition = 0;
                    } else {
                        p.sb.append(c);
                    }
                    if (c == '\n') {
                        p.columnNumber = 1;
                        ++p.lineNumber;
                        continue;
                    }
                    ++p.columnNumber;
                }
                int matched = i - charPos;
                if (matched > 0) {
                    p.absPosition += matched;
                    p.listener.characters(p.buffer, charPos, matched);
                    buffer.position(i);
                }
                if (i < r) {
                    this.completed();
                }
            }

            @Override
            int matches(CharBuffer buffer) {
                return this.matches(buffer.charAt(0)) ? 1 : 0;
            }

            boolean matches(char c) {
                return c != AttValue_Rule.this.delimiter && c != '<';
            }

            @Override
            protected void completed() throws SAXException {
                if (this.referenceLocator.absPosition > 0) {
                    this.parser.errorHandler.error(new SAXParseException("Reference must end with ';'", this.referenceLocator));
                }
                super.completed();
            }
        }

        class ClosingValue
        extends Rule {
            private static final long serialVersionUID = 1L;

            ClosingValue() {
            }

            @Override
            Rule start() {
                this.parser.attributeValue = AttValue_Rule.this.value.toString();
                this.parser.attributeValueEnd.assign(this.parser);
                this.parser.setMode(AttValue_Rule.this.oldMode);
                return super.start();
            }

            @Override
            void write(CharBuffer buffer) throws SAXException {
                this.parser.charactersSkipNoNL(1);
                this.completed();
            }

            @Override
            int matches(CharBuffer buffer) {
                return AttValue_Rule.this.delimiter == buffer.charAt(0) ? 1 : 0;
            }

            public String getDelimiter() {
                return Character.toString(AttValue_Rule.this.delimiter);
            }
        }
    }

    private static class Name_Rule
    extends Rule {
        private static final long serialVersionUID = 1L;

        private Name_Rule() {
        }

        @Override
        int matches(CharBuffer buffer) {
            char c = buffer.charAt(0);
            if (c <= '\u00ff') {
                if (c <= 'z') {
                    return c == ':' || c >= 'A' && c <= 'Z' || c == '_' || c >= 'a' ? 1 : 0;
                }
                return c >= '\u00c0' && c <= '\u00d6' || c >= '\u00d8' && c <= '\u00f6' || c >= '\u00f8' ? 1 : 0;
            }
            return c >= '\u0100' && c <= '\u0131' || c >= '\u0134' && c <= '\u013e' || c >= '\u0141' && c <= '\u0148' || c >= '\u014a' && c <= '\u017e' || c >= '\u0180' && c <= '\u01c3' || c >= '\u01cd' && c <= '\u01f0' || c >= '\u01f4' && c <= '\u01f5' || c >= '\u01fa' && c <= '\u0217' || c >= '\u0250' && c <= '\u02a8' || c >= '\u02bb' && c <= '\u02c1' || c == '\u0386' || c >= '\u0388' && c <= '\u038a' || c == '\u038c' || c >= '\u038e' && c <= '\u03a1' || c >= '\u03a3' && c <= '\u03ce' || c >= '\u03d0' && c <= '\u03d6' || c == '\u03da' || c == '\u03dc' || c == '\u03de' || c == '\u03e0' || c >= '\u03e2' && c <= '\u03f3' || c >= '\u0401' && c <= '\u040c' || c >= '\u040e' && c <= '\u044f' || c >= '\u0451' && c <= '\u045c' || c >= '\u045e' && c <= '\u0481' || c >= '\u0490' && c <= '\u04c4' || c >= '\u04c7' && c <= '\u04c8' || c >= '\u04cb' && c <= '\u04cc' || c >= '\u04d0' && c <= '\u04eb' || c >= '\u04ee' && c <= '\u04f5' || c >= '\u04f8' && c <= '\u04f9' || c >= '\u0531' && c <= '\u0556' || c == '\u0559' || c >= '\u0561' && c <= '\u0586' || c >= '\u05d0' && c <= '\u05ea' || c >= '\u05f0' && c <= '\u05f2' || c >= '\u0621' && c <= '\u063a' || c >= '\u0641' && c <= '\u064a' || c >= '\u0671' && c <= '\u06b7' || c >= '\u06ba' && c <= '\u06be' || c >= '\u06c0' && c <= '\u06ce' || c >= '\u06d0' && c <= '\u06d3' || c == '\u06d5' || c >= '\u06e5' && c <= '\u06e6' || c >= '\u0905' && c <= '\u0939' || c == '\u093d' || c >= '\u0958' && c <= '\u0961' || c >= '\u0985' && c <= '\u098c' || c >= '\u098f' && c <= '\u0990' || c >= '\u0993' && c <= '\u09a8' || c >= '\u09aa' && c <= '\u09b0' || c == '\u09b2' || c >= '\u09b6' && c <= '\u09b9' || c >= '\u09dc' && c <= '\u09dd' || c >= '\u09df' && c <= '\u09e1' || c >= '\u09f0' && c <= '\u09f1' || c >= '\u0a05' && c <= '\u0a0a' || c >= '\u0a0f' && c <= '\u0a10' || c >= '\u0a13' && c <= '\u0a28' || c >= '\u0a2a' && c <= '\u0a30' || c >= '\u0a32' && c <= '\u0a33' || c >= '\u0a35' && c <= '\u0a36' || c >= '\u0a38' && c <= '\u0a39' || c >= '\u0a59' && c <= '\u0a5c' || c == '\u0a5e' || c >= '\u0a72' && c <= '\u0a74' || c >= '\u0a85' && c <= '\u0a8b' || c == '\u0a8d' || c >= '\u0a8f' && c <= '\u0a91' || c >= '\u0a93' && c <= '\u0aa8' || c >= '\u0aaa' && c <= '\u0ab0' || c >= '\u0ab2' && c <= '\u0ab3' || c >= '\u0ab5' && c <= '\u0ab9' || c == '\u0abd' || c == '\u0ae0' || c >= '\u0b05' && c <= '\u0b0c' || c >= '\u0b0f' && c <= '\u0b10' || c >= '\u0b13' && c <= '\u0b28' || c >= '\u0b2a' && c <= '\u0b30' || c >= '\u0b32' && c <= '\u0b33' || c >= '\u0b36' && c <= '\u0b39' || c == '\u0b3d' || c >= '\u0b5c' && c <= '\u0b5d' || c >= '\u0b5f' && c <= '\u0b61' || c >= '\u0b85' && c <= '\u0b8a' || c >= '\u0b8e' && c <= '\u0b90' || c >= '\u0b92' && c <= '\u0b95' || c >= '\u0b99' && c <= '\u0b9a' || c == '\u0b9c' || c >= '\u0b9e' && c <= '\u0b9f' || c >= '\u0ba3' && c <= '\u0ba4' || c >= '\u0ba8' && c <= '\u0baa' || c >= '\u0bae' && c <= '\u0bb5' || c >= '\u0bb7' && c <= '\u0bb9' || c >= '\u0c05' && c <= '\u0c0c' || c >= '\u0c0e' && c <= '\u0c10' || c >= '\u0c12' && c <= '\u0c28' || c >= '\u0c2a' && c <= '\u0c33' || c >= '\u0c35' && c <= '\u0c39' || c >= '\u0c60' && c <= '\u0c61' || c >= '\u0c85' && c <= '\u0c8c' || c >= '\u0c8e' && c <= '\u0c90' || c >= '\u0c92' && c <= '\u0ca8' || c >= '\u0caa' && c <= '\u0cb3' || c >= '\u0cb5' && c <= '\u0cb9' || c == '\u0cde' || c >= '\u0ce0' && c <= '\u0ce1' || c >= '\u0d05' && c <= '\u0d0c' || c >= '\u0d0e' && c <= '\u0d10' || c >= '\u0d12' && c <= '\u0d28' || c >= '\u0d2a' && c <= '\u0d39' || c >= '\u0d60' && c <= '\u0d61' || c >= '\u0e01' && c <= '\u0e2e' || c == '\u0e30' || c >= '\u0e32' && c <= '\u0e33' || c >= '\u0e40' && c <= '\u0e45' || c >= '\u0e81' && c <= '\u0e82' || c == '\u0e84' || c >= '\u0e87' && c <= '\u0e88' || c == '\u0e8a' || c == '\u0e8d' || c >= '\u0e94' && c <= '\u0e97' || c >= '\u0e99' && c <= '\u0e9f' || c >= '\u0ea1' && c <= '\u0ea3' || c == '\u0ea5' || c == '\u0ea7' || c >= '\u0eaa' && c <= '\u0eab' || c >= '\u0ead' && c <= '\u0eae' || c == '\u0eb0' || c >= '\u0eb2' && c <= '\u0eb3' || c == '\u0ebd' || c >= '\u0ec0' && c <= '\u0ec4' || c >= '\u0f40' && c <= '\u0f47' || c >= '\u0f49' && c <= '\u0f69' || c >= '\u10a0' && c <= '\u10c5' || c >= '\u10d0' && c <= '\u10f6' || c == '\u1100' || c >= '\u1102' && c <= '\u1103' || c >= '\u1105' && c <= '\u1107' || c == '\u1109' || c >= '\u110b' && c <= '\u110c' || c >= '\u110e' && c <= '\u1112' || c == '\u113c' || c == '\u113e' || c == '\u1140' || c == '\u114c' || c == '\u114e' || c == '\u1150' || c >= '\u1154' && c <= '\u1155' || c == '\u1159' || c >= '\u115f' && c <= '\u1161' || c == '\u1163' || c == '\u1165' || c == '\u1167' || c == '\u1169' || c >= '\u116d' && c <= '\u116e' || c >= '\u1172' && c <= '\u1173' || c == '\u1175' || c == '\u119e' || c == '\u11a8' || c == '\u11ab' || c >= '\u11ae' && c <= '\u11af' || c >= '\u11b7' && c <= '\u11b8' || c == '\u11ba' || c >= '\u11bc' && c <= '\u11c2' || c == '\u11eb' || c == '\u11f0' || c == '\u11f9' || c >= '\u1e00' && c <= '\u1e9b' || c >= '\u1ea0' && c <= '\u1ef9' || c >= '\u1f00' && c <= '\u1f15' || c >= '\u1f18' && c <= '\u1f1d' || c >= '\u1f20' && c <= '\u1f45' || c >= '\u1f48' && c <= '\u1f4d' || c >= '\u1f50' && c <= '\u1f57' || c == '\u1f59' || c == '\u1f5b' || c == '\u1f5d' || c >= '\u1f5f' && c <= '\u1f7d' || c >= '\u1f80' && c <= '\u1fb4' || c >= '\u1fb6' && c <= '\u1fbc' || c == '\u1fbe' || c >= '\u1fc2' && c <= '\u1fc4' || c >= '\u1fc6' && c <= '\u1fcc' || c >= '\u1fd0' && c <= '\u1fd3' || c >= '\u1fd6' && c <= '\u1fdb' || c >= '\u1fe0' && c <= '\u1fec' || c >= '\u1ff2' && c <= '\u1ff4' || c >= '\u1ff6' && c <= '\u1ffc' || c == '\u2126' || c >= '\u212a' && c <= '\u212b' || c == '\u212e' || c >= '\u2180' && c <= '\u2182' || c == '\u3007' || c >= '\u3021' && c <= '\u3029' || c >= '\u3041' && c <= '\u3094' || c >= '\u30a1' && c <= '\u30fa' || c >= '\u3105' && c <= '\u312c' || c >= '\u4e00' && c <= '\u9fa5' || c >= '\uac00' && c <= '\ud7a3' ? 1 : 0;
        }

        @Override
        Rule start() {
            this.parser.charactersToSb(1);
            return super.start();
        }

        @Override
        void write(CharBuffer buffer) throws SAXException {
            int pos;
            int i;
            int l = buffer.limit();
            char[] buf = this.parser.buffer;
            for (i = pos = buffer.position(); i < l && Name_Rule.isName2Char(buf[i]); ++i) {
            }
            int consumed = i - buffer.position();
            if (consumed > 0) {
                this.parser.absPosition += consumed;
                this.parser.columnNumber += consumed;
                this.parser.sb.append(buf, pos, consumed);
                this.parser.listener.characters(buf, pos, consumed);
                buffer.position(i);
            }
            if (i < l) {
                this.completed();
            }
        }

        private static boolean isName2Char(char c) {
            if (c <= '\u00ff') {
                if (c <= 'z') {
                    return c >= 'a' || c >= 'A' && c <= 'Z' || c >= '0' && c <= ':' || c == '.' || c == '_' || c == '-';
                }
                return c == '\u00b7' || c >= '\u00c0' && c <= '\u00d6' || c >= '\u00d8' && c <= '\u00f6' || c >= '\u00f8';
            }
            return c >= '\u0100' && c <= '\u0131' || c >= '\u0134' && c <= '\u013e' || c >= '\u0141' && c <= '\u0148' || c >= '\u014a' && c <= '\u017e' || c >= '\u0180' && c <= '\u01c3' || c >= '\u01cd' && c <= '\u01f0' || c >= '\u01f4' && c <= '\u01f5' || c >= '\u01fa' && c <= '\u0217' || c >= '\u0250' && c <= '\u02a8' || c >= '\u02bb' && c <= '\u02c1' || c == '\u02d0' || c == '\u02d1' || c >= '\u0300' && c <= '\u0345' || c >= '\u0360' && c <= '\u0361' || c >= '\u0386' && c <= '\u038a' || c == '\u038c' || c >= '\u038e' && c <= '\u03a1' || c >= '\u03a3' && c <= '\u03ce' || c >= '\u03d0' && c <= '\u03d6' || c == '\u03da' || c == '\u03dc' || c == '\u03de' || c == '\u03e0' || c >= '\u03e2' && c <= '\u03f3' || c >= '\u0401' && c <= '\u040c' || c >= '\u040e' && c <= '\u044f' || c >= '\u0451' && c <= '\u045c' || c >= '\u045e' && c <= '\u0481' || c >= '\u0483' && c <= '\u0486' || c >= '\u0490' && c <= '\u04c4' || c >= '\u04c7' && c <= '\u04c8' || c >= '\u04cb' && c <= '\u04cc' || c >= '\u04d0' && c <= '\u04eb' || c >= '\u04ee' && c <= '\u04f5' || c >= '\u04f8' && c <= '\u04f9' || c >= '\u0531' && c <= '\u0556' || c == '\u0559' || c >= '\u0561' && c <= '\u0586' || c >= '\u0591' && c <= '\u05a1' || c >= '\u05a3' && c <= '\u05b9' || c >= '\u05bb' && c <= '\u05bd' || c == '\u05bf' || c >= '\u05c1' && c <= '\u05c2' || c == '\u05c4' || c >= '\u05d0' && c <= '\u05ea' || c >= '\u05f0' && c <= '\u05f2' || c >= '\u0621' && c <= '\u063a' || c >= '\u0640' && c <= '\u0652' || c >= '\u0660' && c <= '\u0669' || c >= '\u0670' && c <= '\u06b7' || c >= '\u06ba' && c <= '\u06be' || c >= '\u06c0' && c <= '\u06ce' || c >= '\u06d0' && c <= '\u06d3' || c >= '\u06d5' && c <= '\u06e8' || c >= '\u06ea' && c <= '\u06ed' || c >= '\u06f0' && c <= '\u06f9' || c >= '\u0901' && c <= '\u0903' || c >= '\u0905' && c <= '\u0939' || c >= '\u093c' && c <= '\u094d' || c >= '\u0951' && c <= '\u0954' || c >= '\u0958' && c <= '\u0963' || c >= '\u0966' && c <= '\u096f' || c >= '\u0981' && c <= '\u0983' || c >= '\u0985' && c <= '\u098c' || c >= '\u098f' && c <= '\u0990' || c >= '\u0993' && c <= '\u09a8' || c >= '\u09aa' && c <= '\u09b0' || c == '\u09b2' || c >= '\u09b6' && c <= '\u09b9' || c == '\u09bc' || c >= '\u09be' && c <= '\u09c4' || c >= '\u09c7' && c <= '\u09c8' || c >= '\u09cb' && c <= '\u09cd' || c == '\u09d7' || c >= '\u09e2' && c <= '\u09e3' || c >= '\u09dc' && c <= '\u09dd' || c >= '\u09df' && c <= '\u09e1' || c >= '\u09e6' && c <= '\u09f1' || c == '\u0a02' || c >= '\u0a05' && c <= '\u0a0a' || c >= '\u0a0f' && c <= '\u0a10' || c >= '\u0a13' && c <= '\u0a28' || c >= '\u0a2a' && c <= '\u0a30' || c >= '\u0a32' && c <= '\u0a33' || c >= '\u0a35' && c <= '\u0a36' || c >= '\u0a38' && c <= '\u0a39' || c == '\u0a3c' || c == '\u0a3e' || c == '\u0a3f' || c >= '\u0a40' && c <= '\u0a42' || c >= '\u0a47' && c <= '\u0a48' || c >= '\u0a4b' && c <= '\u0a4d' || c >= '\u0a59' && c <= '\u0a5c' || c == '\u0a5e' || c >= '\u0a66' && c <= '\u0a74' || c >= '\u0a81' && c <= '\u0a83' || c >= '\u0a85' && c <= '\u0a8b' || c == '\u0a8d' || c >= '\u0a8f' && c <= '\u0a91' || c >= '\u0a93' && c <= '\u0aa8' || c >= '\u0aaa' && c <= '\u0ab0' || c >= '\u0ab2' && c <= '\u0ab3' || c >= '\u0ab5' && c <= '\u0ab9' || c >= '\u0abc' && c <= '\u0ac5' || c >= '\u0ac7' && c <= '\u0ac9' || c >= '\u0acb' && c <= '\u0acd' || c == '\u0ae0' || c >= '\u0ae6' && c <= '\u0aef' || c >= '\u0b01' && c <= '\u0b03' || c >= '\u0b05' && c <= '\u0b0c' || c >= '\u0b0f' && c <= '\u0b10' || c >= '\u0b13' && c <= '\u0b28' || c >= '\u0b2a' && c <= '\u0b30' || c >= '\u0b32' && c <= '\u0b33' || c >= '\u0b36' && c <= '\u0b39' || c >= '\u0b3c' && c <= '\u0b43' || c >= '\u0b47' && c <= '\u0b48' || c >= '\u0b4b' && c <= '\u0b4d' || c >= '\u0b56' && c <= '\u0b57' || c >= '\u0b5c' && c <= '\u0b5d' || c >= '\u0b5f' && c <= '\u0b61' || c >= '\u0b66' && c <= '\u0b6f' || c >= '\u0b82' && c <= '\u0b83' || c >= '\u0b85' && c <= '\u0b8a' || c >= '\u0b8e' && c <= '\u0b90' || c >= '\u0b92' && c <= '\u0b95' || c >= '\u0b99' && c <= '\u0b9a' || c == '\u0b9c' || c >= '\u0b9e' && c <= '\u0b9f' || c >= '\u0ba3' && c <= '\u0ba4' || c >= '\u0ba8' && c <= '\u0baa' || c >= '\u0bae' && c <= '\u0bb5' || c >= '\u0bb7' && c <= '\u0bb9' || c >= '\u0bbe' && c <= '\u0bc2' || c >= '\u0bc6' && c <= '\u0bc8' || c >= '\u0bca' && c <= '\u0bcd' || c == '\u0bd7' || c >= '\u0be7' && c <= '\u0bef' || c >= '\u0c01' && c <= '\u0c03' || c >= '\u0c05' && c <= '\u0c0c' || c >= '\u0c0e' && c <= '\u0c10' || c >= '\u0c12' && c <= '\u0c28' || c >= '\u0c2a' && c <= '\u0c33' || c >= '\u0c35' && c <= '\u0c39' || c >= '\u0c3e' && c <= '\u0c44' || c >= '\u0c46' && c <= '\u0c48' || c >= '\u0c4a' && c <= '\u0c4d' || c >= '\u0c55' && c <= '\u0c56' || c >= '\u0c60' && c <= '\u0c61' || c >= '\u0c66' && c <= '\u0c6f' || c >= '\u0c82' && c <= '\u0c83' || c >= '\u0c85' && c <= '\u0c8c' || c >= '\u0c8e' && c <= '\u0c90' || c >= '\u0c92' && c <= '\u0ca8' || c >= '\u0caa' && c <= '\u0cb3' || c >= '\u0cb5' && c <= '\u0cb9' || c >= '\u0cbe' && c <= '\u0cc4' || c >= '\u0cc6' && c <= '\u0cc8' || c >= '\u0cca' && c <= '\u0ccd' || c >= '\u0cd5' && c <= '\u0cd6' || c == '\u0cde' || c >= '\u0ce0' && c <= '\u0ce1' || c >= '\u0ce6' && c <= '\u0cef' || c >= '\u0d02' && c <= '\u0d03' || c >= '\u0d05' && c <= '\u0d0c' || c >= '\u0d0e' && c <= '\u0d10' || c >= '\u0d12' && c <= '\u0d28' || c >= '\u0d2a' && c <= '\u0d39' || c >= '\u0d3e' && c <= '\u0d43' || c >= '\u0d46' && c <= '\u0d48' || c >= '\u0d4a' && c <= '\u0d4d' || c == '\u0d57' || c >= '\u0d60' && c <= '\u0d61' || c >= '\u0d66' && c <= '\u0d6f' || c >= '\u0e01' && c <= '\u0e2e' || c >= '\u0e30' && c <= '\u0e3a' || c >= '\u0e40' && c <= '\u0e4e' || c >= '\u0e50' && c <= '\u0e59' || c >= '\u0e81' && c <= '\u0e82' || c == '\u0e84' || c >= '\u0e87' && c <= '\u0e88' || c == '\u0e8a' || c == '\u0e8d' || c >= '\u0e94' && c <= '\u0e97' || c >= '\u0e99' && c <= '\u0e9f' || c >= '\u0ea1' && c <= '\u0ea3' || c == '\u0ea5' || c == '\u0ea7' || c >= '\u0eaa' && c <= '\u0eab' || c >= '\u0ead' && c <= '\u0eae' || c >= '\u0eb0' && c <= '\u0eb9' || c >= '\u0ebb' && c <= '\u0ebd' || c >= '\u0ec0' && c <= '\u0ec4' || c == '\u0ec6' || c >= '\u0ec8' && c <= '\u0ecd' || c >= '\u0ed0' && c <= '\u0ed9' || c >= '\u0f18' && c <= '\u0f19' || c >= '\u0f20' && c <= '\u0f29' || c == '\u0f35' || c == '\u0f37' || c == '\u0f39' || c >= '\u0f3e' && c <= '\u0f47' || c >= '\u0f49' && c <= '\u0f69' || c >= '\u0f71' && c <= '\u0f84' || c >= '\u0f86' && c <= '\u0f8b' || c >= '\u0f90' && c <= '\u0f95' || c == '\u0f97' || c >= '\u0f99' && c <= '\u0fad' || c >= '\u0fb1' && c <= '\u0fb7' || c == '\u0fb9' || c >= '\u10a0' && c <= '\u10c5' || c >= '\u10d0' && c <= '\u10f6' || c == '\u1100' || c >= '\u1102' && c <= '\u1103' || c >= '\u1105' && c <= '\u1107' || c == '\u1109' || c >= '\u110b' && c <= '\u110c' || c >= '\u110e' && c <= '\u1112' || c == '\u113c' || c == '\u113e' || c == '\u1140' || c == '\u114c' || c == '\u114e' || c == '\u1150' || c >= '\u1154' && c <= '\u1155' || c == '\u1159' || c >= '\u115f' && c <= '\u1161' || c == '\u1163' || c == '\u1165' || c == '\u1167' || c == '\u1169' || c >= '\u116d' && c <= '\u116e' || c >= '\u1172' && c <= '\u1173' || c == '\u1175' || c == '\u119e' || c == '\u11a8' || c == '\u11ab' || c >= '\u11ae' && c <= '\u11af' || c >= '\u11b7' && c <= '\u11b8' || c == '\u11ba' || c >= '\u11bc' && c <= '\u11c2' || c == '\u11eb' || c == '\u11f0' || c == '\u11f9' || c >= '\u1e00' && c <= '\u1e9b' || c >= '\u1ea0' && c <= '\u1ef9' || c >= '\u1f00' && c <= '\u1f15' || c >= '\u1f18' && c <= '\u1f1d' || c >= '\u1f20' && c <= '\u1f45' || c >= '\u1f48' && c <= '\u1f4d' || c >= '\u1f50' && c <= '\u1f57' || c == '\u1f59' || c == '\u1f5b' || c == '\u1f5d' || c >= '\u1f5f' && c <= '\u1f7d' || c >= '\u1f80' && c <= '\u1fb4' || c >= '\u1fb6' && c <= '\u1fbc' || c == '\u1fbe' || c >= '\u1fc2' && c <= '\u1fc4' || c >= '\u1fc6' && c <= '\u1fcc' || c >= '\u1fd0' && c <= '\u1fd3' || c >= '\u1fd6' && c <= '\u1fdb' || c >= '\u1fe0' && c <= '\u1fec' || c >= '\u1ff2' && c <= '\u1ff4' || c >= '\u1ff6' && c <= '\u1ffc' || c >= '\u20d0' && c <= '\u20dc' || c == '\u20e1' || c == '\u2126' || c >= '\u212a' && c <= '\u212b' || c == '\u212e' || c >= '\u2180' && c <= '\u2182' || c == '\u3005' || c == '\u3007' || c >= '\u3021' && c <= '\u302f' || c >= '\u3031' && c <= '\u3035' || c >= '\u3041' && c <= '\u3094' || c == '\u3099' || c == '\u309a' || c >= '\u309d' && c <= '\u309e' || c >= '\u30a1' && c <= '\u30fa' || c >= '\u30fc' && c <= '\u30fe' || c >= '\u3105' && c <= '\u312c' || c >= '\u4e00' && c <= '\u9fa5' || c >= '\uac00' && c <= '\ud7a3';
        }
    }

    private static class Prolog_Rule
    extends SequenceRule {
        private static final long serialVersionUID = 1L;

        Prolog_Rule() {
            this.add(new OptionalRule(new XMLDecl_Rule()));
            this.add(new OptionalManyRule(new Misc_Rule()));
        }
    }

    private static class Misc_Rule
    extends OrRule {
        private static final long serialVersionUID = 1L;

        Misc_Rule() {
            this.add(new Comment_Rule());
            this.add(new PI_Rule());
            this.add(new S_Rule());
        }

        @Override
        int matches(CharBuffer buffer) {
            char c = buffer.charAt(0);
            if (c == '<') {
                if (buffer.remaining() < 2) {
                    return -1;
                }
                c = buffer.charAt(1);
                this.theRule = c == '!' ? (Rule)this.rules.get(0) : (Rule)this.rules.get(1);
            } else {
                this.theRule = (Rule)this.rules.get(2);
            }
            return this.theRule.matches(buffer);
        }
    }

    private static class PI_Rule
    extends SequenceRule {
        private static final long serialVersionUID = 1L;

        PI_Rule() {
            this.add(new FixedRule("<?"));
            this.add(new PITargetRule());
            this.add(new OptionalManyRule(new PIChar_Rule()));
            this.add(new FixedRule("?>"));
        }

        private static class PITargetRule
        extends Name_Rule {
            private static final long serialVersionUID = 1L;

            private PITargetRule() {
            }

            @Override
            Rule start() {
                this.parser.sb.setLength(0);
                return super.start();
            }

            @Override
            protected void completed() throws SAXException {
                super.completed();
                String pitarget = this.parser.clearSb();
                if ("xml".equalsIgnoreCase(pitarget)) {
                    throw new MisplacedXmlDeclarationException(this.parser);
                }
            }
        }

        private static class PIChar_Rule
        extends Rule {
            private static final long serialVersionUID = 1L;

            private PIChar_Rule() {
            }

            @Override
            int matches(CharBuffer buffer) {
                char c = buffer.charAt(0);
                if (c != '?') {
                    return this.matches(c) ? 1 : 0;
                }
                if (buffer.remaining() <= 1) {
                    return -1;
                }
                c = buffer.charAt(1);
                return c != '>' && this.matches(c) ? 2 : 0;
            }

            @Override
            void write(CharBuffer buffer) throws SAXException {
                OutputSAXParser p = this.getParser();
                p.charactersSkipNoNL(1);
                this.completed();
            }

            boolean matches(char c) {
                return c == '\t' || c == '\n' || c == '\r' || c >= ' ' && c <= '\ud7ff' || c >= '\ue000' && c <= '\ufffd' || c >= '\u10000' && c <= '\u10ffff';
            }
        }
    }

    private static class CDSect_Rule
    extends SequenceRule {
        private static final long serialVersionUID = 1L;

        CDSect_Rule() {
            this.add(new FixedRule("<![CDATA["));
            this.add(new OptionalManyRule(new CData_Rule()));
            this.add(new FixedRule("]]>"));
        }

        private static class CData_Rule
        extends Rule {
            private static final long serialVersionUID = 1L;

            private CData_Rule() {
            }

            @Override
            int matches(CharBuffer buffer) {
                char c = buffer.charAt(0);
                if (c != ']') {
                    return 1;
                }
                if (buffer.remaining() <= 2) {
                    return -1;
                }
                return buffer.charAt(1) == ']' && buffer.charAt(2) == '>' ? 0 : 3;
            }

            @Override
            void write(CharBuffer buffer) throws SAXException {
                int matched;
                int r = buffer.remaining();
                int i = buffer.position();
                OutputSAXParser p = this.getParser();
                char[] ch = p.buffer;
                boolean completed = false;
                while (r > 0) {
                    --r;
                    char c = ch[i];
                    if (c == ']') {
                        if (r >= 2) {
                            if (ch[i + 1] == ']' && ch[i + 2] == '>') {
                                completed = true;
                                break;
                            }
                        } else {
                            r = 0;
                            break;
                        }
                    }
                    ++i;
                }
                if ((matched = i - buffer.position()) > 0) {
                    p.contentHandler.characters(ch, buffer.position(), matched);
                    p.charactersSkip(matched);
                }
                if (completed) {
                    this.completed();
                }
            }
        }
    }

    private static class Comment_Rule
    extends SequenceRule {
        private static final long serialVersionUID = 1L;
        private CharMode oldMode;

        Comment_Rule() {
            this.add(new FixedRule("<!--"));
            this.add(new OptionalManyRule(new CommentChar_Rule()));
            this.add(new FixedRule("-->"));
        }

        @Override
        Rule start() {
            this.oldMode = this.getParser().setMode(CharMode.Comment);
            return super.start();
        }

        @Override
        protected void completed() throws SAXException {
            super.completed();
            this.getParser().setMode(this.oldMode);
        }

        private static class CommentChar_Rule
        extends Rule {
            private static final long serialVersionUID = 1L;

            private CommentChar_Rule() {
            }

            @Override
            int matches(CharBuffer buffer) {
                char c = buffer.charAt(0);
                if (c != '-') {
                    return this.matches(c) ? 1 : 0;
                }
                if (buffer.remaining() <= 1) {
                    return -1;
                }
                return this.matches(buffer.charAt(1)) ? 2 : 0;
            }

            @Override
            void write(CharBuffer buffer) throws SAXException {
                OutputSAXParser p = this.getParser();
                p.charactersSkip(1);
                this.completed();
            }

            boolean matches(char c) {
                return c == '\t' || c == '\n' || c == '\r' || c >= ' ' && c <= ',' || c >= '.' && c <= '\ud7ff' || c >= '\ue000' && c <= '\ufffd' || c >= '\u10000' && c <= '\u10ffff';
            }
        }
    }

    private static class XMLDecl_Rule
    extends SequenceRule {
        private static final long serialVersionUID = 1L;

        XMLDecl_Rule() {
            this.add(new FixedRule("<?xml"));
            this.add(new S_Rule());
            this.add(new VersionInfo_Rule());
            this.add(new OptionalRule(new XMLDecl1_Rule()));
            this.add(new FixedRule("?>"));
        }

        @Override
        protected void completed() throws SAXException {
            this.getParser().checkEncoding();
            super.completed();
        }

        private static class XMLDecl1_Rule
        extends SequenceRule {
            private static final long serialVersionUID = 1L;

            XMLDecl1_Rule() {
                this.add(new S_Rule());
                this.add(new OptionalRule(new XMLDecl2_Rule()));
                this.add(new OptionalRule(new S_Rule()));
            }
        }

        private static class XMLDecl4_Rule
        extends SequenceRule {
            private static final long serialVersionUID = 1L;

            XMLDecl4_Rule() {
                this.add(new S_Rule());
                this.add(new OptionalRule(new SDDecl_Rule()));
            }
        }

        private static class XMLDecl3_Rule
        extends SequenceRule {
            private static final long serialVersionUID = 1L;

            XMLDecl3_Rule() {
                this.add(new EncodingDecl_Rule());
                this.add(new OptionalRule(new XMLDecl4_Rule()));
            }
        }

        private static class XMLDecl2_Rule
        extends OrRule {
            private static final long serialVersionUID = 1L;

            XMLDecl2_Rule() {
                this.add(new XMLDecl3_Rule());
                this.add(new SDDecl_Rule());
            }

            @Override
            int matches(CharBuffer buffer) {
                char c = buffer.charAt(0);
                if (c == 'e') {
                    this.theRule = (Rule)this.rules.get(0);
                } else if (c == 's') {
                    this.theRule = (Rule)this.rules.get(1);
                } else {
                    return 0;
                }
                return this.theRule.matches(buffer);
            }
        }
    }

    private static class EncodingDecl_Rule
    extends SequenceRule {
        private static final long serialVersionUID = 1L;

        EncodingDecl_Rule() {
            this.add(new FixedRule("encoding"));
            this.add(new Eq_Rule());
            this.add(new EncodingDecl1_Rule());
        }

        private static class EncodingDecl1_Rule
        extends OrRule {
            private static final long serialVersionUID = 1L;

            EncodingDecl1_Rule() {
                this.add(new EncodingDecl1_2_Rule());
                this.add(new EncodingDecl1_1_Rule());
            }

            @Override
            int matches(CharBuffer buffer) {
                char c = buffer.charAt(0);
                if (c == '\'') {
                    this.theRule = (Rule)this.rules.get(0);
                } else if (c == '\"') {
                    this.theRule = (Rule)this.rules.get(1);
                } else {
                    return 0;
                }
                return this.theRule.matches(buffer);
            }

            private static class EncodingDecl1_2_Rule
            extends SequenceRule {
                private static final long serialVersionUID = 1L;

                EncodingDecl1_2_Rule() {
                    this.add(new FixedRule("'"));
                    this.add(new EncName_Rule());
                    this.add(new FixedRule("'"));
                }
            }

            private static class EncodingDecl1_1_Rule
            extends SequenceRule {
                private static final long serialVersionUID = 1L;

                EncodingDecl1_1_Rule() {
                    this.add(new FixedRule("\""));
                    this.add(new EncName_Rule());
                    this.add(new FixedRule("\""));
                }
            }
        }
    }

    private static class SDDecl_Rule
    extends SequenceRule {
        private static final long serialVersionUID = 1L;

        SDDecl_Rule() {
            this.add(new FixedRule("standalone"));
            this.add(new Eq_Rule());
            this.add(new SDDecl1_Rule());
        }

        private static class SDDecl1_Rule
        extends OrRule {
            private static final long serialVersionUID = 1L;

            SDDecl1_Rule() {
                this.add(new SDDecl1_2_Rule());
                this.add(new SDDecl1_1_Rule());
            }

            @Override
            int matches(CharBuffer buffer) {
                char c = buffer.charAt(0);
                if (c == '\'') {
                    this.theRule = (Rule)this.rules.get(0);
                } else if (c == '\"') {
                    this.theRule = (Rule)this.rules.get(1);
                } else {
                    return 0;
                }
                return this.theRule.matches(buffer);
            }

            private static class SDDecl1_2_Rule
            extends SequenceRule {
                private static final long serialVersionUID = 1L;

                SDDecl1_2_Rule() {
                    this.add(new FixedRule("'"));
                    this.add(new SDDecl2_Rule());
                    this.add(new FixedRule("'"));
                }
            }

            private static class SDDecl1_1_Rule
            extends SequenceRule {
                private static final long serialVersionUID = 1L;

                SDDecl1_1_Rule() {
                    this.add(new FixedRule("\""));
                    this.add(new SDDecl2_Rule());
                    this.add(new FixedRule("\""));
                }
            }
        }

        private static class SDDecl2_Rule
        extends OrRule {
            private static final long serialVersionUID = 1L;

            SDDecl2_Rule() {
                this.add(new FixedRule("yes"));
                this.add(new FixedRule("no"));
            }

            @Override
            int matches(CharBuffer buffer) {
                char c = buffer.charAt(0);
                if (c == 'y') {
                    this.theRule = (Rule)this.rules.get(0);
                } else if (c == 'n') {
                    this.theRule = (Rule)this.rules.get(1);
                } else {
                    return 0;
                }
                return this.theRule.matches(buffer);
            }
        }
    }

    private static class VersionInfo_Rule
    extends SequenceRule {
        private static final long serialVersionUID = 1L;

        VersionInfo_Rule() {
            this.add(new FixedRule("version"));
            this.add(new Eq_Rule());
            this.add(new VersionInfo1_Rule());
        }

        private static class VersionInfo1_Rule
        extends OrRule {
            private static final long serialVersionUID = 1L;

            VersionInfo1_Rule() {
                this.add(new VersionInfo1_2_Rule());
                this.add(new VersionInfo1_1_Rule());
            }

            @Override
            int matches(CharBuffer buffer) {
                char c = buffer.charAt(0);
                if (c == '\'') {
                    this.theRule = (Rule)this.rules.get(0);
                } else if (c == '\"') {
                    this.theRule = (Rule)this.rules.get(1);
                } else {
                    return 0;
                }
                return this.theRule.matches(buffer);
            }

            private static class VersionInfo1_2_Rule
            extends SequenceRule {
                private static final long serialVersionUID = 1L;

                VersionInfo1_2_Rule() {
                    this.add(new FixedRule("'"));
                    this.add(new VersionNum_Rule());
                    this.add(new FixedRule("'"));
                }
            }

            private static class VersionInfo1_1_Rule
            extends SequenceRule {
                private static final long serialVersionUID = 1L;

                VersionInfo1_1_Rule() {
                    this.add(new FixedRule("\""));
                    this.add(new VersionNum_Rule());
                    this.add(new FixedRule("\""));
                }
            }
        }
    }

    private static class EncName_Rule
    extends SequenceRule {
        private static final long serialVersionUID = 1L;
        private final MyLocator encodingLocator = new MyLocator();

        EncName_Rule() {
            this.add(new EncName1_Rule());
            this.add(new EncName2_Rule());
        }

        @Override
        Rule start() {
            OutputSAXParser p = this.getParser();
            p.sb.setLength(0);
            this.encodingLocator.assign(p);
            return super.start();
        }

        @Override
        protected void completed() throws SAXException {
            super.completed();
            OutputSAXParser p = this.getParser();
            p.waitForEncoding = false;
            p.explicitEncoding = p.sb.toString();
            try {
                Charset cs = Charset.forName(p.explicitEncoding);
                Charset origCs = p.decoder.charset();
                boolean ok = false;
                try {
                    byte[] orig = StringUtils.getBytes("<?xml", origCs);
                    if ("<?xml".equals(StringUtils.toString(orig, cs))) {
                        p.decoder = cs.newDecoder();
                        ok = true;
                    }
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
                if (!ok) {
                    p.errorHandler.error(new EncodingMismatchException(p.explicitEncoding, origCs.name(), this.encodingLocator));
                }
            }
            catch (Exception e) {
                UndefinedEncodingException uee = new UndefinedEncodingException(p.explicitEncoding, this.encodingLocator);
                uee.initCause(e);
                e.printStackTrace();
                p.errorHandler.error(uee);
            }
            p.checkEncoding();
        }

        private static class EncName1_Rule
        extends Rule {
            private static final long serialVersionUID = 1L;

            private EncName1_Rule() {
            }

            @Override
            int matches(CharBuffer buffer) {
                char c = buffer.charAt(0);
                return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' ? 1 : 0;
            }

            @Override
            void write(CharBuffer buffer) throws SAXException {
                OutputSAXParser p = this.getParser();
                p.charactersToSb(1);
                this.completed();
            }
        }

        private static class EncName2_Rule
        extends CharSequenceRule {
            private static final long serialVersionUID = 1L;

            private EncName2_Rule() {
            }

            @Override
            boolean matches(char c) {
                return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '_' || c == '.' || c == '-';
            }
        }
    }

    private static class VersionNum_Rule
    extends CharSequenceRule {
        private static final long serialVersionUID = 1L;

        private VersionNum_Rule() {
        }

        @Override
        boolean matches(char c) {
            return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '_' || c == '.' || c == ':' || c == '-';
        }
    }

    private static final class Eq_Rule
    extends Rule {
        private static final long serialVersionUID = 1L;
        boolean beforeEq;

        private Eq_Rule() {
        }

        @Override
        void write(CharBuffer buffer) throws SAXException {
            int pos;
            int remaining = buffer.remaining();
            if (this.beforeEq) {
                pos = 0;
                while (remaining > 0 && S_Rule.matches(buffer.charAt(pos))) {
                    --remaining;
                    ++pos;
                }
                if (pos > 0) {
                    this.parser.charactersSkip(pos);
                    if (remaining == 0) {
                        return;
                    }
                }
                if (buffer.charAt(0) != '=') {
                    throw new SAXParseException("'=' expected", this.parser);
                }
                this.parser.charactersToSb(1);
                --remaining;
                this.beforeEq = false;
            }
            pos = 0;
            while (remaining > 0 && S_Rule.matches(buffer.charAt(pos))) {
                --remaining;
                ++pos;
            }
            if (pos > 0) {
                this.parser.charactersSkip(pos);
            }
            if (remaining > 0) {
                this.completed();
            }
        }

        @Override
        int matches(CharBuffer buffer) {
            char ch = buffer.charAt(0);
            if (ch == '=') {
                this.parser.charactersToSb(1);
                this.beforeEq = false;
                return 1;
            }
            if (S_Rule.matches(ch)) {
                this.parser.charactersSkip(1);
                this.beforeEq = true;
                return 1;
            }
            return 0;
        }
    }

    static class FixedRule
    extends Rule {
        private static final long serialVersionUID = 1L;
        final String content;

        FixedRule(String content) {
            this.content = content;
        }

        @Override
        int matches(CharBuffer buffer) {
            int toCompare = Math.min(this.content.length(), buffer.remaining());
            for (int i = 0; i < toCompare; ++i) {
                if (buffer.charAt(i) == this.content.charAt(i)) continue;
                return 0;
            }
            return toCompare == this.content.length() ? toCompare : -1;
        }

        @Override
        void write(CharBuffer buffer) throws SAXException {
            this.parser.charactersSkipNoNL(this.content.length());
            this.completed();
        }

        @Override
        String getName() {
            return "FixedRule(" + this.content + ")";
        }
    }

    private static abstract class CharSequenceRule
    extends Rule {
        private static final long serialVersionUID = 1L;

        private CharSequenceRule() {
        }

        @Override
        void write(CharBuffer buffer) throws SAXException {
            int pos;
            char c;
            int i;
            int r = buffer.limit();
            OutputSAXParser p = this.getParser();
            char[] ch = p.buffer;
            for (i = pos = buffer.position(); i < r && this.matches(c = ch[i]); ++i) {
                if (c == '\n') {
                    p.columnNumber = 1;
                    ++p.lineNumber;
                    continue;
                }
                ++p.columnNumber;
            }
            int matched = i - pos;
            if (matched > 0) {
                p.absPosition += matched;
                p.sb.append(p.buffer, pos, matched);
                p.listener.characters(p.buffer, pos, matched);
                buffer.position(i);
            }
            if (i < r) {
                this.completed();
            }
        }

        @Override
        int matches(CharBuffer buffer) {
            return this.matches(buffer.charAt(0)) ? 1 : 0;
        }

        abstract boolean matches(char var1);
    }

    private static class OptionalManyRule
    extends OptionalRule {
        private static final long serialVersionUID = 1L;

        OptionalManyRule(Rule childRule) {
            super(childRule);
            childRule.setReturnRule(this);
        }

        @Override
        int matches(CharBuffer buffer) {
            return this.childRule.matches(buffer);
        }

        @Override
        void setReturnRule(Rule returnRule) {
            this.returnRule = returnRule;
        }

        @Override
        void write(CharBuffer buffer) throws SAXException {
            int ms = this.childRule.matches(buffer);
            if (ms < 0) {
                return;
            }
            if (ms > 0) {
                this.parser.rule = this.childRule.start();
                this.parser.rule.write(buffer);
            } else {
                this.completed();
            }
        }

        @Override
        Rule start() {
            this.parser.rule = this.childRule.start();
            return this.parser.rule;
        }

        @Override
        String getName() {
            return "(" + this.childRule.getName() + ")*";
        }
    }

    private static class OptionalRule
    extends Rule {
        private static final long serialVersionUID = 1L;
        Rule childRule;

        OptionalRule(Rule childRule) {
            this.childRule = childRule;
            childRule.parser = this.getParser();
            childRule.parentRule = this;
            childRule.setReturnRule(this.returnRule);
        }

        @Override
        void setReturnRule(Rule returnRule) {
            super.setReturnRule(returnRule);
            this.childRule.setReturnRule(returnRule);
        }

        @Override
        int matches(CharBuffer buffer) {
            return this.childRule.matches(buffer);
        }

        @Override
        void write(CharBuffer buffer) throws SAXException {
            this.childRule.write(buffer);
        }

        @Override
        void setParser(OutputSAXParser parser) {
            super.setParser(parser);
            this.childRule.setParser(parser);
        }

        @Override
        String getName() {
            return "(" + this.childRule.getName() + ")?";
        }

        @Override
        Rule start() {
            return this.childRule.start();
        }
    }

    private static abstract class OrRule
    extends Rule {
        private static final long serialVersionUID = 1L;
        List<Rule> rules = new ArrayList<Rule>();
        Rule theRule;

        private OrRule() {
        }

        public void add(Rule rule) {
            rule.setParser(this.getParser());
            rule.parentRule = this;
            rule.setReturnRule(this.returnRule);
            this.rules.add(rule);
        }

        @Override
        void setReturnRule(Rule returnRule) {
            super.setReturnRule(returnRule);
            for (Rule rule : this.rules) {
                rule.setReturnRule(returnRule);
            }
        }

        @Override
        void setParser(OutputSAXParser parser) {
            super.setParser(parser);
            for (Rule rule : this.rules) {
                rule.setParser(parser);
            }
        }

        @Override
        String getName() {
            StringBuilder toReturn = new StringBuilder("OrRule(");
            for (Rule r : this.rules) {
                if (toReturn.length() != 7) {
                    toReturn.append('|');
                }
                toReturn.append(r.getName());
            }
            toReturn.append(')');
            return toReturn.toString();
        }

        @Override
        public Rule start() {
            return this.theRule.start();
        }

        @Override
        void write(CharBuffer buffer) {
        }
    }

    static class SequenceRule
    extends Rule {
        private static final long serialVersionUID = 1L;
        final List<Rule> rules = new ArrayList<Rule>();
        int pos;

        SequenceRule() {
        }

        public void add(Rule rule) {
            rule.setParser(this.getParser());
            rule.parentRule = this;
            rule.setReturnRule(this);
            this.rules.add(rule);
        }

        @Override
        void setParser(OutputSAXParser parser) {
            if (parser != this.getParser()) {
                super.setParser(parser);
                for (Rule rule : this.rules) {
                    rule.setParser(parser);
                }
            }
        }

        @Override
        int matches(CharBuffer buffer) {
            for (int i = 0; i < this.rules.size(); ++i) {
                Rule rule = this.rules.get(i);
                int ms = rule.matches(buffer);
                if (ms < 0) {
                    return ms;
                }
                if (ms > 0) {
                    this.pos = -i - 1;
                    return ms;
                }
                if (rule instanceof OptionalRule) continue;
                return 0;
            }
            return 0;
        }

        @Override
        void write(CharBuffer buffer) throws SAXException {
            if (this.pos < 0) {
                int p = -this.pos - 1;
                Rule rule = this.rules.get(p);
                rule.start();
                this.parser.rule = rule;
                rule.write(buffer);
                this.pos = p + 1;
                return;
            }
            while (this.pos < this.rules.size()) {
                Rule rule = this.rules.get(this.pos);
                int ms = rule.matches(buffer);
                if (ms < 0) {
                    return;
                }
                ++this.pos;
                if (ms > 0) {
                    this.parser.rule = rule.start();
                    this.parser.rule.write(buffer);
                    if (this.parser.rule == this && buffer.remaining() >= 1) continue;
                    return;
                }
                if (rule instanceof OptionalRule) continue;
                RuleMissingException spe = rule instanceof AttValue_Rule.ClosingValue ? new FixedRuleMissingException((Locator)this.parser, (AttValue_Rule.ClosingValue)rule, (Rule)this) : (rule instanceof FixedRule ? new FixedRuleMissingException((Locator)this.parser, (FixedRule)rule, (Rule)this) : new RuleMissingException(this.parser, rule, this));
                this.parser.errorHandler.fatalError(spe);
                break;
            }
            this.completed();
        }
    }
}

