/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.util.xml;

import de.businesslogics.util.xml.SourceInterval;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.xml.sax.Attributes;

public class OutputSAXAttributes
implements Attributes {
    private final Map<Object, Attribute> attributesMap = new HashMap<Object, Attribute>();
    private final List<Attribute> attributes = new ArrayList<Attribute>();

    @Override
    public int getIndex(String qName) {
        Attribute a = this.attributesMap.get(qName);
        return a == null ? -1 : a.index;
    }

    @Override
    public int getIndex(String uri, String localName) {
        Attribute a = this.attributesMap.get(new QName(uri, localName));
        return a == null ? -1 : a.index;
    }

    @Override
    public int getLength() {
        return this.attributes.size();
    }

    @Override
    public String getLocalName(int index) {
        return this.attributes.get((int)index).localName;
    }

    @Override
    public String getQName(int index) {
        return this.attributes.get((int)index).qName;
    }

    @Override
    public String getType(int arg0) {
        return "CDATA";
    }

    @Override
    public String getType(String arg0) {
        return "CDATA";
    }

    @Override
    public String getType(String arg0, String arg1) {
        return "CDATA";
    }

    @Override
    public String getURI(int index) {
        return this.attributes.get((int)index).uri;
    }

    @Override
    public String getValue(int index) {
        return this.attributes.get((int)index).value;
    }

    public SourceInterval getNameLocation(int index) {
        return this.attributes.get((int)index).nameLocation;
    }

    public SourceInterval getValueLocation(int index) {
        return this.attributes.get((int)index).valueLocation;
    }

    @Override
    public String getValue(String qName) {
        Attribute a = this.attributesMap.get(qName);
        return a == null ? null : a.value;
    }

    @Override
    public String getValue(String uri, String localName) {
        Attribute a = this.attributesMap.get(new QName(uri, localName));
        return a == null ? null : a.value;
    }

    void clear() {
        this.attributes.clear();
        this.attributesMap.clear();
    }

    void addAttribute(String uri, String localName, String qName, String value, SourceInterval nameLocation, SourceInterval valueLocation) {
        Attribute a = new Attribute(this.attributes.size(), uri, localName, qName, value, nameLocation, valueLocation);
        this.attributes.add(a);
        this.attributesMap.put(qName, a);
        if (uri != null && localName != null) {
            this.attributesMap.put(new QName(uri, localName), a);
        }
    }

    private static class Attribute {
        final int index;
        final String uri;
        final String localName;
        final String qName;
        final String value;
        final SourceInterval nameLocation;
        final SourceInterval valueLocation;

        private Attribute(int index, String uri, String localName, String qName, String value, SourceInterval nameLocation, SourceInterval valueLocation) {
            this.index = index;
            this.uri = uri;
            this.localName = localName;
            this.qName = qName;
            this.value = value;
            this.nameLocation = nameLocation;
            this.valueLocation = valueLocation;
        }
    }

    private static class QName {
        private final String uri;
        private final String localName;

        public QName(String uri, String localName) {
            this.uri = uri;
            this.localName = localName;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof QName)) {
                return false;
            }
            QName other = (QName)obj;
            return other.uri.equals(this.uri) && other.localName.equals(this.localName);
        }

        public int hashCode() {
            return this.uri.hashCode() ^ Integer.rotateLeft(this.localName.hashCode(), 16);
        }
    }
}

